﻿using System;
using System.Collections.Generic;
using System.Web.Mvc;
using System.Web.Routing;
using Ninject;
using SandtrapExamples.Data;

namespace SandtrapExamples.Infastructure
{

    public class NinjectDependencyResolver : IDependencyResolver
    {
        private readonly IKernel _kernel;

        public NinjectDependencyResolver(IKernel kernel)
        {
            _kernel = kernel;
        }

        public object GetService(Type serviceType)
        {
            return _kernel.TryGet(serviceType);
        }

        public IEnumerable<object> GetServices(Type serviceType)
        {
            return _kernel.GetAll(serviceType);
        }
    }

    public class DIControllerFactory : DefaultControllerFactory
    {

        private IKernel _Kernel;

        public DIControllerFactory()
        {
            _Kernel = new StandardKernel();
            AddBindings();
        }

        protected override IController GetControllerInstance(RequestContext requestContext, Type controllerType)
        {
            return controllerType == null ? null : (IController)_Kernel.Get(controllerType);
        }

        public IKernel GetKernel()
        {
            return _Kernel;
        }

        private void AddBindings()
        {
            _Kernel.Bind<IStatusDB>().To<StatusDB>();
            _Kernel.Bind<IPrimeMinisterDB>().To<PrimeMinisterDB>();
            _Kernel.Bind<ICountryDB>().To<CountryDB>();
            _Kernel.Bind<ITimeCodeDB>().To<TimeCodeDB>();
            _Kernel.Bind<IFolderDB>().To<FolderDB>();
            _Kernel.Bind<IOrganisationDB>().To<OrganisationDB>();
            _Kernel.Bind<IPersonDB>().To<PersonDB>();
        }

    }
}