﻿using System.Collections.Generic;
using SandtrapExamples.Models;

namespace SandtrapExamples.Data
{

    public interface IOrganisationDB
    {
        List<Organisation> Fetch();
        Organisation Get();
        void Save(Organisation organisation);
    }

    public class OrganisationDB : IOrganisationDB
    {

        private static Organisation _CurrentOrganisation;

        public List<Organisation> Fetch()
        {
            List<Organisation> consultants = new List<Organisation>();
            consultants.Add(new Organisation(1, "Aurecon"));
            consultants.Add(new Organisation(2, "Bestec"));
            consultants.Add(new Organisation(3, "Lucid Consulting"));
            consultants.Add(new Organisation(4, "Kinhill"));
            consultants.Add(new Organisation(5, "Redding"));
            return consultants;
        }

        public Organisation Get()
        {
            return _CurrentOrganisation;
        }

        public void Save(Organisation organisation)
        {
            _CurrentOrganisation = organisation;
        }
    }
}