﻿using System.Collections.Generic;
using System.Linq;
using System.Web.Mvc;
using Sandtrap.Web.Filters;
using SandtrapExamples.Data;
using SandtrapExamples.Models;
using SandtrapExamples.ViewModels;

namespace SandtrapExamples.Controllers
{


    public class SelectController : Controller
    {
        private IStatusDB _StatusRepository;
        private IPrimeMinisterDB _PrimeMinisterRepository;
        private ICountryDB _CountryRepository;
        private ITimeCodeDB _TimeCodeRepository;
        private IFolderDB _FolderRepository;
        private IOrganisationDB _OrganisationDB;
        private IPersonDB _PersonDB;

        private static string _Profession;

        public SelectController(IStatusDB statusRepository, 
            IPrimeMinisterDB primeMinisterRepository,
            ICountryDB countryDB,
            ITimeCodeDB timeCodeRepository, 
            IFolderDB folderRepository,
            IOrganisationDB organisationDB,
            IPersonDB PersonDB)
        {
            _StatusRepository = statusRepository;
            _PrimeMinisterRepository = primeMinisterRepository;
            _CountryRepository = countryDB;
            _TimeCodeRepository = timeCodeRepository;
            _FolderRepository = folderRepository;
            _OrganisationDB = organisationDB;
            _PersonDB = PersonDB;
        }


        [HttpGet]
        public ActionResult Index()
        {
            SelectViewModel model = new SelectViewModel();
            model.Profession = _Profession;
            if (TempData["Status"] != null)
            {
                model.Status = (ProjectStatus)TempData["Status"];
                model.Message = "No call was made to the data store to get the project status";
            }
            else
            {
                model.Status = _StatusRepository.Get();
            }
            if (TempData["PrimeMinister"] != null)
            {
                model.PrimeMinister = TempData["PrimeMinister"] as PrimeMinister;
                model.Message = "No call was made to the data store to get the prime minister";
            }
            else
            {
                model.PrimeMinister = _PrimeMinisterRepository.Get();
            }
            if (TempData["Country"] != null)
            {
                model.Country = TempData["Country"] as Country;
                model.Message = "No call was made to the data store to get the country";
            }
            else
            {
                model.Country = _CountryRepository.Get();
            }
            if (TempData["TimeCode"] != null)
            {
                model.TimeCode = TempData["TimeCode"] as TimeCode;
                model.Message = "No call was made to the data store to get the time code";
            }
            else
            {
                model.TimeCode = _TimeCodeRepository.Get();
            }
            if (TempData["Folder"] != null)
            {
                model.Folder = TempData["Folder"] as Folder;
                model.Message = "No call was made to the data store to get the folder";
            }
            else
            {
                model.Folder = _FolderRepository.Get();
            }
            if (TempData["Contact"] != null)
            {
                model.ContactPerson = TempData["Contact"] as Person;
                model.Message = "No call was made to the data store to get the contact person or their organisation";
            }
            else
            {
                model.ContactPerson = _PersonDB.Get();
            }


            return View(model);
        }

        [HttpGet]
        public ActionResult Help()
        {
            return View();
        }

        [HttpGet]
        public ActionResult EnumSelect()
        {
            EnumSelectViewModel model = new EnumSelectViewModel();
            model.Status = _StatusRepository.Get();
            return View(model);
        }

        [HttpPost]
        public ActionResult EnumSelect(EnumSelectViewModel model)
        {
            _StatusRepository.Save(model.Status);
            TempData["Status"] = model.Status;
            return RedirectToAction("Index");
        }

        [HttpGet]
        public ActionResult ValueSelect()
        {
            ValueSelectViewModel model = new ValueSelectViewModel();
            model.Profession = _Profession;
            ConfigureValueModel(model);
            return View(model);
        }

        [HttpPost]
        public ActionResult ValueSelect(ValueSelectViewModel model)
        {
            _Profession = model.Profession;
            return RedirectToAction("Index");
        }

        [HttpGet]
        public ActionResult BasicSelect()
        {
            BasicSelectViewModel model = new BasicSelectViewModel();
            model.PrimeMinister = _PrimeMinisterRepository.Get();
            ConfigureBasicModel(model);
            return View(model);
        }

        [HttpPost]
        public ActionResult BasicSelect(BasicSelectViewModel model)
        {
            if (!ModelState.IsValid)
            {
                //var modelStateErrors = this.ModelState.Keys.SelectMany(key => this.ModelState[key].Errors);
                ConfigureBasicModel(model);
                return View(model);
            }
            _PrimeMinisterRepository.Save(model.PrimeMinister);
            TempData["PrimeMinister"] = model.PrimeMinister;
            return RedirectToAction("Index");
        }

        [HttpGet]
        public ActionResult AjaxSelect()
        {
            AjaxSelectViewModel model = new AjaxSelectViewModel();
            model.Country = _CountryRepository.Get();
            return View(model);
        }

        [HttpPost]
        public ActionResult AjaxSelect(AjaxSelectViewModel model)
        {
            if (!ModelState.IsValid)
            {
                return View(model);
            }
            _CountryRepository.Save(model.Country);
            TempData["Country"] = model.Country;
            return RedirectToAction("Index");
        }

        [HttpGet]
        public ActionResult GroupSelect()
        {
            GroupSelectViewModel model = new GroupSelectViewModel();
            model.TimeCode = _TimeCodeRepository.Get();
            ConfigureGroupModel(model);
            return View(model);
        }

        [HttpPost]
        public ActionResult GroupSelect(GroupSelectViewModel model)
        {
            if (!ModelState.IsValid)
            {
                ConfigureGroupModel(model);
                return View(model);
            }
            _TimeCodeRepository.Save(model.TimeCode);
            TempData["TimeCode"] = model.TimeCode;
            return RedirectToAction("Index");
        }

        [HttpGet]
        public ActionResult HierarchialSelect()
        {
            HierarchialSelectViewModel model = new HierarchialSelectViewModel();
            model.Folder = _FolderRepository.Get();
            ConfigureHierarchialModel(model);
            return View(model);
        }

        [HttpPost]
        public ActionResult HierarchialSelect(HierarchialSelectViewModel model)
        {
            if (!ModelState.IsValid)
            {
                ConfigureHierarchialModel(model);
                return View(model);
            }
            _FolderRepository.Save(model.Folder);
            TempData["Folder"] = model.Folder;
            return RedirectToAction("Index");
        }

        [HttpGet]
        public ActionResult CascadeSelect()
        {
            CascadeSelectViewModel model = new CascadeSelectViewModel();
            model.ContactPerson = _PersonDB.Get();
            ConfigureCascadeModel(model);
            return View(model);
        }

        [HttpPost]
        public ActionResult CascadeSelect(CascadeSelectViewModel model)
        {
            if (!ModelState.IsValid)
            {
                var modelStateErrors = this.ModelState.Keys.SelectMany(key => this.ModelState[key].Errors);
                ConfigureCascadeModel(model);
                return View(model);
            }
            _PersonDB.Save(model.ContactPerson);
            TempData["Contact"] = model.ContactPerson;
            return RedirectToAction("Index");

        }

        #region .Ajax methods 

        [AjaxOnly]
        public JsonResult FetchFolders()
        {
            List<Folder> folders = _FolderRepository.Fetch();
            // Disable one of the folders
            folders[0].SubFolders[0].SubFolders[1].IsActive = false;
            return Json(folders, JsonRequestBehavior.AllowGet);
        }

        [AjaxOnly]
        public JsonResult FetchCountries(string startsWith)
        {
            IEnumerable<Country> countries = _CountryRepository.Fetch()
                .Where(c => c.Name.StartsWith(startsWith, System.StringComparison.CurrentCultureIgnoreCase))
                .OrderBy(c => c.Name);
            return Json(countries, JsonRequestBehavior.AllowGet);
        }

        public JsonResult FetchEmployees(int organisation)
        {
            List<Person> employees = _PersonDB.Fetch(organisation);
            return Json(employees, JsonRequestBehavior.AllowGet);
        }

        #endregion

        #region .Helper methods 

        private void ConfigureValueModel(ValueSelectViewModel model)
        {
            List<string> professions = new List<string>() { "Firefighter", "Paramedic", "Nurse", "Dentist", 
                "Pilot", "Doctor", "Pharmacist", "Veterinarian", "Air traffic controller", "Farmer" };
            model.ProfessionList = professions;
        }

        private void ConfigureBasicModel(BasicSelectViewModel model)
        {
            model.PrimeMinisterList = _PrimeMinisterRepository.Fetch();
        }

        private void ConfigureGroupModel(GroupSelectViewModel model)
        {
            model.TimeCodeList = _TimeCodeRepository.Fetch();
        }

        private void ConfigureHierarchialModel(HierarchialSelectViewModel model)
        {
            model.FolderList = _FolderRepository.Fetch();
        }

        private void ConfigureCascadeModel(CascadeSelectViewModel model)
        {
            model.ConsultantList = _OrganisationDB.Fetch();
            if (model.ContactPerson != null)
            {
                model.Consultant = model.ContactPerson.Organisation;
                model.ContactPersonList = _PersonDB.Fetch(model.ContactPerson.Organisation.ID);
            }
        }

        #endregion


    }
}
