﻿using System.Collections;
using System.Web.Mvc;

namespace Sandtrap.Web.Extensions
{

    /// <summary>
    /// 
    /// </summary>
    public static class ModelMetadataExtensions
    {

        /// <summary>
        /// Returns a value indicating if the metadata model is a collection.
        /// </summary>
        /// <param name="metaData">
        /// The metadata.
        /// </param>
        public static bool IsCollection(this ModelMetadata metaData)
        {
            if (metaData.ModelType == typeof(string))
            {
                return false;
            }
            return typeof(IEnumerable).IsAssignableFrom(metaData.ModelType);
        }







        /// <summary>
        /// Returns a value indicating if the metadata contains the HiddenInput attribute.
        /// </summary>
        /// <param name="metaData">
        /// The metadata.
        /// </param>
        public static bool IsHidden(this ModelMetadata metaData)
        {
            return metaData.TemplateHint == "HiddenInput";
        }

        /// <summary>
        /// Returns a value indicating if the metadata model is a boolean value.
        /// </summary>
        /// <param name="metaData">
        /// The metadata.
        /// </param>
        public static bool IsBoolean(this ModelMetadata metaData)
        {
            return metaData.ModelType == typeof(bool);
        }

        /// <summary>
        /// Returns a value indicating if the metadata DataType is currency.
        /// </summary>
        /// <param name="metaData">
        /// The metadata.
        /// </param>
        public static bool IsCurrency(this ModelMetadata metaData)
        {
            return metaData.DataTypeName == "Currency";
        }

        /// <summary>
        /// 
        /// </summary>
        /// <param name="metaData"></param>
        /// <returns></returns>
        public static bool IsDate(this ModelMetadata metaData)
        {
            return metaData.DataTypeName == "Date";
        }

        /// <summary>
        /// Returns a value indicating if the metadata TemplateHint is percent.
        /// </summary>
        /// <param name="metaData">
        /// The metadata.
        /// </param>
        public static bool IsPercent(this ModelMetadata metaData)
        {
            return metaData.TemplateHint == "Percent";
        }

        /// <summary>
        /// Returns a value indicating if the metadata TemplateHint is numeric or percent, or the DataType is currency.
        /// </summary>
        /// <param name="metaData">
        /// The metadata.
        /// </param>
        public static bool IsNumeric(this ModelMetadata metaData)
        {
            return metaData.TemplateHint == "Numeric" || metaData.IsCurrency() || metaData.IsPercent();
        }

    }

}
