﻿using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using SandtrapExamples.Models;

namespace SandtrapExamples.ViewModels
{

    public class BasicSelectViewModel
    {
        [Display(Name = "Select the current Prime Minister")]
        [Required(ErrorMessage = "Please select the prime minister")]
        public PrimeMinister PrimeMinister { get; set; }

        public List<PrimeMinister> PrimeMinisterList { get; set; }






        [DataType(DataType.Currency)]
        [Range(0, 10000, ErrorMessage = "The amount must be between {1} and {2}")]
        public decimal Amount { get; set; }

        [DisplayFormat(DataFormatString = "{0:N4}")]
        public decimal Number { get; set; }

        [Range(0, 1, ErrorMessage = "The amount must be between {1} and {2}")]
        [DisplayFormat(DataFormatString = "{0:P0}")]
        public decimal Percent { get; set; }



    }

}