﻿using System;
using System.ComponentModel.DataAnnotations;

namespace SandtrapExamples.Models
{
    public class TimeRecord
    {
        public TimeRecord()
        {
        }
        public TimeRecord(int id, DateTime weekEnding, float hours)
        {
            ID = id;
            WeekEnding = weekEnding;
            Hours = hours;
        }

        public int? ID { get; set; }

        [Display(Name = "Week ending")]
        [DataType(DataType.Date)]
        [DisplayFormat(DataFormatString = "{0: d MMMM yyyy}")]
        public DateTime WeekEnding { get; set; }

        public float Hours { get; set; }

    }
}