﻿
using System.ComponentModel.DataAnnotations;
namespace SandtrapExamples.Models
{
    public class Person
    {
        public Person()
        {
            IsActive = true;
        }
        public Person(int id, string name, Organisation organisation) : this()
        {
            ID = id;
            Name = name;
            Organisation = organisation;
        }
        public int ID { get; set; }
        public string Name { get; set; }
        [Required]
        public Organisation Organisation { get; set; }
        public bool IsActive { get; set; }
        public override string ToString()
        {
            return Name;
        }
    }
}