﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.ComponentModel.DataAnnotations;
using System.Web.Mvc;
using Sandtrap.Web.DataAnnotations;

namespace SandtrapExamples.Models
{

    [TableDisplay(IncludeRowNumbers = true, Controller = "Contact", ViewAction = "Details", 
        EditAction = "Edit", IDProperty = "ID")]
    public class Contact
    {

        public Contact()
        {
        }

        public Contact(int id, string firstName, string lastName, string mobile, string email)
        {
            ID = id;
            FirstName = firstName;
            LastName = lastName;
            Mobile = mobile;
            Email = email;
        }

        [HiddenInput]
        public int ID { get; set; }

        [Display(Name = "First name")]
        [TableColumn(Exclude = true)]
        public string FirstName { get; set; }

        [Display(Name = "Last name")]
        [TableColumn(Exclude = true)]
        public string LastName { get; set; }

        public string Name
        {
            get { return string.Format("{0} {1}", FirstName, LastName); }
        }

        [DataType(DataType.EmailAddress)]
        [DisplayFormat(NullDisplayText = "Not assigned")]
        public string Email { get; set; }

        [DisplayFormat(NullDisplayText = "Not assigned")]
        public string Mobile { get; set; }

        [DisplayFormat(NullDisplayText = "Not assigned")]
        [TableColumn(Exclude = true)]
        public string Address { get; set; }

    }
}