﻿using System.ComponentModel.DataAnnotations;
using System.Web.Mvc;
using Sandtrap.Web.DataAnnotations;

namespace SandtrapExamples.Models
{

    [TableEdit(IsActiveProperty = "IsActive", IsDirtyProperty = "IsDirty")]
    public class ConsultantFee
    {

        public ConsultantFee()
        {
            IsActive = true;
        }

        public ConsultantFee(int id, Organisation consultant, string phase, bool isVariation, decimal amount)
        {
            ID = id;
            Consultant = consultant;
            Phase = phase;
            IsVariation = isVariation;
            Amount = amount;
            IsActive = true;
        }

        [HiddenInput]
        public int? ID { get; set; }

        [Required(ErrorMessage = "Please select a consultant")]
        [TableColumn(NoRepeat = true, IsReadOnly = true, DisplayProperty = "Name")]
        [TableLink(Controller = "Organisation")]
        [TableSelect(IDProperty = "ID", DisplayProperty = "Name")]
        public Organisation Consultant { get; set; }

        //[TableColumn(DisplayProperty = "Name", NoRepeat = true)]
        //public Organisation Consultant { get; set; }

        //[TableColumn(DisplayProperty = "Name")]
        //public Organisation Consultant { get; set; }

        //public Organisation Consultant { get; set; }

        public string Phase { get; set; }

        [Display(Name = "Variation")]
        public bool IsVariation { get; set; }

        [TableColumn(IncludeTotal = true)]
        [DisplayFormat(DataFormatString = "{0:C}")]
        public decimal Amount { get; set; }

        [HiddenInput]
        public bool IsActive { get; set; }

        [HiddenInput]
        public bool IsDirty { get; set; }

    }

}