﻿using System;
using System.ComponentModel.DataAnnotations;
using Sandtrap.Web.DataAnnotations;

namespace SandtrapExamples.Models
{

    public enum AccountStatus : int
    {
        Draft,
        Issued,
        Paid
    }

    [TableLink(DisplayProperty = "ID", IDProperty = "ID", Controller = "Table", Action = "Account")]
    public class AccountLedger
    {
        public AccountLedger()
        {
        }
        public AccountLedger(int id, DateTime date, decimal amount, AccountStatus status)
        {
            ID = id;
            Date = date;
            Amount = amount;
            Status = status;
        }

        [Display(Name = "Invoice", Order = 1)]
        [DisplayFormat(DataFormatString = "{0:00000}")]
        public int ID { get; set; }

        [Display(Name = "Status", Order = 6)]
        public AccountStatus Status { get; set; }

        [Display(Order = 2)]
        [DisplayFormat(DataFormatString = "{0:dddd, d MMMM yyyy}")]
        public DateTime Date { get; set; }

        [Display(Order = 3)]
        [DataType(DataType.Currency)]
        [DisplayFormat(DataFormatString = "{0:C}")]
        [TableColumn(IncludeTotal = true)]
        public decimal Amount { get; set; }

        [Display(Order = 4)]
        [DataType(DataType.Currency)]
        [DisplayFormat(DataFormatString = "{0:C}")]
        [TableColumn(IncludeTotal = true)]
        public decimal GST
        {
            get { return Amount * 0.1M; }
        }

        [Display(Order = 5)]
        [DataType(DataType.Currency)]
        [DisplayFormat(DataFormatString = "{0:C}")]
        [TableColumn(IncludeTotal = true)]
        public decimal Total
        {
            get { return Amount * 1.1M; }
        }

    }
}