﻿using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.Linq;
using System.Web;

namespace SandtrapExamples.Models
{

    public class Account
    {

        [Display(Name = "Invoice")]
        [DisplayFormat(DataFormatString = "{0:00000}")]
        public int ID { get; set; }

        [DisplayFormat(DataFormatString = "{0:dddd, d MMMM yyyy}")]
        public DateTime Date { get; set; }

        [DisplayFormat(DataFormatString = "{0:N2}")]
        public string Details { get; set; }

        [DataType(DataType.Currency)]
        [DisplayFormat(DataFormatString = "{0:C}")]
        public decimal Amount { get; set; }


    }

}