﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using SandtrapExamples.Models;

namespace SandtrapExamples.Data
{

    public interface ITimeCodeDB
    {
        Dictionary<string, List<TimeCode>> Fetch();
        TimeCode Get();
        void Save(TimeCode timeCode);
    }

    public class TimeCodeDB : ITimeCodeDB
    {
        private static TimeCode _CurrentTimeCode { get; set; }

        public Dictionary<string, List<TimeCode>> Fetch()
        {
            Dictionary<string, List<TimeCode>> timeCodes = new Dictionary<string, List<TimeCode>>();
            timeCodes.Add("Internal", new List<TimeCode>());
            timeCodes["Internal"].Add(new TimeCode(1, "Administration"));
            timeCodes["Internal"].Add(new TimeCode(2, "Marketing"));
            timeCodes["Internal"].Add(new TimeCode(3, "Training"));
            timeCodes["Internal"].Add(new TimeCode(4, "Other"));
            timeCodes["Internal"].Add(new TimeCode(5, "Another time code starting with 'A'"));
            timeCodes.Add("Leave", new List<TimeCode>());
            timeCodes["Leave"].Add(new TimeCode(6, "Annual leave"));
            timeCodes["Leave"].Add(new TimeCode(7, "Long service leave"));
            timeCodes["Leave"].Add(new TimeCode(8, "Sick leave"));
            return timeCodes;
        }

        public TimeCode Get()
        {
            return _CurrentTimeCode;
        }

        public void Save(TimeCode timeCode)
        {
            _CurrentTimeCode = timeCode;
        }
    }

}