﻿using System.Collections.Generic;
using SandtrapExamples.Models;
using System.Linq;

namespace SandtrapExamples.Data
{

    public interface IPersonDB
    {
        List<Person> Fetch(int organisation);
        Person Get();
        void Save(Person person);
    }

    public class PersonDB : IPersonDB
    {
        private IOrganisationDB _OrganisationRepository;

        public PersonDB(IOrganisationDB organisationRepository)
        {
            _OrganisationRepository = organisationRepository;
        }

        private static Person _CurrentPerson;

        public List<Person> Fetch(int ID)
        {
            Organisation organisation = _OrganisationRepository.Fetch().Find(o => o.ID == ID);
            List<Person> employees = new List<Person>();
            if (ID == 1)
            {
                employees.Add(new Person(1, "Peter Jones", organisation));
                employees.Add(new Person(2, "Robert Bock", organisation));
                employees.Add(new Person(3, "Andrew Jones", organisation));
            }
            else if (ID == 2)
            {
                employees.Add(new Person(4, "Stephen Brown", organisation));
                employees.Add(new Person(5, "Alfred Wong", organisation));
            }
            else if (ID == 3)
            {
                employees.Add(new Person(6, "Janet Peters", organisation));
                employees.Add(new Person(7, "Michael Peters", organisation));
                employees.Add(new Person(8, "Ian Roberts", organisation));
                employees.Add(new Person(9, "Stephen Jones", organisation));
            }
            else if (ID == 4)
            {
                employees.Add(new Person(10, "Margaret Trent", organisation));
                employees.Add(new Person(11, "Jo Redding", organisation));
            }
            else
            {
                employees.Add(new Person(12, "Adrian Walters", organisation));
                employees.Add(new Person(13, "Peter Brock", organisation));
                employees.Add(new Person(14, "Claire Fox", organisation));
            }
            return employees;
        }

        public Person Get()
        {
            return _CurrentPerson;
        }

        public void Save(Person person)
        {
            _CurrentPerson = person;
        }
    }
}