﻿using System.Collections.Generic;
using SandtrapExamples.Models;

namespace SandtrapExamples.Data
{

    public interface IOrganisationDB
    {
        List<Organisation> Fetch();
        Organisation Get(int ID);
        void Save(Organisation organisation);
    }

    public class OrganisationDB : IOrganisationDB
    {
        private static List<Organisation> _Organisations;

        public List<Organisation> Fetch()
        {
            if (_Organisations == null)
            {
                _Organisations = new List<Organisation>();
                _Organisations.Add(new Organisation(1, "Aurecon"));
                _Organisations.Add(new Organisation(2, "Bestec"));
                _Organisations.Add(new Organisation(3, "Lucid Consulting"));
                _Organisations.Add(new Organisation(4, "Kinhill"));
                _Organisations.Add(new Organisation(5, "Redding"));

            }
            return _Organisations;
        }

        public Organisation Get(int ID)
        {
            return _Organisations.Find(o => o.ID == ID);
        }

        public void Save(Organisation organisation)
        {
            int index = _Organisations.FindIndex(c => c.ID == organisation.ID);
            _Organisations[index] = organisation;
        }
    }
}