﻿using System.Collections.Generic;
using SandtrapExamples.Models;

namespace SandtrapExamples.Data
{

    public interface IFolderDB
    {
        List<Folder> Fetch();
        Folder Get();
        void Save(Folder folder);
    }

    public class FolderDB : IFolderDB
    {

        private static Folder _CurrentFolder { get; set; }

        public List<Folder> Fetch()
        {
            List<Folder> folders = new List<Folder>();
            folders.Add(new Folder(1, "Documents"));
            folders[0].SubFolders.Add(new Folder(2, "Financial"));
            folders[0].SubFolders[0].SubFolders.Add(new Folder(3, "Accounting"));
            folders[0].SubFolders[0].SubFolders.Add(new Folder(4, "Bank Statements"));

            folders[0].SubFolders[0].SubFolders[1].SubFolders.Add(new Folder(20, "A really long folder name"));
            folders[0].SubFolders[0].SubFolders[1].SubFolders.Add(new Folder(21, "A ridiculously long folder name that needs to be trimmed at the start and the end"));

            folders[0].SubFolders[0].SubFolders.Add(new Folder(5, "Shares"));
            folders[0].SubFolders.Add(new Folder(6, "Projects"));
            folders.Add(new Folder(7, "Photos"));
            folders[1].SubFolders.Add(new Folder(8, "Family"));
            folders[1].SubFolders.Add(new Folder(9, "Friends"));
            folders[1].SubFolders.Add(new Folder(10, "Holidays"));
            folders[1].SubFolders[2].SubFolders.Add(new Folder(11, "Bali"));
            folders[1].SubFolders[2].SubFolders.Add(new Folder(12, "Europe"));
            folders.Add(new Folder(13, "Work"));
            return folders;
        }

        public Folder Get()
        {
            return _CurrentFolder;
        }

        public void Save(Folder folder)
        {
            _CurrentFolder = folder;
        }

    }
}