﻿using System.Collections.Generic;
using SandtrapExamples.Models;

namespace SandtrapExamples.Data
{

    public interface ICountryDB
    {
        List<Country> Fetch();
        Country Get();
        void Save(Country country);
    }

    public class CountryDB : ICountryDB
    {

        private static Country _CurrentCountry;

        public List<Country> Fetch()
        {
            List<Country> countries = new List<Country>();
            countries.Add(new Country(1, "Afghanistan", "South-Central Asia"));
            countries.Add(new Country(2, "Albania", "Southern Europe"));
            countries.Add(new Country(3, "Algeria", "Northern Africa"));
            countries.Add(new Country(4, "American Samoa", "Polynesia, Oceania"));
            countries.Add(new Country(5, "Andorra", "Southern Europe"));
            countries.Add(new Country(6, "Angola", "Central Africa"));
            countries.Add(new Country(7, "Anguilla", "Leeward Islands, Caribbean"));
            countries.Add(new Country(8, "Antarctica", "Antarctica"));
            countries.Add(new Country(9, "Antigua and Barbuda", "Leeward Islands, Caribbean"));
            countries.Add(new Country(10, "Argentina", "Southern South America"));
            countries.Add(new Country(11, "Armenia", "Western Asia"));
            countries.Add(new Country(12, "Aruba", "Leeward Islands, Caribbean"));
            countries.Add(new Country(13, "Australia", "Australia"));
            countries.Add(new Country(14, "Austria", "Western Europe"));
            countries.Add(new Country(15, "Azerbaijan", "Caucasus, Western Asia"));
            countries.Add(new Country(16, "Bahamas", "Caribbean"));
            countries.Add(new Country(17, "Bahrain", "Arabian Peninsula, Middle East"));
            countries.Add(new Country(18, "Bangladesh", "South-Central Asia"));
            countries.Add(new Country(19, "Barbados", "Lesser Antilles, Caribbean"));
            countries.Add(new Country(20, "Belarus", "Eastern Europe"));
            countries.Add(new Country(21, "Belgium", "Western Europe"));
            countries.Add(new Country(22, "Belize", "Central America"));
            countries.Add(new Country(23, "Benin", "West Africa"));
            countries.Add(new Country(24, "Bermuda", "North America"));
            countries.Add(new Country(25, "Bhutan", "South-Central Asia"));
            countries.Add(new Country(26, "Bolivia", "Central South America"));
            countries.Add(new Country(27, "Bosnia and Herzegovina", "Southern Europe"));
            countries.Add(new Country(28, "Botswana", "Southern Africa"));
            countries.Add(new Country(29, "Brazil", "Central Eastern South America"));
            countries.Add(new Country(30, "Brunei Darussalam", "Southeast Asia"));
            countries.Add(new Country(31, "Bulgaria", "Eastern Europe"));
            countries.Add(new Country(32, "Burkina Faso", "West Africa"));
            countries.Add(new Country(33, "Burundi", "Eastern Africa, African Great Lakes"));
            countries.Add(new Country(34, "Cambodia", "South-East Asia"));
            countries.Add(new Country(35, "Cameroon", "Central Africa"));
            countries.Add(new Country(36, "Canada", "North North America"));
            countries.Add(new Country(37, "Cape Verde", "West Africa"));
            countries.Add(new Country(38, "Cayman Islands", "Greater Antilles, Caribbean"));
            countries.Add(new Country(39, "Central African Republic", "Central Africa"));
            countries.Add(new Country(40, "Chad", "Central Africa"));
            countries.Add(new Country(41, "Chile", "Western South America"));
            countries.Add(new Country(42, "China", "Eastern Asia"));
            countries.Add(new Country(43, "Christmas Island", "Southeast Asia"));
            countries.Add(new Country(44, "Cocos Islands", "South-East Asia, Australia"));
            countries.Add(new Country(45, "Colombia", "North West South America"));
            countries.Add(new Country(46, "Comoros", "Eastern Africa"));
            countries.Add(new Country(47, "Democratic Republic of the Congo [Kinshasa]", "Central Africa"));
            countries.Add(new Country(48, "Congo, Republic of", "Central Africa"));
            countries.Add(new Country(49, "Cook Islands", "Polynesia, Oceania"));
            countries.Add(new Country(50, "Costa Rica", "Central America"));
            countries.Add(new Country(51, "Ivory Coast", "West Africa"));
            countries.Add(new Country(52, "Croatia", "Southern Europe"));
            countries.Add(new Country(53, "Cuba", "Greater Antilles, Caribbean"));
            countries.Add(new Country(54, "Cyprus", "Mediterranean, Western Asia"));
            countries.Add(new Country(55, "Czech Republic", "Eastern Europe"));
            countries.Add(new Country(56, "Denmark", "Northern Europe"));
            countries.Add(new Country(57, "Djibouti", "Eastern Africa"));
            countries.Add(new Country(58, "Dominica", "Lesser Antilles, Caribbean"));
            countries.Add(new Country(59, "Dominican Republic", "Greater Antilles, Caribbean"));
            countries.Add(new Country(60, "East Timor", "South-East Asia"));
            countries.Add(new Country(61, "Ecuador", "North West South America"));
            countries.Add(new Country(62, "Egypt", "Africa, Middle East"));
            countries.Add(new Country(63, "El Salvador", "Central America"));
            countries.Add(new Country(64, "Equatorial Guinea", "Central Africa"));
            countries.Add(new Country(65, "Eritrea", "Eastern Africa"));
            countries.Add(new Country(66, "Estonia", "Northern Europe"));
            countries.Add(new Country(67, "Ethiopia", "Eastern Africa"));
            countries.Add(new Country(68, "Falkland Islands", "Southern South America"));
            countries.Add(new Country(69, "Faroe Islands", "Northern Europe"));
            countries.Add(new Country(70, "Fiji", "Melanesia, Oceania"));
            countries.Add(new Country(71, "Finland", "Northern Europe"));
            countries.Add(new Country(72, "France", "Western Europe"));
            countries.Add(new Country(73, "French Guiana", "Northern South America"));
            countries.Add(new Country(74, "French Polynesia", "Polynesia, Oceania"));
            countries.Add(new Country(75, "French Southern Territories", "Southern South America, Antarctic"));
            countries.Add(new Country(76, "Gabon", "Central Africa"));
            countries.Add(new Country(77, "Gambia", "West Africa"));
            countries.Add(new Country(78, "Georgia", "Western Asia"));
            countries.Add(new Country(79, "Germany", "Western Europe"));
            countries.Add(new Country(80, "Ghana", "West Africa"));
            countries.Add(new Country(81, "Gibraltar", "Southern Europe"));
            countries.Add(new Country(82, "Great Britain", "Northern Europe"));
            countries.Add(new Country(83, "Greece", "Southern Europe"));
            countries.Add(new Country(84, "Greenland", "North America"));
            countries.Add(new Country(85, "Grenada", "Lesser Antilles, Caribbean"));
            countries.Add(new Country(86, "Guadeloupe", "Lesser Antilles, Caribbean"));
            countries.Add(new Country(87, "Guam", "Micronesia, Oceania"));
            countries.Add(new Country(88, "Guatemala", "Central America"));
            countries.Add(new Country(89, "Guinea", "West Africa"));
            countries.Add(new Country(90, "Guinea-Bissau", "West Africa"));
            countries.Add(new Country(91, "Guyana", "North Eastern South America"));
            countries.Add(new Country(92, "Haiti", "Greater Antilles, Caribbean"));
            countries.Add(new Country(93, "Holy See", "Southern Europe within Italy"));
            countries.Add(new Country(94, "Honduras", "Central America"));
            countries.Add(new Country(95, "Hong Kong", "Eastern Asia"));
            countries.Add(new Country(96, "Hungary", "Eastern Europe"));
            countries.Add(new Country(97, "Iceland", "Northern Europe"));
            countries.Add(new Country(98, "India", "South-Central Asia"));
            countries.Add(new Country(99, "Indonesia", "Maritime South-East Asia"));
            countries.Add(new Country(100, "Iran", "South-Central Asia"));
            countries.Add(new Country(101, "Iraq", "Middle East, Western Asia"));
            countries.Add(new Country(102, "Ireland", "Northern Europe"));
            countries.Add(new Country(103, "Israel", "Middle East, Western Asia"));
            countries.Add(new Country(104, "Italy", "Southern Europe"));
            countries.Add(new Country(105, "Jamaica", "Greater Antilles, Caribbean"));
            countries.Add(new Country(106, "Japan", "Eastern Asia"));
            countries.Add(new Country(108, "Jordan", "Middle East, Western Asia"));
            countries.Add(new Country(109, "Kazakhstan", "Central Asia"));
            countries.Add(new Country(110, "Kenya", "Eastern Africa"));
            countries.Add(new Country(111, "Kiribati", "Micronesia, Oceania"));
            countries.Add(new Country(112, "Korea, Democratic People's Rep. (North Korea)", "Eastern Asia"));
            countries.Add(new Country(113, "Korea, Republic of (South Korea)", "Eastern Asia"));
            countries.Add(new Country(114, "Kosovo", "Southern Europe"));
            countries.Add(new Country(115, "Kuwait", "Middle East, Western Asia"));
            countries.Add(new Country(116, "Kyrgyzstan", "Central Asia"));
            countries.Add(new Country(117, "Lao, People's Democratic Republic", "South-East Asia"));
            countries.Add(new Country(118, "Latvia", "Northern Europe"));
            countries.Add(new Country(119, "Lebanon", "Middle East, Western Asia"));
            countries.Add(new Country(120, "Lesotho", "Southern Africa"));
            countries.Add(new Country(121, "Liberia", "West Africa"));
            countries.Add(new Country(122, "Libya", "Northern Africa"));
            countries.Add(new Country(123, "Liechtenstein", "Western Europe"));
            countries.Add(new Country(124, "Lithuania", "Northern Europe"));
            countries.Add(new Country(125, "Luxembourg", "Western Europe"));


            //countries.Add(new Country(126, "", ""));
            //countries.Add(new Country(127, "", ""));
            //countries.Add(new Country(128, "", ""));
            //countries.Add(new Country(129, "", ""));
            //countries.Add(new Country(130, "", ""));




            return countries;
        }

        public Country Get()
        {
            return _CurrentCountry;
        }

        public void Save(Country country)
        {
            _CurrentCountry = country;
        }
    }
}