﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using SandtrapExamples.Models;

namespace SandtrapExamples.Data
{

    public interface IContactDB
    {
        List<Contact> Fetch();
        Contact Get(int ID);
        void Save(Contact contact);
    }

    public class ContactDB : IContactDB
    {
        private static List<Contact> _Contacts;

        public List<Contact> Fetch()
        {
            if (_Contacts == null)
            {
                _Contacts = new List<Contact>();
                _Contacts.Add(new Contact(1, "Peter", "Jones", "0147683770", "pjones@somewhere.com.au"));
                _Contacts.Add(new Contact(2, "John", "Brown", "0146698754", "jbrown@somewhere.com.au"));
            }
            return _Contacts;
        }

        public Contact Get(int ID)
        {
            return _Contacts.Find(c => c.ID == ID);
        }

        public void Save(Contact contact)
        {
            int index = _Contacts.FindIndex(c => c.ID == contact.ID);
            _Contacts[index] = contact;
        }

    }

}