﻿using System;
using System.Collections.Generic;
using SandtrapExamples.Models;

namespace SandtrapExamples.Data
{

    public interface IConsultantFeeDB
    {
        List<ConsultantFee> Fetch();
        void Save(IEnumerable<ConsultantFee> fees);
    }

    public class ConsultantFeeDB : IConsultantFeeDB
    {
        private IOrganisationDB _OrganisationDB;
        private static List<ConsultantFee> _Fees;

        public ConsultantFeeDB(IOrganisationDB organisationDB)
        {
            _OrganisationDB = organisationDB;
        }

        public List<ConsultantFee> Fetch()
        {
            if (_Fees == null)
            {
                List<Organisation> consultants = _OrganisationDB.Fetch();
                _Fees = new List<ConsultantFee>();
                _Fees.Add(new ConsultantFee(1, consultants[0], "Design", false, 7450.50M));
                _Fees.Add(new ConsultantFee(2, consultants[0], "Documentation", false, 11270.00M));
                _Fees.Add(new ConsultantFee(3, consultants[1], "Design", false, 8790.00M));
                _Fees.Add(new ConsultantFee(4, consultants[1], "Documentation", false, 13145.00M));
                _Fees.Add(new ConsultantFee(5, consultants[2], "Site investigations", true, 650.85M));

                // Test the 'archived' class is added
                //_Fees[1].IsActive = false;

                // Test that inherited classes work
                //_Fees.Add(new ConsultantFee(6, new Engineer(100, "Engineer"), "Site investigations", true, 650.85M));

            }
            return _Fees;
        }

        public void Save(IEnumerable<ConsultantFee> fees)
        {
            int count = _Fees.Count;
            foreach (ConsultantFee fee in fees)
            {
                if (!fee.IsDirty)
                {
                    continue;
                }
                if (!fee.ID.HasValue)
                {
                    fee.ID = ++count;
                    _Fees.Add(fee);
                }
                else if (!fee.IsActive)
                {
                    int index = _Fees.FindIndex(f => f.ID == fee.ID);
                    _Fees.RemoveAt(index);
                }
                else
                {
                    int index = _Fees.FindIndex(f => f.ID == fee.ID);
                    _Fees[index] = fee;
                }
            }
        }
    }

}