﻿using System;
using System.Collections.Generic;
using Sandtrap.Extensions;
using SandtrapExamples.Models;

namespace SandtrapExamples.Data
{

    public interface IAccountDB
    {
        List<AccountLedger> Fetch();
        Account Get(int ID);
        void Save(Account account);
    }

    public class AccountDB : IAccountDB
    {
        private static List<AccountLedger> _Ledger;

        public List<AccountLedger> Fetch()
        {
            if (_Ledger == null)
            {
                _Ledger = new List<AccountLedger>();
                _Ledger.Add(new AccountLedger(3, DateTime.Today.AddMonths(-1).LastOfMonth(), 4587.5M, AccountStatus.Draft));
                _Ledger.Add(new AccountLedger(2, DateTime.Today.AddMonths(-2).LastOfMonth(), 7840.25M, AccountStatus.Issued));
                _Ledger.Add(new AccountLedger(1, DateTime.Today.AddMonths(-3).LastOfMonth(), 3500.00M, AccountStatus.Paid));
            }
            return _Ledger;
        }

        public Account Get(int ID)
        {
            AccountLedger ledger = _Ledger.Find(a => a.ID == ID);
            Account account = new Account();
            account.ID = ledger.ID;
            account.Date = ledger.Date;
            account.Details = "Some details of the account";
            account.Amount = ledger.Amount;
            return account;
        }

        public void Save(Account account)
        {
            AccountLedger ledger = _Ledger.Find(a => a.ID == account.ID);
            ledger.Date = account.Date;
            ledger.Amount = account.Amount;
        }

    }
}