﻿using System.Web.Mvc;
using SandtrapExamples.Data;
using SandtrapExamples.ViewModels;
using SandtrapExamples.Models;
using System.Collections.Generic;
using System.Linq;

namespace SandtrapExamples.Controllers
{
    public class TableController : Controller
    {

        private IContactDB _ContactRepository;
        private IConsultantFeeDB _ConsultantFeeRepository;
        private IOrganisationDB _OrganisationRepository;
        private IAccountDB _AccountRepository;

        public TableController(IContactDB contactRepository,
            IConsultantFeeDB consultantFeeRepository, 
            IOrganisationDB organisationRepository, 
            IAccountDB accountRepository)
        {
            _ContactRepository = contactRepository;
            _ConsultantFeeRepository = consultantFeeRepository;
            _OrganisationRepository = organisationRepository;
            _AccountRepository = accountRepository;
        }

        [HttpGet]
        public ActionResult Index()
        {
            TableDisplayViewModel model = new TableDisplayViewModel();
            model.Contacts = _ContactRepository.Fetch();
            model.ConsultantFees = _ConsultantFeeRepository.Fetch().OrderBy(f => f.Consultant.Name);
            model.Ledger = _AccountRepository.Fetch().OrderByDescending(a => a.Date);
            return View(model);
        }

        [HttpGet]
        public ActionResult ConsultantFees()
        {
            TableDisplayViewModel model = new TableDisplayViewModel();
            model.ConsultantFees = _ConsultantFeeRepository.Fetch().OrderBy(f => f.Consultant.Name);
            ViewData["ConsultantList"] = _OrganisationRepository.Fetch();
            return View(model);
        }

        [HttpPost]
        public ActionResult ConsultantFees(TableDisplayViewModel model)
        {
            if (!ModelState.IsValid)
            {
                //var modelStateErrors = this.ModelState.Keys.SelectMany(key => this.ModelState[key].Errors);
                ViewData["ConsultantList"] = _OrganisationRepository.Fetch();
                return View(model);
            }
            _ConsultantFeeRepository.Save(model.ConsultantFees);
            return RedirectToAction("Index");

        }

        [HttpGet]
        public ActionResult Account(int ID)
        {
            AccountViewModel model = new AccountViewModel();
            model.Account = _AccountRepository.Get(ID);
            return View(model);
        }

        [HttpPost]
        public ActionResult Account(AccountViewModel model)
        {
            if (!ModelState.IsValid)
            {
                return View(model);
            }
            _AccountRepository.Save(model.Account);
            return RedirectToAction("Index");
        }

        [HttpGet]
        public ActionResult Help()
        {
            return View();
        }


    }
}
