﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;
using SandtrapExamples.ViewModels;
using SandtrapExamples.Data;

namespace SandtrapExamples.Controllers
{
    public class ContactController : Controller
    {

        private IContactDB _ContactRepository;

        public ContactController(IContactDB contactRepository)
        {
            _ContactRepository = contactRepository;
        }

        [HttpGet]
        public ActionResult Details(int ID)
        {
            ContactViewModel model = new ContactViewModel();
            model.Contact = _ContactRepository.Get(ID);
            return View(model);
        }


        [HttpGet]
        public ActionResult Edit(int ID)
        {
            ContactViewModel model = new ContactViewModel();
            model.Contact = _ContactRepository.Get(ID);
            return View(model);
        }

        [HttpPost]
        public ActionResult Edit(ContactViewModel model)
        {
            if (!ModelState.IsValid)
            {
                return View(model);
            }
            _ContactRepository.Save(model.Contact);
            return RedirectToAction("Index", "Table");
        }

    }
}
