﻿using System;
using System.Collections;
using System.Data;
using System.Web.UI;
using System.Web.UI.WebControls;
using DayPilot.Utils;
using DayPilot.Web.Ui.Enums;
using Util;

public partial class Project_New : Page
{
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
            DateTime start = Convert.ToDateTime(Request.QueryString["start"]);
            TextBoxStart.Text = start.ToShortDateString();
        }
    }

    protected void ButtonOK_Click(object sender, EventArgs e)
    {
        
        DateTime start = Convert.ToDateTime(TextBoxStart.Text);
        int duration = Convert.ToInt32(DropDownListDuration.SelectedValue);
        string note = TextBoxNote.Text;

        new DataManager().CreateAssignment(start, duration, note);

        // passed to the modal dialog close handler, see Scripts/DayPilot/event_handling.js
        Hashtable ht = new Hashtable();
        ht["refresh"] = "yes";
        ht["message"] = "Event created.";

        Modal.Close(this, ht);
    }

    protected void ButtonCancel_Click(object sender, EventArgs e)
    {
        Modal.Close(this);
    }
}
