<?php
class Dingo_Uploader{
	/*
		Author: Dingobats
		Version: 1.1
	*/
	// Editable Variables
	var $allowed_files = array("image/jpeg", "image/gif", "image/png");
	var $size_limit = 20000000000;
	var $overwrite = true;
	var $action = "#";
	// End of Editable Variables
	function __construct($folder){
		$this->folder = $folder;
		if( substr($folder, -1) != "/"){
			$this->folder .= "/";// puts a / at the end if it doesn't have one.
		}
	}
	function form(){
		$html='
			<form action="'.$this->action.'" method="post" enctype="multipart/form-data">
			<label for="file">Filename:</label>
			<input type="file" name="file" id="file" />
			<br />
			<input type="submit" name="submit" value="Submit" />
			</form>
		';
		return $html;
	}
	function display(){
		if( $_FILES['file'] ){// when you submit the form, it takes you here.
			$html = $this->upload();
		}else{
			$html = $this->form();
		}	
		return $html;
	}
	private function upload(){
		$this->file = $_FILES["file"];
		if ($this->validate_files() && $this->validate_size()){
	  		if ($_FILES["file"]["error"] > 0){
	    		$html .= "Return Code: " . $_FILES["file"]["error"] . "<br />";
	    	}else{
	    		// This section of the foreach loop checks to see if the folder exist. If it doesn't exist, then 
	    		// we will need to create the folder. Note: PHP does not auto create the folder for you.
	    		$folders_arr = explode("/", $this->folder);
	    		$folder = "";
	    		foreach ( $folders_arr as $val ){
	    			if( strlen(trim($val)) > 0){
	    				$folder .= $val.'/';
	    				if( !is_dir($folder) ){
	    					mkdir($folder);
	    				}
	    			}
	    		}
	    		if (file_exists($this->folder. $_FILES["file"]["name"]) && !$this->overwrite){
	      			$html .= $_FILES["file"]["name"] . " already exists. ";
	      		}else{
	      			move_uploaded_file($_FILES["file"]["tmp_name"],$this->folder . $_FILES["file"]["name"]);
	      			$html .= '<img src="'.$this->folder . $_FILES["file"]["name"].'"><br/>';
	      			$html .= "Stored in: " . $this->folder . $_FILES["file"]["name"];
	      			$html .= '<br/><a href="'.$_SERVER['REQUEST_URI'].'">Upload another one</a>';
	      		}
	    	}
	  	}else{
	 		$html .= "Invalid file: ".$this->errors;
	  	}  	
	  	return $html;
	}
	private function validate_files(){
		if ( !in_array($this->file['type'], $this->allowed_files)){ 
			$this->errors .= "This file is not allowed. ";
			return false;	
		}
		return true;
	}
	private function validate_size(){
		// Checks to see if the image being submited is under our size limitation.
		if($this->file["size"] > $this->size_limit){
			$this->errors = "Size is too large. ";
			return false;	
		}	
		return true;
	}
}
// ####################### start of execution #################### //
$uploader = new Dingo_Uploader("upload/test/meme/");
echo '
<style type="text/css">
	body{
		font-size: 13px;
		font-family: Arial;	
	}
	#uploader img{
		width: 500px;	
	}
</style>
<div id="uploader">
';
echo $uploader->display();
echo '</div>';
?>