<?php
//---------------------------------------------------------------------
//  -- Adriel Media --
//---------------------------------------------------------------------
// Sign page
// Product: Faisan Guestbook
// Written by: Adriel Ricardo Torres aka RicarDooM
// Website: http://adrielmedia.com
// Date:    25/11/2009
// Updated: 27/07/2010
//---------------------------------------------------------------------

//---------------------------------------------------------------------
// File name: sign.php
// File version: 1.0
//---------------------------------------------------------------------

//---------------------------------------------------------------------
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation.
//---------------------------------------------------------------------
require_once('appHeader.php');

//------------------
// Begin page source
//------------------
$pagePreview = 0;
$attempts = 0;
$getAccess = 0;
$processComplete = 0;
$pageError = array();
// Creating objects for comments
$myComment = new commentsVO();
$myUser = new usersVO();
$myUser->setUserIp(cf_getIp());

if (isset($_SESSION['validCode'])) {
	if (htmlentities($_SESSION['validCode'], ENT_QUOTES) == 1)
		$getAccess = 1;
}

// Admin data
if (isset($_SESSION['sesIsLogged'])) {
	if (htmlentities($_SESSION['sesIsLogged'], ENT_QUOTES) == 1) {
		$fileUserLogin = new fileManager($cf_dataPath.'/users.php', 'r');
		
		for ($i = 0; $i < $fileUserLogin->getRows(); $i++) {
			$arrData = explode("|", $fileUserLogin->getDataRow($i));
			if ($arrData[0] == htmlentities($_SESSION['sesUserId'], ENT_QUOTES) && $arrData[2] == htmlentities($_SESSION['sesUserPass'], ENT_QUOTES)) {
				$myUser->setUserName($arrData[1]);
				$myUser->setUserEmail($arrData[3]);
				$myUser->setUserWebsite($arrData[4]);
				$myUser->setUserLocation($arrData[5]);
				$myUser->setUserIsAdmin(1);
				$getAccess = 1;
				break;
			}
		}
		$fileUserLogin->closeFile();		
	}
}

if (!isset($_COOKIE[$cf_cookieName])) {
	// Validating Security Code
	if (isset($_POST['secCode'])) {
		$attempts = htmlentities($_POST['attempts'], ENT_QUOTES);

		if (isset($_SESSION['secCode'])) {
			if (htmlentities($_POST['secCode'], ENT_QUOTES) == htmlentities($_SESSION['secCode'], ENT_QUOTES)) {
				$_SESSION['validCode'] = 1;
				$getAccess = 1;
			}
			else {
				$_SESSION['validCode'] = 0;
				$attempts++;
			}
		}
	}
	elseif (isset($_POST['action'])) {
		$action = htmlentities($_POST['action'], ENT_QUOTES);

		if ($action == $langMsg['Preview'])
			$pagePreview = 1;

		if ($myUser->getUserIsAdmin() != 1) {
			if ($cf_showLocationField == 1)
				$myUser->setUserLocation(cf_replaceSpTags(htmlentities($_POST['userLocation'], ENT_QUOTES)));
				
			$tmpUserName = htmlentities($_POST['userName'], ENT_QUOTES);
			if (cf_validateRequiredField($tmpUserName) != 0)
				$pageError[] = $langMsg['Name_warn'];
				
			$myUser->setUserName(cf_replaceSpTags($tmpUserName));
			
			if ($cf_showEmailField == 1) {
				$tmpUserEmail = htmlentities($_POST['userEmail'], ENT_QUOTES);
				if (cf_validateEmail($tmpUserEmail) != 0)
					$pageError[] = $langMsg['Email_warn'];

				$myUser->setUserEmail(cf_replaceSpTags($tmpUserEmail));
			}
			
			if ($cf_showWebsiteField == 1) {
				$tmpUserWebsite = htmlentities($_POST['userWebsite'], ENT_QUOTES);
				if (cf_validateWebsite($tmpUserWebsite) != 0)
					$pageError[] = $langMsg['Website_warn'];

				$myUser->setUserWebsite(cf_replaceSpTags($tmpUserWebsite));
			}
			
			$tmpComment = htmlentities($_POST['commentBody'], ENT_QUOTES);
			if (cf_validateRequiredField($tmpComment) != 0)
				$pageError[] = $langMsg['Comment_warn'];
			elseif (cf_validateMaxChars($tmpComment, $cf_maxCommentChars) != 0)
				$pageError[] = $langMsg['Max_chars_warn'].' '.$cf_maxCommentChars;
			elseif (cf_validateMaxBrlns($tmpComment, $cf_maxCommentBreakLines) != 0)
				$pageError[] = $langMsg['Max_breaklines_warn'].' '.$cf_maxCommentBreakLines;
		}
		else {
			$tmpComment = htmlentities($_POST['commentBody'], ENT_QUOTES);
			if (cf_validateRequiredField($tmpComment) != 0)
				$pageError[] = $langMsg['Comment_warn'];
		}

		$myComment->setCommentBody(cf_replaceSpTags($tmpComment));
		
		if ($action == $langMsg['Submit'] && count($pageError) < 1) {
			// Checking for spam
			if ($myUser->getUserIsAdmin() != 1) {
				$spamFile = new fileManager($cf_dataPath.'/spamLog', 'r');
				$checkSpam = new antiSpamClass($spamFile->getAllDataRows());		
				$checkSpam->checkTextArea($myComment->getCommentBody());
				$checkSpam->checkNameField($myUser->getUserName());
				$checkSpam->checkUrlField($myUser->getUserWebsite());
			
				if ($checkSpam->getSpamPoints() < 0 || $myUser->getUserIp() == 'Unknown')
					$myComment->setCommentStatus(2);
				elseif ($cf_toApproveComment == 1)
					$myComment->setCommentStatus(1);
			}

			$myComment->setCommentDate(cf_getUTCTime());

			// Set Comment Id
			$fileComments = new fileManager($cf_dataPath.'/comments.php', 'r');
			
			if ($fileComments->getRows() == 1)
				$myComment->setCommentId(1);
			else {
				$tmpId = explode('|', $fileComments->getDataRow(($fileComments->getRows()-1)));
				$myComment->setCommentId($tmpId[0]+1);
			}
			
			$saveComment = new fileManager($cf_dataPath.'/comments.php', 'a');
			$strToInsert = $myComment->getCommentId().'|'.
							cf_parseBreaklines($myComment->getCommentBody()).'|'.
							$myComment->getCommentStatus().'|'.
							$myComment->getCommentDate().'|'.
							$myUser->getUserName().'|'.
							$myUser->getUserIp().'|'.
							$myUser->getUserEmail().'|'.
							$myUser->getUserWebsite().'|'.
							$myUser->getUserLocation().'|'.
							$myUser->getUserIsAdmin().'|'."\n";
							
			$debug[] = "String to Insert: $strToInsert";
							
			$saveComment->saveData($strToInsert);
			$processComplete = 1;

			if ($myUser->getUserIsAdmin() != 1) {
				unset($_SESSION['validCode']);
				unset($_SESSION['validCode']);
			}
		}

		$debug[] = "Action send: $action\n";
	}
}
//------------------
// End page source
//------------------
//******************
//------------------
// Begin page output
//------------------
if (defined('DEBUG')) {
	echo "<!--\n";
	for ($i=0; $i<count($debug); $i++)
		echo $debug[$i];
	echo "-->\n";
}

if ($processComplete == 1) {
	// Set Cookie Value
	setcookie($cf_cookieName, '0', time()+(60*$cf_timeBeforePostAgain));
	
	// Send email if approve comment is set on
	if ($cf_toApproveComment == 1 && $myUser->getUserIsAdmin() != 1) {
		$to = $cf_notificationEmail;
		$subject = $cf_appName.' '.$cf_appProduct.' - '.$langMsg['Email_subject'];
		$message = $langMsg['Email_body'];
		$headers = 'From: noreply@faisan.guestbook.com';

		@mail($to, $subject, $message, $headers);
	}
}

// Showing main header
$mainTpl->setLnkPage('index.php', $langMsg['View_guestbook']);
echo $mainTpl->showHeader();

if (isset($_COOKIE[$cf_cookieName])) {
	$tplVars['{SERVER_MESSAGE}'] = $langMsg['Wait_message'];
	echo (new templateParser("$tplPath/tpl/serverMessage.html", $tplVars));
}
elseif ($cf_showSecCode == 1 && $getAccess == 0) {
	$randCode = '';
	$_SESSION['secCode'] = '';

	for ($i = 0; $i < 4; $i++)
		$randCode .= substr('AabCDdEeFfGgHhKLMmNnPqRrTtWXY123479', mt_rand(0,34), 1);

	$_SESSION['secCode'] = $randCode;

	if ($attempts > 0)
		$tplVars['{SECCODE_WARN_MESSAGE}'] = $langMsg['Verification_code_warn'];
	else
		$tplVars['{SECCODE_WARN_MESSAGE}'] = '&nbsp;';

	$tplVars['{ATTEMPTS}'] = $attempts;
	$tplVars['{SECCODE_IMG}'] = '<img src="'.$cf_sourcePath.'/util/captchaClass.php" alt=" " title=" " />';
	$tplVars['{T_SECCODE}'] = $langMsg['Verification_code'];
	$tplVars['{SUBMIT}'] = $langMsg['Submit'];

	echo (new templateParser("$tplPath/tpl/secCodeBody.html", $tplVars));
}
elseif ($processComplete == 1) {
	if ($myComment->getCommentStatus() == 0)
		$tplVars['{SERVER_MESSAGE}'] = $langMsg['Published_message'];
	else
		$tplVars['{SERVER_MESSAGE}'] = $langMsg['Unpublished_message'];
	
	echo (new templateParser("$tplPath/tpl/serverMessage.html", $tplVars));
}
else {
	if ($pagePreview == 1 && count($pageError) < 1) {
		// Showing comment preview
		$repSmileys = new replaceString($cf_dataPath.'/smileys');
		$repBadWords = new replaceString($cf_dataPath.'/cwordsLog');
		
		$tplAuxVars = array();
		$tplAuxVars['{TEMPLATE_PATH}'] = $cf_themePath;
		$tplAuxVars['{COMMENT_DATE}'] = cf_getTodayDate($cf_dateFormat, $cf_timeZone);
		$tplAuxVars['{AUTHOR_NAME}'] = $myUser->getUserName();
		
		if ($myUser->getUserIsAdmin() == 1)
			$tplAuxVars['{AUTHOR_RANK}'] = $langMsg['Admin'];
		else
			$tplAuxVars['{AUTHOR_RANK}'] = $langMsg['Guest'];
		
		$tplAuxVars['{AUTHOR_LOCATION}'] = $myUser->getUserLocation();
		
		$tmpEmail = $myUser->getUserEmail();
		if (!empty($tmpEmail))
			$tplAuxVars['{AUTHOR_EMAIL}'] = '<a href="mailto:'.cf_parseEmail($tmpEmail).'"><img src="'.$tplPath.'/img/email.gif" alt="'.$langMsg['Email'].'" title="'.$langMsg['Email'].'"/></a>';
		else
			$tplAuxVars['{AUTHOR_EMAIL}'] = '';

		$tmpWebsite = $myUser->getUserWebsite();
		if (!empty($tmpWebsite))
			$tplAuxVars['{AUTHOR_WEBSITE}'] = '<a href="'.$tmpWebsite.'"><img src="'.$tplPath.'/img/www.gif" alt="'.$langMsg['Website'].'" title="'.$langMsg['Website'].'"/></a>';
		else
			$tplAuxVars['{AUTHOR_WEBSITE}'] = '';
			
		$commentBody = $myComment->getCommentBody();
			
		if ($cf_allowAMcode == 1)
			$commentBody = amCode($commentBody);
			
		if ($cf_allowSmileys == 1) {
			$strFormat = '<img src="?" alt="?" />';
			$commentBody = $repSmileys->toReplace($commentBody, $strFormat);
		}
			
		if ($cf_allowBadWords == 0) {
			$strFormat = '***';
			$commentBody = $repBadWords->toReplace($commentBody, $strFormat);
		}
			
		$tplAuxVars['{COMMENT_BODY}'] = cf_parseBreaklines($commentBody);
		
		echo (new templateParser("$tplPath/tpl/commentsLoop.html", $tplAuxVars));
	}
	elseif (count($pageError) > 0) {
		// Warning message
		$tplVars['{TEMPLATE_PATH}'] = $cf_themePath;
		$tplVars['{WARNING_MESSAGE}'] = '';	
		for ($i=0; $i<count($pageError); $i++) {
			$tplVars['{WARNING_MESSAGE}'] .= "<p>$pageError[$i]</p>";
		}

		echo (new templateParser("$tplPath/tpl/warningMessage.html", $tplVars));
	}

	// Sign form
	$tplVars['{TEMPLATE_PATH}'] = $cf_themePath;
	$tplVars['{SIGN_GUESTBOOK}'] = $langMsg['Sign_guestbook'];
	$tplVars['{NAME}'] = $langMsg['Name'];
	$tplVars['{LOCATION}'] = $langMsg['Location'];
	$tplVars['{EMAIL}'] = $langMsg['Email'];
	$tplVars['{WEBSITE}'] = $langMsg['Website'];
	$tplVars['{NAME_VALUE}'] = $myUser->getUserName();
	$tplVars['{LOCATION_VALUE}'] = $myUser->getUserLocation();
	$tplVars['{EMAIL_VALUE}'] = $myUser->getUserEmail();
	$tplVars['{WEBSITE_VALUE}'] = $myUser->getUserWebsite();
	$tplVars['{COMMENT}'] = $myComment->getCommentBody();
	$tplVars['{PREVIEW}'] = $langMsg['Preview'];
	$tplVars['{SUBMIT}'] = $langMsg['Submit'];
	$tplVars['{TEXT_COLOR}'] = $langMsg['Text_color'];
	$tplVars['{RED}'] = $langMsg['Red'];
	$tplVars['{BLUE}'] = $langMsg['Blue'];
	$tplVars['{GREEN}'] = $langMsg['Green'];
	$tplVars['{YELLOW}'] = $langMsg['Yellow'];
	$tplVars['{ORANGE}'] = $langMsg['Orange'];
	
	if ($cf_showLocationField == 0)
		$tplVars['{DISPLAY_LOCATION}'] = 'style="display:none;"';
	else
		$tplVars['{DISPLAY_LOCATION}'] = '';
		
	if ($cf_showWebsiteField == 0)
		$tplVars['{DISPLAY_WEBSITE}'] = 'style="display:none;"';
	else
		$tplVars['{DISPLAY_WEBSITE}'] = '';
		
	if ($cf_showEmailField == 0)
		$tplVars['{DISPLAY_EMAIL}'] = 'style="display:none;"';
	else
		$tplVars['{DISPLAY_EMAIL}'] = '';
	
	if ($myUser->getUserIsAdmin() == 1) {
		$tplVars['{NAME_STATUS}'] = 'disabled="disabled"';
		$tplVars['{LOCATION_STATUS}'] = 'disabled="disabled"';
		$tplVars['{EMAIL_STATUS}'] = 'disabled="disabled"';
		$tplVars['{WEBSITE_STATUS}'] = 'disabled="disabled"';
	}
	else {
		$tplVars['{NAME_STATUS}'] = '';
		$tplVars['{LOCATION_STATUS}'] = '';
		$tplVars['{EMAIL_STATUS}'] = '';
		$tplVars['{WEBSITE_STATUS}'] = '';
	}
	
	$smileyFile = new fileManager($cf_dataPath.'/smileys', 'r');
	$strSmileys = '';
	
	for ($i=0; $i<$smileyFile->getRows(); $i++) {
		$arrSmiley = explode('|', $smileyFile->getDataRow($i));
		
		$strSmileys .= '<a href="#" onclick="js_changeString(\''.$arrSmiley[1].'\', \'commentBody\')"><img src="'.$arrSmiley[2].'" border="0" alt="'.$arrSmiley[3].'" /></a> ';
	}
	
	$tplVars['{SMILEY_LIST}'] = $strSmileys;

	echo (new templateParser("$tplPath/tpl/signBody.html", $tplVars));
}

// Showing main footer
echo $mainTpl->showFooter();
//------------------
// End page output
//------------------
?>