<?php
//---------------------------------------------------------------------
//  -- Adriel Media --
//---------------------------------------------------------------------
// Index page
// Product: Faisan Guestbook
// Written by: Adriel Ricardo Torres aka RicarDooM
// Website: http://adrielmedia.com
// Date:    17/11/2009
// Updated: 09/02/2010
//---------------------------------------------------------------------

//---------------------------------------------------------------------
// File name: index.php
// File version: 1.0
//---------------------------------------------------------------------

//---------------------------------------------------------------------
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation.
//---------------------------------------------------------------------
require_once('appHeader.php');

//------------------
// Begin page source
//------------------
$myPost = new usersVO();
$myPost->setUserName('LoL');

// Loading comments
$dataFile = new fileManager($cf_dataPath.'/comments.php', 'r');
$arrField = array();
$arrComments = array();

if ($dataFile->getRows() > 1) {
	for ($i=1; $i<$dataFile->getRows(); $i++) {
		// Checking if commnet line is not corrupted
		if ($dataFile->getRowFields($i, '|') == constant('COMMENTS_FIELDS')) {
			$arrField = explode('|', $dataFile->getDataRow($i));
			
			// Validating comment status equals 0
			if ($arrField[2] == 0)
				$arrComments[] = $dataFile->getDataRow($i);
		}
		else
			$debug[] = "Warning. Data on line $i is corrupted, current line would be ommited.\n";
	}
}

$arrComments = array_reverse($arrComments);
$aprovedComments = count($arrComments);
// Loading Paginatior class
$iPage = 1;

if (isset($_GET['page']))
	$iPage = intval(htmlentities($_GET['page']));

$pPaginator = new amPaginator($aprovedComments, $iPage, $cf_commentsPPage, 5);
//------------------
// End page source
//------------------
//******************
//------------------
// Begin page output
//------------------
if (defined('DEBUG')) {
	echo "<!--\n";
	for ($i=0; $i<count($debug); $i++)
		echo $debug[$i];
	echo "-->\n";
}
//-------------------
// Begin Lang Box Mod
//-------------------
if ($cf_showLangBox == 1) {
	$myLangBox = new langBoxAPP($cf_langPath, $currentLang);
	
	if (isset($_POST['modLangBox'])) {
		$langName = htmlentities($_POST['modLangBox'], ENT_QUOTES);
		$_SESSION['Lang'] = cf_parseMethaChars($langName);
					
		if (isset($_SESSION['Lang']) && is_file($cf_langPath.'/'.htmlentities($_SESSION['Lang'], ENT_QUOTES).'.inc')) {
			require_once($cf_langPath.'/'.$_SESSION['Lang'].'.inc');
			$myLangBox->setUserLang($_SESSION['Lang']);
			$mainTpl->setLangMsg($langMsg);
			$mainTpl->setLnkPage($cf_signPage, $langMsg['Sign_guestbook']);
		}
	}

	$tplVars['{LANG_BOX}'] = $myLangBox->showLangBox();
} else
	$tplVars['{LANG_BOX}'] = '';
//-----------------
// End Lang Box Mod
//-----------------

// Showing main header
echo $mainTpl->showHeader();

$tplVars['{TOTAL_POSTS}'] = $aprovedComments;
$tplVars['{COMMENTS}'] = $langMsg['Comments'];
$tplVars['{PAGE}'] = $langMsg['Page'];
$tplVars['{NUM_PAGE}'] = $pPaginator->getThisPage();
$tplVars['{OF}'] = $langMsg['Of'];
$tplVars['{TOTAL_PAGES}'] = $pPaginator->getTotalPages();
$tplVars['{PAGINATION}'] = $pPaginator->getPaginator();
// Showing index header
echo (new templateParser("$tplPath/tpl/indexHeader.html", $tplVars));

// Showing Comments
$tplAuxVars = array();
$tplAuxVars['{TEMPLATE_PATH}'] = $cf_themePath;
$repSmileys = new replaceString($cf_dataPath.'/smileys');
$repBadWords = new replaceString($cf_dataPath.'/cwordsLog');

if ($aprovedComments > 0) {
	for ($i=$pPaginator->getInitial(); $i<$aprovedComments && $i<$pPaginator->getLimit(); $i++) {
		$arrField = explode('|', $arrComments[$i]);
		
		$commentBody = $arrField[1];
		
		if ($cf_allowAMcode == 1)
			$commentBody = amCode($commentBody);
		
		if ($cf_allowSmileys == 1) {
			$strFormat = '<img src="?" alt="?" />';
			$commentBody = $repSmileys->toReplace($commentBody, $strFormat);
		}
		
		if ($cf_allowBadWords == 0) {
			$strFormat = '***';
			$commentBody = $repBadWords->toReplace($commentBody, $strFormat);
		}
		
		$tplAuxVars['{COMMENT_BODY}'] = $commentBody;
		$tplAuxVars['{COMMENT_DATE}'] = cf_getDate($arrField[3], $cf_dateFormat, $cf_timeZone);
		$tplAuxVars['{AUTHOR_NAME}'] = $arrField[4];
		
		if (!empty($arrField[6])) 
			$tplAuxVars['{AUTHOR_EMAIL}'] = '<a href="mailto:'.cf_parseEmail($arrField[6]).'"><img src="'.$tplPath.'/img/email.gif" alt="'.$langMsg['Email'].'" title="'.$langMsg['Email'].'"/></a>';
		else
			$tplAuxVars['{AUTHOR_EMAIL}'] = '';

		if (!empty($arrField[7]))
			$tplAuxVars['{AUTHOR_WEBSITE}'] = '<a href="'.$arrField[7].'"><img src="'.$tplPath.'/img/www.gif" alt="'.$langMsg['Website'].'" title="'.$langMsg['Website'].'"/></a>';
		else
			$tplAuxVars['{AUTHOR_WEBSITE}'] = '';
		
		$tplAuxVars['{AUTHOR_LOCATION}'] = $arrField[8];
		
		if ($arrField[9] == 1)
			$tplAuxVars['{AUTHOR_RANK}'] = $langMsg['Admin'];
		else
			$tplAuxVars['{AUTHOR_RANK}'] = $langMsg['Guest'];

		echo (new templateParser("$tplPath/tpl/commentsLoop.html", $tplAuxVars));
	}
}
else {
	// Your guestbook is empty.
	$tplAuxVars['{SERVER_MESSAGE}'] = $langMsg['Empty_Guestbook'];
	
	echo (new templateParser("$tplPath/tpl/serverMessage.html", $tplAuxVars));
}

// Showing index footer
echo (new templateParser("$tplPath/tpl/indexFooter.html", $tplVars));

// Showing main footer
echo $mainTpl->showFooter();
//----------------
// End page output
//----------------
?>