<?php
//---------------------------------------------------------------------
//  -- Adriel Media --
//---------------------------------------------------------------------
// Replace String Class
// Written by: Adriel Ricardo Torres aka RicarDooM
// Website: http://adrielmedia.com
// Date:    01/04/2009
// Updated: 09/12/2009
//---------------------------------------------------------------------

//---------------------------------------------------------------------
// File name: replaceString.php
// File version: 1.0
//---------------------------------------------------------------------

//---------------------------------------------------------------------
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation.
//---------------------------------------------------------------------

//Detect external attacks and intrusions.
if ( !defined('IN_SCRIPT') )
{
	die('Script interrupted.');
	exit;
}

class replaceString {
	protected $cv_file, $cv_lines, $cv_error, $cv_msg, $cv_return_data;
	
	public function __construct($file_path) {
		if (is_file($file_path)) {
			$this->cv_file = file($file_path);
			$this->cv_lines = count($this->cv_file);
			$this->cv_msg = '[Class_replaceString] ['.date(DATE_RFC822).'] File successfuly opened.';
			$this->cv_error = false;
		} else {
			$this->cv_msg = '[Class_replaceString] ['.date(DATE_RFC822).'] [Error] File does not exist: '.$file_path;
			$this->cv_error = true;
		}
	}

	public function toReplace($strText, $strFormat) {
		if ($this->cv_error == false) {
			$repTag = array();
			$repValue = array();

			$arrFormat = explode('?', $strFormat);
			$linesFormat = count($arrFormat);

			for ($i = 0; $i < $this->cv_lines; $i++) {
				$arrData = explode('|',$this->cv_file[$i]);
				$linesData = count($arrData);
				$repTag[] = $arrData[1];
				$tmpValue = '';

				if ($linesFormat > 1) {
					for ($j = 0; $j < $linesFormat; $j++) {
						$tmpValue .= $arrFormat[$j];
						
						if ($j != ($linesFormat - 1))
							$tmpValue .= $arrData[$j+2];
					}
				} else
					$tmpValue = $strFormat;
				
				$repValue[] = $tmpValue;
			}

			$string_text = str_replace($repTag, $repValue, $strText);		
		}

		return $string_text;
	}

	public function getMessage() {
		return $this->cv_msg;
	}
}