<?php
//---------------------------------------------------------------------
//  -- Adriel Media --
//---------------------------------------------------------------------
// File Manager Class
// Written by: Adriel Ricardo Torres aka RicarDooM
// Website: http://adrielmedia.com
// Date:    01/04/2009
// Updated: 30/01/2010
//---------------------------------------------------------------------

//---------------------------------------------------------------------
// File name: fileManager.php
// File version: 1.0
//---------------------------------------------------------------------

//---------------------------------------------------------------------
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation.
//---------------------------------------------------------------------

//Detect external attacks and intrusions.
if ( !defined('IN_SCRIPT') )
{
	die('Script interrupted.');
	exit;
}

class fileManager {
	protected $cv_file, $cv_data_file, $cv_num_lines, $cv_open_type, $cv_msg;
	
	public function __construct($data_file, $open_type) {
		$this->cv_data_file = $data_file;
		$this->cv_open_type = $open_type;
		$this->cv_num_lines = 0;
		
		if (is_file($data_file)) {
			if ($this->cv_open_type == 'a')
				$this->cv_file = @fopen($this->cv_data_file, 'a');
			elseif ($this->cv_open_type == 'w')
				$this->cv_file = @fopen($this->cv_data_file, 'w');
			elseif ($this->cv_open_type == 'r') {
				$this->cv_file = @file($this->cv_data_file);
				$this->cv_num_lines = count($this->cv_file);
			}

			$this->cv_error = false;
			$this->cv_msg = '[Class_fileManager] ['.date(DATE_RFC822).'] File successfuly opened.';
		} else {
			$this->cv_error = true;
			$this->cv_msg = '[Class_fileManager] ['.date(DATE_RFC822).'] [Error] File does not exist: '.$data_file;
		}
	}

	public function getRows() {
		if ($this->cv_error == false && $this->cv_open_type == 'r')
			return $this->cv_num_lines;
		else
			return 0;
	}
	
	public function getRowFields($id, $separator) {
		if ($this->cv_error == false && $this->cv_open_type == 'r') {
			$arrFields = explode($separator, $this->cv_file[$id]);
			
			return (count($arrFields) - 1);
		}
		else
			return 0;
	}
	
	public function getDataRow($id) {
		if ($this->cv_error == false && $this->cv_open_type == 'r')
			return $this->cv_file[$id];
		else
			return 0;
	}
	
	public function getAllDataRows() {
		if ($this->cv_error == false && $this->cv_open_type == 'r')
			return $this->cv_file;
		else
			return 0;
	}
	
	public function addDataRow($strData) {
		if ($this->cv_error == false && $this->cv_open_type == 'r') {
			$this->cv_file[] = $strData;
			$this->cv_num_lines++;
		}
	}

	public function deleteDataRow($index) {
		if ($this->cv_error == false && $this->cv_open_type == 'r') {
			unset($this->cv_file[$index]);
			$this->cv_file = array_values($this->cv_file);
			$this->cv_num_lines--;
		}
	}

	public function updateDataRow($index, $strData) {
		if ($this->cv_error == false && $this->cv_open_type == 'r') {
			$this->cv_file[$index] = $strData;
		}
	}

	public function saveData($string_text) {
		if ($this->cv_error == false && $this->cv_open_type != 'r') {
			@flock($this->cv_file, 2);

			if (fwrite($this->cv_file, $string_text) == true)
				return true;
			else
				return false;

			@flock($this->cv_file, 3);
			@fclose($this->cv_file);
		} else {
			$this->cv_msg = '[Class_fileManager] ['.date(DATE_RFC822).'] [Warning] Cannot save data on file.';
			return false;
		}
	}
	
	public function closeFile() {
		@fclose($this->cv_file);
	}
	
	public function getMessage() {
		return $this->cv_msg;
	}
}
?>