<?php
//---------------------------------------------------------------------
//  -- Adriel Media --
//---------------------------------------------------------------------
// Common functions for Adriel Media applications
// Written by: Adriel Ricardo Torres aka RicarDooM
// Website: http://adrielmedia.com
// Date:    14/09/2009
// Updated: 01/10/2010
//---------------------------------------------------------------------

//---------------------------------------------------------------------
// File name: commonF.php
// File version: 1.1
//---------------------------------------------------------------------

//---------------------------------------------------------------------
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation.
//---------------------------------------------------------------------

//Detect external attacks and intrusions.
if ( !defined('IN_SCRIPT') )
{
	die('Script interrupted.');
	exit;
}

// All functions starts with the "cf_" prefix

// Get Ip address
function cf_getIp() {
	$ip = 'Unknown';

	if (getenv("HTTP_X_FORWARDED_FOR"))
		$ip = getenv("HTTP_X_FORWARDED_FOR");
	elseif (getenv("REMOTE_ADDR"))
		$ip = getenv("REMOTE_ADDR");

	return $ip;
}

// Verify if Ip address is banned from application
function cf_isBanned($userIp, $ipItems) {
	$arrIp = explode('.', $userIp);
	$Ip2 = "$arrIp[0].$arrIp[1].*.*";
	$Ip3 = "$arrIp[0].$arrIp[1].$arrIp[2].*";
	$ipItemsRows = count($ipItems);

	for ($i = 0; $i < $ipItemsRows; $i++) {
		$IpAdd = explode('|', $ipItems[$i]);
		$IpFull = 0;
		
		if (isset($IpAdd[1]))
			$IpFull = $IpAdd[1];

		if ($IpFull == $userIp || $IpFull == $Ip2 || $IpFull == $Ip3)
			return -1;
	}
	return 0;
}

// Get Today Date
function cf_getTodayDate($dateFormat, $timeZone) {
	$hm = $timeZone * 60;
	$hms = $hm * 60;
	return gmdate($dateFormat, time()+($hms));
}

// Get Date
function cf_getDate($myDate, $dateFormat, $timeZone) {
	$myDate = $myDate + ($timeZone * 3600);
	return date($dateFormat, $myDate);
}

//Get UTC Time
function cf_getUTCTime() {
	$utc = (date('O') * 3600) / 100;
	return (time() - ($utc));
}

//Replace breaklines
function cf_parseBreaklines($strText) {
	return preg_replace("((\n\r)|(\r*\n)|(\r\n*))", '<br />', $strText);
}

//Replace break lines tags on comment
function cf_parseBrTags($strText) {
	return str_replace('<br />', "\n", $strText);
}

//Replace some special tags and pipes
function cf_replaceSpTags($strText) {
	$strText = str_replace('|', '&#124;', $strText);
	$strText = str_replace('\&#039;', '&#039;', $strText);
	$strText = str_replace('\&quot;', '&quot;', $strText);
	$strText = preg_replace("#</*(applet|meta|xml|blink|link|style|script|embed|object|iframe|frame|frameset|ilayer|layer|bgsound|title|base)[^>]*>#Usi",'', $strText);
	
	return $strText;
}

//Replace some special tags and pipes
function cf_parseMethaChars($strText) {
	$strText = preg_replace("/[\/|.|%]/",'', $strText);

	return $strText;
}

//Email protection
function cf_parseEmail($strText) {
	$strEmail = '';
	$search = array('@','.');
	$replace = array('(at)','(dot)');
	$strEmail = str_replace($search, $replace, $strText);

	return $strEmail;
}

//Validate email field
function cf_validateEmail($email) {
	if ($email == '0')
		return -1;
	elseif (!empty($email) && !preg_match("/^[_a-z0-9-]+(\.[_a-z0-9-]+)*@[a-z0-9-]+(\.[a-z0-9-]+)*(\.[a-z]{2,4})$/i", $email))
		return -1;
	else
		return 0;
}

//Validate website field
function cf_validateWebsite($website) {
	if ($website == '0')
		return -1;
	elseif (!empty($website) && !preg_match("/^([http|https]{3,4})(([\w]+:)\/\/)(([\d\w]|%[a-fA-f\d]{2,2})+(:([\d\w]|%[a-fA-f\d]{2,2})+)?@)?([\d\w][-\d\w]{0,253}[\d\w]\.)+[\w]{2,4}(:[\d]+)?(\/([-+_~.\d\w]|%[a-fA-f\d]{2,2})*)*(\?(&amp;?([-+_~.\d\w]|%[a-fA-f\d]{2,2})=?)*)?(#([-+_~.\d\w]|%[a-fA-f\d]{2,2})*)?$/", $website))
		return -1;
	else
		return 0;
}

//Validate optional fields
function cf_validateOptionalField($strText) {
	if ($strText == '0')
		return -1;
	elseif (!empty($strText) && !preg_match("/^[a-zA-Z0-9]/i", $strText))
		return -1;
	else
		return 0;
}

//Validate required fields
function cf_validateRequiredField($strText) {
	if (empty($strText))
		return -1;
	elseif (!preg_match("/^[a-zA-Z0-9]/i", $strText))
		return -1;
	else
		return 0;
}

//Validate required fields
function cf_validateNumericField($iText) {
	if (!is_numeric($iText))
		return -1;
	else
		return 0;
}

//Validate maximun characters counter
function cf_validateMaxChars($strText, $iMaxChars) {
	if (strlen($strText) > $iMaxChars)
		return -1;
	else
		return 0;
}

//Validate maximun breaklines
function cf_validateMaxBrlns($strText, $iMaxBlines) {
	$strText = @explode("\n", $strText);
	if (count($strText) > $iMaxBlines)
		return -1;
	else
		return 0;
}

//Validate IP address format
function cf_validateIP($ip) {
	if ($ip == '0')
		return -1;
	elseif (!empty($ip) && !preg_match("/^([1-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])(\.([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5]))(\.([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5]|\*)){2}$/", $ip))
		return -1;
	else
		return 0;
}

//Get YES/NO options fields for a select html tag
function cf_getOptionYN($iValue, $strYes, $strNo) {
	// 1=Yes
	// 2=No
	if ($iValue == 1)
		return '<option value="1" selected="selected">'.$strYes.'</option><option value="0">'.$strNo.'</option>';
	else
		return '<option value="1">'.$strYes.'</option><option value="0" selected="selected">'.$strNo.'</option>';
}

//Get all options content on a directory for a select html tag
function cf_getOptionDir($strValue, $strDir) {
	$optionValue = '';

	if (is_dir($strDir)) {
		if ($oDir = opendir($strDir))	{
			while (($strFile = readdir($oDir)) != false)	{
				if ($strFile != '.' && $strFile != '..' && $strFile != 'index.html')	{
					$arrFile = explode('.', $strFile);

					if ($strValue == $arrFile[0])
						$optionValue .= '<option value="'.$arrFile[0].'" selected="selected">'.$arrFile[0].'</option>';
					else
						$optionValue .= '<option value="'.$arrFile[0].'">'.$arrFile[0].'</option>';
				}
			}
		closedir($oDir);
		}
	}

	return $optionValue;
}

function cf_getOptionTimeZone($iValue) {
	$optionValue = '';

	$arrValue = array('-12', '-11', '-10', '-9', '-8', '-7', '-6', '-5', '-4', '3.5', '-3', '-2', '-1', '0', '1', '2', '3', '3.5', '4', '4.5', '5', '5.5', '6', '6.5', '7', '8', '9', '9.5', '10', '11', '12');
	$arrFormat = array('-12:00', '-11:00', '-10:00', '-9:00', '-8:00', '-7:00', '-6:00', '-5:00', '-4:00', '-3:30', '-3:00', '-2:00', '-1:00', '', '+1:00', '+2:00', '+3:00', '+3:30', '+4:00', '+4:30', '+5:00', '+5:30', '+6:00', '+6:30', '+7:00', '+8:00', '+9:30', '+9:30', '+10:00', '+11:00', '+12:00');

	for ($i = 0; $i < 31; $i++)	{
		if ($iValue == $arrValue[$i])
			$optionValue .= '<option value="'.$arrValue[$i].'" selected="selected">UTC '.$arrFormat[$i].'</option>';
		else
			$optionValue .= '<option value="'.$arrValue[$i].'">UTC '.$arrFormat[$i].'</option>';
	}

	return $optionValue;
}

function cf_getOptionFile($arrItems) {
	$optionValue = '';
	
	$rowsFile = count($arrItems);

	for ($i = 0; $i < $rowsFile; $i++) {
		$arrData = explode("|", $arrItems[$i]);
		$optionValue .= '<option value="'.$arrData[0].'">'.$arrData[1].'</option>';
	}

	return $optionValue;
}

?>