<?php
//---------------------------------------------------------------------
//  -- Adriel Media --
//---------------------------------------------------------------------
// Admin Control Panel * User profile page
// Product: Faisan Guestbook
// Written by: Adriel Ricardo Torres aka RicarDooM
// Website: http://adrielmedia.com
// Date:    08/12/2009
// Updated: 01/04/2010
//---------------------------------------------------------------------

//---------------------------------------------------------------------
// File name: user_profile.php
// File version: 1.0
//---------------------------------------------------------------------

//---------------------------------------------------------------------
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation.
//---------------------------------------------------------------------
require_once('adminHeader.php');

if ($isLogged != 1)
	header("Location: index.php");
//------------------
// Begin page source
//------------------
$pageError = array();
$actionMade = 0;
$thisUser = new usersVO();
$fileUser = new fileManager('../'.$cf_dataPath.'/users.php', 'r');
$userOldPass = '';
$userNewPass = '';
$userNewPassConfirm = '';
$strToInsert = '';

for ($i = 0; $i < $fileUser->getRows(); $i++) {
	$arrData = explode("|", $fileUser->getDataRow($i));
	
	if ($arrData[0] == htmlentities($_SESSION['sesUserId'], ENT_QUOTES)) {
		$thisUser->setUserName($arrData[1]);
		$thisUser->setUserPass($arrData[2]);
		$thisUser->setUserEmail($arrData[3]);
		$thisUser->setUserWebsite($arrData[4]);
		$thisUser->setUserLocation($arrData[5]);
		break;
	}
}

if ($action == 'saveData' && is_writable('../'.$cf_dataPath.'/users.php')) {
	$thisUser->setUserEmail(htmlentities($_POST['userEmail'], ENT_QUOTES));
	$thisUser->setUserWebsite(htmlentities($_POST['userWebsite'], ENT_QUOTES));
	$thisUser->setUserLocation(htmlentities($_POST['userLocation'], ENT_QUOTES));
	
	// Validating fields
	if(isset($_POST['chkOption'])) {
		$userOldPass = md5(htmlentities($_POST['userOldPass'], ENT_QUOTES));
		$userNewPass = htmlentities($_POST['userNewPass'], ENT_QUOTES);
		$userNewPassConfirm = htmlentities($_POST['userNewPassConfirm'], ENT_QUOTES);
		
		if ($thisUser->getUserPass() == $userOldPass) {
			if (cf_validateRequiredField($userNewPass) != 0)
				$pageError[] = $langMsg['New_pass_empty_warn'];
			elseif ($userNewPass != $userNewPassConfirm)
				$pageError[] = $langMsg['New_pass_warn'];
			elseif (strlen($userNewPass) < 4)
				$pageError[] = $langMsg['New_pass_short_warn'];
			else
				$thisUser->setUserPass(md5($userNewPass));
		} else
			$pageError[] = $langMsg['Old_pass_warn'];
	}

	if (cf_validateEmail($thisUser->getUserEmail()) != 0)
		$pageError[] = $langMsg['Email_warn'];

	if (cf_validateWebsite($thisUser->getUserWebsite()) != 0)
		$pageError[] = $langMsg['Website_warn'];

	// Updating user profile
	if (count($pageError) == 0) {	
		for ($i = 0; $i < $fileUser->getRows(); $i++) {
			$arrData = explode("|", $fileUser->getDataRow($i));
			
			if ($arrData[0] == $_SESSION['sesUserId'])
				$strToInsert .= $arrData[0].'|'.
								$thisUser->getUserName().'|'.
								$thisUser->getUserPass().'|'.
								$thisUser->getUserEmail().'|'.
								$thisUser->getUserWebsite().'|'.
								$thisUser->getUserLocation().'|'.
								$arrData[6]."|\n";
			else
				$strToInsert .= $fileUser->getDataRow($i);
		}
			
		$debug[] = "$strToInsert\n";		
		$saveFile = new fileManager('../'.$cf_dataPath.'/users.php', 'w');
		$saveFile->saveData($strToInsert);
		$actionMade = 1;
	}	
}
//------------------
// End page source
//------------------
//******************
//------------------
// Begin page output
//------------------
if (defined('DEBUG')) {
	echo "<!--\n";
	for ($i=0; $i<count($debug); $i++)
		echo $debug[$i];
	echo "-->\n";
}

// Showing admin header
$mainTpl->showHeader($isLogged);

// User profile body
$tplVars['{USER_PROFILE}'] = $langMsg['User_profile'];
$tplVars['{USER_NAME_TEXT}'] = $langMsg['Username'];
$tplVars['{USER_PASS_TEXT}'] = $langMsg['Old_password'];
$tplVars['{CHANGE_PASSWORD_?}'] = $langMsg['Change_password?'];
$tplVars['{NEW_USER_PASS_TEXT}'] = $langMsg['New_password'];
$tplVars['{NEW_USER_PASS_CONFIRM_TEXT}'] = $langMsg['Confirm_password'];
$tplVars['{USER_EMAIL_TEXT}'] = $langMsg['Email'];
$tplVars['{USER_LOCATION_TEXT}'] = $langMsg['Location'];
$tplVars['{USER_WEBSITE_TEXT}'] = $langMsg['Website'];
$tplVars['{USER_NAME_VALUE}'] = $thisUser->getUserName();
$tplVars['{USER_PASS_VALUE}'] = '';
$tplVars['{NEW_USER_PASS_VALUE}'] = '';
$tplVars['{NEW_USER_PASS_CONFIRM_VALUE}'] = '';
$tplVars['{USER_EMAIL_VALUE}'] = $thisUser->getUserEmail();
$tplVars['{USER_LOCATION_VALUE}'] = $thisUser->getUserLocation();
$tplVars['{USER_WEBSITE_VALUE}'] = $thisUser->getUserWebsite();
$tplVars['{SAVE_CHANGES}'] = $langMsg['Save_changes'];

echo (new templateParser("../$tplPath/tpl/profileBody.html", $tplVars));

if (count($pageError) > 0) {
	// Warning message
	$tplVars['{SERVER_MESSAGE_CLASS}'] = 'warningMessage';
	$tplVars['{SERVER_MESSAGE}'] = '';	
	for ($i=0; $i<count($pageError); $i++)
		$tplVars['{SERVER_MESSAGE}'] .= "<p>$pageError[$i]</p>";

	echo (new templateParser("../$tplPath/tpl/serverMessage.html", $tplVars));
} elseif ($actionMade == 1) {
	// Server message
	$tplVars['{SERVER_MESSAGE_CLASS}'] = 'serverMessage';
	$tplVars['{SERVER_MESSAGE}'] = '<p>'.$langMsg['Profile_saved'].'</p>';
	echo (new templateParser("../$tplPath/tpl/serverMessage.html", $tplVars));
}

// Showing admin footer
$mainTpl->showFooter();
//----------------
// End page output
//----------------
?>