<?php
//---------------------------------------------------------------------
//  -- Adriel Media --
//---------------------------------------------------------------------
// Admin Control Panel * Spam log page
// Product: Faisan Guestbook
// Written by: Adriel Ricardo Torres aka RicarDooM
// Website: http://adrielmedia.com
// Date:    08/12/2009
// Updated: 30/01/2010
//---------------------------------------------------------------------

//---------------------------------------------------------------------
// File name: mng_spamlog.php
// File version: 1.0
//---------------------------------------------------------------------

//---------------------------------------------------------------------
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation.
//---------------------------------------------------------------------
require_once('adminHeader.php');

if ($isLogged != 1)
	header("Location: index.php");
//------------------
// Begin page source
//------------------
$idSpam = 0;
$arrIndex = 0;
$strToInsert = '';
$actionMade = 0;
$pageError = 0;
$arrData = array();
$myItem = new itemsVO();
$fileSpamLog = new fileManager('../'.$cf_dataPath.'/spamLog', 'r');

if ($action == 'saveItem' && is_writable('../'.$cf_dataPath.'/spamLog')) {
	$actionMade = 1;
	$myItem->setItemDesc(htmlentities($_POST['strItem'], ENT_QUOTES));
	
	if ($myItem->getItemDesc() != '') {	
		if ($fileSpamLog->getRows() == 0)
			$myItem->setItemId(1);
		else {
			$tmpId = explode('|', $fileSpamLog->getDataRow(($fileSpamLog->getRows()-1)));
			$myItem->setItemId($tmpId[0]+1);
		}		
		$fileSpamLog->closeFile();
		
		$strToInsert = $myItem->getItemId().'|'.
						$myItem->getItemDesc().'|'."\n";
						
		$fileSpamLog->addDataRow($strToInsert);

		$debug[] = "$strToInsert\n";		
		$saveSpamLog = new fileManager('../'.$cf_dataPath.'/spamLog', 'a');
		$saveSpamLog->saveData($strToInsert);
	}
	else
		$pageError = 1;
}
elseif ($action == 'deleteItem' && is_writable('../'.$cf_dataPath.'/spamLog')) {
	$actionMade = 2;
	$idSpam = htmlentities($_POST['idItem'], ENT_QUOTES);
	
	for ($i = 0; $i < $fileSpamLog->getRows(); $i++) {
		$arrData = explode("|", $fileSpamLog->getDataRow($i));
		
		if ($arrData[0] != $idSpam)
			$strToInsert .= $fileSpamLog->getDataRow($i);
		elseif ($arrData[0] == $idSpam)
			$arrIndex = $i;
	}
	
	$fileSpamLog->deleteDataRow($arrIndex);
	
	$debug[] = "$strToInsert\n";		
	$saveSpamLog = new fileManager('../'.$cf_dataPath.'/spamLog', 'w');
	$saveSpamLog->saveData($strToInsert);
}
//------------------
// End page source
//------------------
//******************
//------------------
// Begin page output
//------------------
if (defined('DEBUG')) {
	echo "<!--\n";
	for ($i=0; $i<count($debug); $i++)
		echo $debug[$i];
	echo "-->\n";
}

// Showing admin CP header
$mainTpl->showHeader($isLogged);

// Spam log body
$tplVars['{ITEM_TITLE}'] = $langMsg['Save_spam_word'];
$tplVars['{ENTER_ITEM}'] = $langMsg['Enter_spam_word'];
$tplVars['{ITEM_SUB_TITLE}'] = $langMsg['Remove_spam_word'];
$tplVars['{ITEM_MESSAGE}'] = $langMsg['Main_spam_message'];
$tplVars['{ITEM_LIST}'] = cf_getOptionFile($fileSpamLog->getAllDataRows());
$tplVars['{SAVE}'] = $langMsg['Save'];
$tplVars['{DELETE}'] = $langMsg['Delete'];
$tplVars['{SAVED_ITEM_MESSAGE}'] = '&nbsp;';
$tplVars['{DELETED_ITEM_MESSAGE}'] = '&nbsp;';
$tplVars['{ERROR_MESSAGE}'] = '&nbsp;';

echo (new templateParser("../$tplPath/tpl/commonItemBody.html", $tplVars));

if ($pageError == 1) {
	// Warning message
	$tplVars['{SERVER_MESSAGE_CLASS}'] = 'warningMessage';
	$tplVars['{SERVER_MESSAGE}'] = '<p>'.$langMsg['Field_required'].'</p>';	

	echo (new templateParser("../$tplPath/tpl/serverMessage.html", $tplVars));
} elseif ($actionMade == 1) {
	// Server message
	$tplVars['{SERVER_MESSAGE_CLASS}'] = 'serverMessage';
	$tplVars['{SERVER_MESSAGE}'] = '<p>'.$langMsg['Saved_spam_message'].'</p>';
	echo (new templateParser("../$tplPath/tpl/serverMessage.html", $tplVars));
} elseif ($actionMade == 2) {
	// Server message
	$tplVars['{SERVER_MESSAGE_CLASS}'] = 'serverMessage';
	$tplVars['{SERVER_MESSAGE}'] = '<p>'.$langMsg['Deleted_spam_message'].'</p>';
	echo (new templateParser("../$tplPath/tpl/serverMessage.html", $tplVars));
}

// Showing admin CP footer
$mainTpl->showFooter();
//----------------
// End page output
//----------------
?>