<?php
//---------------------------------------------------------------------
//  -- Adriel Media --
//---------------------------------------------------------------------
// Admin Control Panel * Manage smileys page
// Product: Faisan Guestbook
// Written by: Adriel Ricardo Torres aka RicarDooM
// Website: http://adrielmedia.com
// Date:    08/12/2009
// Updated: 05/02/2010
//---------------------------------------------------------------------

//---------------------------------------------------------------------
// File name: mng_smileys.php
// File version: 1.0
//---------------------------------------------------------------------

//---------------------------------------------------------------------
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation.
//---------------------------------------------------------------------
require_once('adminHeader.php');

if ($isLogged != 1)
	header("Location: index.php");
//------------------
// Begin page source
//------------------
$pageError = array();
$actionMade = 0;
$iIndex = 0;
$smiley = new smileysVO();
$smileyFile = new fileManager('../'.$cf_dataPath.'/smileys', 'r');
$strToInsert = '';

if (($action == $langMsg['Save'] || $action == $langMsg['Edit']) && is_writable('../'.$cf_dataPath.'/smileys')) {
	$smiley->setSmileyId(htmlentities($_POST['smileyId'], ENT_QUOTES));
	$smiley->setSmileyTag(htmlentities($_POST['smileyTag'], ENT_QUOTES));
	$smiley->setSmileyUrl(htmlentities($_POST['smileyUrl'], ENT_QUOTES));
	$smiley->setSmileyDesc(htmlentities($_POST['smileyDesc'], ENT_QUOTES));

	if ($action == $langMsg['Save'])
		$actionMade = 1;
	else
		$actionMade = 2;

	if ($smiley->getSmileyTag() == '')
		$pageError[] = $langMsg['Smiley_tag_warn'];

	if ($smiley->getSmileyUrl() == '')
		$pageError[] = $langMsg['Smiley_url_warn'];

	if ($smiley->getSmileyDesc() == '')
		$pageError[] = $langMsg['Smiley_description_warn'];

	if (count($pageError) == 0) {
		if ($actionMade == 1) {
			// Saving new smiley
			if ($smileyFile->getRows() == 0)
				$smiley->setSmileyId(1);
			else {
				$tmpId = explode('|', $smileyFile->getDataRow(($smileyFile->getRows()-1)));
				$smiley->setSmileyId($tmpId[0]+1);
			}
			$smileyFile->closeFile();

			$strToInsert = $smiley->getSmileyId().'|'.
							$smiley->getSmileyTag().'|'.
							$smiley->getSmileyUrl().'|'.
							$smiley->getSmileyDesc().'|'."\n";

			$smileyFile->addDataRow($strToInsert);

			$saveFile = new fileManager('../'.$cf_dataPath.'/smileys', 'a');
			$saveFile->saveData($strToInsert);			
		} elseif ($actionMade == 2) {
			// Updating smiley
			for ($i=0; $i<$smileyFile->getRows(); $i++) {
				$arrSmiley = explode('|', $smileyFile->getDataRow($i));
				
				if ($arrSmiley[0] == $smiley->getSmileyId()) {
					$iIndex = $i;
					$strToInsert .= $smiley->getSmileyId().'|'.
									$smiley->getSmileyTag().'|'.
									$smiley->getSmileyUrl().'|'.
									$smiley->getSmileyDesc().'|'."\n";
				} else
					$strToInsert .= $smileyFile->getDataRow($i);
			}

			$smileyFile->updateDataRow($iIndex, $smiley->getSmileyId().'|'.
												  $smiley->getSmileyTag().'|'.
												  $smiley->getSmileyUrl().'|'.
												  $smiley->getSmileyDesc().'|'."\n");
			
			$saveFile = new fileManager('../'.$cf_dataPath.'/smileys', 'w');
			$saveFile->saveData($strToInsert);
		}
		$smiley->__construct();
	}
} elseif ($action == 'D' && is_writable('../'.$cf_dataPath.'/smileys')) {
	$smiley->setSmileyId(htmlentities($_GET['id'], ENT_QUOTES));
	$actionMade = 3;
	// Deleting smiley
	for ($i=0; $i<$smileyFile->getRows(); $i++) {
		$arrSmiley = explode('|', $smileyFile->getDataRow($i));

		if ($arrSmiley[0] != $smiley->getSmileyId())
			$strToInsert .= $smileyFile->getDataRow($i);
		elseif ($arrSmiley[0] == $smiley->getSmileyId())
			$iIndex = $i;
	}
	
	$smileyFile->deleteDataRow($iIndex);
	
	$saveFile = new fileManager('../'.$cf_dataPath.'/smileys', 'w');
	$saveFile->saveData($strToInsert);
	
} elseif ($action == 'E') {
	$smiley->setSmileyId(htmlentities($_GET['id'], ENT_QUOTES));

	for ($i=0; $i<$smileyFile->getRows(); $i++) {
		$arrSmiley = explode('|', $smileyFile->getDataRow($i));
		
		if ($arrSmiley[0] == $smiley->getSmileyId()) {
			$smiley->setSmileyTag($arrSmiley[1]);
			$smiley->setSmileyUrl($arrSmiley[2]);
			$smiley->setSmileyDesc($arrSmiley[3]);
			break;
		}
	}
} elseif ($action == $langMsg['Cancel'])
	$smiley->__construct();
//------------------
// End page source
//------------------
//******************
//------------------
// Begin page output
//------------------
if (defined('DEBUG')) {
	echo "<!--\n";
	for ($i=0; $i<count($debug); $i++)
		echo $debug[$i];
	echo "-->\n";
}

// Showing admin CP header
$mainTpl->showHeader($isLogged);

// Manage smileys body
$tplVars['{MANAGE_SMILEYS}'] = $langMsg['Manage_smileys'];

if ($action == 'E' || ($actionMade == 2 && count($pageError) > 0)) {
	$tplVars['{SMILEYS_ADD_EDIT}'] = $langMsg['Edit_smiley'];
	$tplVars['{SAVE_EDIT}'] = $langMsg['Edit'];
} else {
	$tplVars['{SMILEYS_ADD_EDIT}'] = $langMsg['Add_smiley'];
	$tplVars['{SAVE_EDIT}'] = $langMsg['Save'];
}

$tplVars['{SMILEY_TAG_TEXT}'] = $langMsg['Smiley_tag'];
$tplVars['{SMILEY_URL_TEXT}'] = $langMsg['Smiley_url'];
$tplVars['{SMILEY_DESC_TEXT}'] = $langMsg['Smiley_description'];
$tplVars['{SMILEY_ID}'] = $smiley->getSmileyId();
$tplVars['{SMILEY_TAG_VALUE}'] = $smiley->getSmileyTag();
$tplVars['{SMILEY_URL_VALUE}'] = $smiley->getSmileyUrl();
$tplVars['{SMILEY_DESC_VALUE}'] = $smiley->getSmileyDesc();
$tplVars['{CANCEL}'] = $langMsg['Cancel'];

$smileyUrl = '';
$smileyRowClass = '';
$bFlag = true;
$strSmileys = '<table class="smileyTable">
			   <tr><th>'.$langMsg['Preview'].'</th><th>'.$langMsg['Tag'].'</th><th>'.$langMsg['Url'].'</th><th>'.$langMsg['Description'].'</th><th>&nbsp;</th></tr>';
for ($i=0; $i<$smileyFile->getRows(); $i++) {
	$arrSmiley = explode('|', $smileyFile->getDataRow($i));
	
	if (preg_match("/^[http:\/\/]/i", $arrSmiley[2]))
		$smileyUrl = $arrSmiley[2];
	else
		$smileyUrl = '../'.$arrSmiley[2];
	
	if ($bFlag == true) {
		$smileyRowClass = 'smileyRow1';
		$bFlag = false;
	} else {
		$smileyRowClass = 'smileyRow2';
		$bFlag = true;
	}
	$strSmileys .= '<tr class="'.$smileyRowClass.'"><td style="text-align: center;"><img src="'.$smileyUrl.'" border="0" alt="'.$arrSmiley[3].'" /></td><td>'.$arrSmiley[1].'</td><td>'.$arrSmiley[2].'</td><td>'.$arrSmiley[3].'</td>
				    <td><a href="?action=E&id='.$arrSmiley[0].'">'.$langMsg['Edit'].'</a> - <a href="#" onclick="js_confirm_action(\''.$langMsg['Confirm_question'].'\', \'?action=D&id='.$arrSmiley[0].'\')">'.$langMsg['Delete'].'</a></td></tr>';
}
$strSmileys .= '</table>';
$tplVars['{SMILEY_TABLE_LIST}'] = $strSmileys;
echo (new templateParser("../$tplPath/tpl/smileysBody.html", $tplVars));

if (count($pageError) > 0) {
	// Warning message
	$tplVars['{SERVER_MESSAGE_CLASS}'] = 'warningMessage';
	$tplVars['{SERVER_MESSAGE}'] = '';	
	for ($i=0; $i<count($pageError); $i++)
		$tplVars['{SERVER_MESSAGE}'] .= "<p>$pageError[$i]</p>";

	echo (new templateParser("../$tplPath/tpl/serverMessage.html", $tplVars));
} elseif ($actionMade == 1) {
	// Server message
	$tplVars['{SERVER_MESSAGE_CLASS}'] = 'serverMessage';
	$tplVars['{SERVER_MESSAGE}'] = '<p>'.$langMsg['Save_smiley_message'].'</p>';
	echo (new templateParser("../$tplPath/tpl/serverMessage.html", $tplVars));
} elseif ($actionMade == 2) {
	// Server message
	$tplVars['{SERVER_MESSAGE_CLASS}'] = 'serverMessage';
	$tplVars['{SERVER_MESSAGE}'] = '<p>'.$langMsg['Edit_smiley_message'].'</p>';
	echo (new templateParser("../$tplPath/tpl/serverMessage.html", $tplVars));
} elseif ($actionMade == 3) {
	// Server message
	$tplVars['{SERVER_MESSAGE_CLASS}'] = 'serverMessage';
	$tplVars['{SERVER_MESSAGE}'] = '<p>'.$langMsg['Delete_smiley_message'].'</p>';
	echo (new templateParser("../$tplPath/tpl/serverMessage.html", $tplVars));
}

// Showing admin CP footer
$mainTpl->showFooter();
//----------------
// End page output
//----------------
?>