<?php
//---------------------------------------------------------------------
//  -- Adriel Media --
//---------------------------------------------------------------------
// Admin Control Panel * Ip log page
// Product: Faisan Guestbook
// Written by: Adriel Ricardo Torres aka RicarDooM
// Website: http://adrielmedia.com
// Date:    08/12/2009
// Updated: 30/01/2010
//---------------------------------------------------------------------

//---------------------------------------------------------------------
// File name: mng_iplog.php
// File version: 1.0
//---------------------------------------------------------------------

//---------------------------------------------------------------------
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation.
//---------------------------------------------------------------------
require_once('adminHeader.php');

if ($isLogged != 1)
	header("Location: index.php");
//------------------
// Begin page source
//------------------
$idIP = 0;
$arrIndex = 0;
$strIP = '';
$strToInsert = '';
$actionMade = 0;
$pageError = 0;
$arrData = array();
$myItem = new itemsVO();
$fileIpLog = new fileManager('../'.$cf_dataPath.'/ipLog', 'r');

if ($action == 'saveItem' && is_writable('../'.$cf_dataPath.'/ipLog')) {
	$actionMade = 1;
	$myItem->setItemDesc(htmlentities($_POST['strItem'], ENT_QUOTES));
	
	if ($myItem->getItemDesc() == '')
		$pageError = 1;
	elseif (cf_validateIP($myItem->getItemDesc()) != 0)
		$pageError = 2;
	
	if ($pageError == 0) {	
		if ($fileIpLog->getRows() == 0)
			$myItem->setItemId(1);
		else {
			$tmpId = explode('|', $fileIpLog->getDataRow(($fileIpLog->getRows()-1)));
			$myItem->setItemId($tmpId[0]+1);
		}		
		$fileIpLog->closeFile();
		
		$strToInsert = $myItem->getItemId().'|'.
						$myItem->getItemDesc().'|'."\n";
						
		$fileIpLog->addDataRow($strToInsert);

		$debug[] = "$strToInsert\n";		
		$saveIpLog = new fileManager('../'.$cf_dataPath.'/ipLog', 'a');
		$saveIpLog->saveData($strToInsert);
	}
}
elseif ($action == 'deleteItem' && is_writable('../'.$cf_dataPath.'/ipLog')) {
	$actionMade = 2;
	$idIP = htmlentities($_POST['idItem'], ENT_QUOTES);
	
	for ($i = 0; $i < $fileIpLog->getRows(); $i++) {
		$arrData = explode("|", $fileIpLog->getDataRow($i));
		
		if ($arrData[0] != $idIP)
			$strToInsert .= $fileIpLog->getDataRow($i);
		elseif ($arrData[0] == $idIP)
			$arrIndex = $i;
	}
	
	$fileIpLog->deleteDataRow($arrIndex);
	
	$debug[] = "$strToInsert\n";		
	$saveIpLog = new fileManager('../'.$cf_dataPath.'/ipLog', 'w');
	$saveIpLog->saveData($strToInsert);
}
//------------------
// End page source
//------------------
//******************
//------------------
// Begin page output
//------------------
if (defined('DEBUG')) {
	echo "<!--\n";
	for ($i=0; $i<count($debug); $i++)
		echo $debug[$i];
	echo "-->\n";
}

// Showing admin CP header
$mainTpl->showHeader($isLogged);

// Spam log body
$tplVars['{ITEM_TITLE}'] = $langMsg['Save_banip_word'];
$tplVars['{ENTER_ITEM}'] = $langMsg['Enter_banip_word'];
$tplVars['{ITEM_SUB_TITLE}'] = $langMsg['Remove_banip_word'];
$tplVars['{ITEM_MESSAGE}'] = $langMsg['Main_banip_message'];
$tplVars['{ITEM_LIST}'] = cf_getOptionFile($fileIpLog->getAllDataRows());
$tplVars['{SAVE}'] = $langMsg['Save'];
$tplVars['{DELETE}'] = $langMsg['Delete'];
$tplVars['{SAVED_ITEM_MESSAGE}'] = '&nbsp;';
$tplVars['{DELETED_ITEM_MESSAGE}'] = '&nbsp;';
$tplVars['{ERROR_MESSAGE}'] = '&nbsp;';

echo (new templateParser("../$tplPath/tpl/commonItemBody.html", $tplVars));

if ($pageError > 0) {
	// Warning message
	$tplVars['{SERVER_MESSAGE_CLASS}'] = 'warningMessage';
	
	if ($pageError == 1)
		$tplVars['{SERVER_MESSAGE}'] = '<p>'.$langMsg['Field_required'].'</p>';
	elseif ($pageError == 2)
		$tplVars['{SERVER_MESSAGE}'] = '<p>'.$langMsg['Banip_warn'].'</p>';

	echo (new templateParser("../$tplPath/tpl/serverMessage.html", $tplVars));
} elseif ($actionMade == 1) {
	// Server message
	$tplVars['{SERVER_MESSAGE_CLASS}'] = 'serverMessage';
	$tplVars['{SERVER_MESSAGE}'] = '<p>'.$langMsg['Saved_banip_message'].'</p>';
	echo (new templateParser("../$tplPath/tpl/serverMessage.html", $tplVars));
} elseif ($actionMade == 2) {
	// Server message
	$tplVars['{SERVER_MESSAGE_CLASS}'] = 'serverMessage';
	$tplVars['{SERVER_MESSAGE}'] = '<p>'.$langMsg['Deleted_banip_message'].'</p>';
	echo (new templateParser("../$tplPath/tpl/serverMessage.html", $tplVars));
}

// Showing admin CP footer
$mainTpl->showFooter();
//----------------
// End page output
//----------------
?>