<?php
//---------------------------------------------------------------------
//  -- Adriel Media --
//---------------------------------------------------------------------
// Admin Control Panel * Censored words page
// Product: Faisan Guestbook
// Written by: Adriel Ricardo Torres aka RicarDooM
// Website: http://adrielmedia.com
// Date:    08/12/2009
// Updated: 07/02/2010
//---------------------------------------------------------------------

//---------------------------------------------------------------------
// File name: mng_cwords.php
// File version: 1.0
//---------------------------------------------------------------------

//---------------------------------------------------------------------
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation.
//---------------------------------------------------------------------
require_once('adminHeader.php');

if ($isLogged != 1)
	header("Location: index.php");
//------------------
// Begin page source
//------------------
$idCWord = 0;
$arrIndex = 0;
$strToInsert = '';
$actionMade = 0;
$pageError = 0;
$arrData = array();
$myItem = new itemsVO();
$fileCWord = new fileManager('../'.$cf_dataPath.'/cwordsLog', 'r');

if ($action == 'saveItem' && is_writable('../'.$cf_dataPath.'/cwordsLog')) {
	$actionMade = 1;
	$myItem->setItemDesc(htmlentities($_POST['strItem'], ENT_QUOTES));
	
	if ($myItem->getItemDesc() != '') {	
		if ($fileCWord->getRows() == 0)
			$myItem->setItemId(1);
		else {
			$tmpId = explode('|', $fileCWord->getDataRow(($fileCWord->getRows()-1)));
			$myItem->setItemId($tmpId[0]+1);
		}		
		$fileCWord->closeFile();
		
		$strToInsert = $myItem->getItemId().'|'.
						$myItem->getItemDesc().'|'."\n";
						
		$fileCWord->addDataRow($strToInsert);
		$debug[] = "$strToInsert\n";		
		$saveCWord = new fileManager('../'.$cf_dataPath.'/cwordsLog', 'a');
		$saveCWord->saveData($strToInsert);
	}
	else
		$pageError = 1;	
}
elseif ($action == 'deleteItem' && is_writable('../'.$cf_dataPath.'/cwordsLog')) {
	$actionMade = 2;
	$idCWord = htmlentities($_POST['idItem'], ENT_QUOTES);
	
	for ($i = 0; $i < $fileCWord->getRows(); $i++) {
		$arrData = explode("|", $fileCWord->getDataRow($i));
		
		if ($arrData[0] != $idCWord)
			$strToInsert .= $fileCWord->getDataRow($i);
		elseif ($arrData[0] == $idCWord)
			$arrIndex = $i;
	}
	
	$fileCWord->deleteDataRow($arrIndex);	
	$debug[] = "$strToInsert\n";		
	$saveCWord = new fileManager('../'.$cf_dataPath.'/cwordsLog', 'w');
	$saveCWord->saveData($strToInsert);
}
//------------------
// End page source
//------------------
//******************
//------------------
// Begin page output
//------------------
if (defined('DEBUG')) {
	echo "<!--\n";
	for ($i=0; $i<count($debug); $i++)
		echo $debug[$i];
	echo "-->\n";
}

// Showing admin CP header
$mainTpl->showHeader($isLogged);

// Bad words log body
$tplVars['{ITEM_TITLE}'] = $langMsg['Save_cword_word'];
$tplVars['{ENTER_ITEM}'] = $langMsg['Enter_cword_word'];
$tplVars['{ITEM_SUB_TITLE}'] = $langMsg['Remove_cword_word'];
$tplVars['{ITEM_MESSAGE}'] = $langMsg['Main_cword_message'];
$tplVars['{ITEM_LIST}'] = cf_getOptionFile($fileCWord->getAllDataRows());
$tplVars['{SAVE}'] = $langMsg['Save'];
$tplVars['{DELETE}'] = $langMsg['Delete'];
$tplVars['{ERROR_MESSAGE}'] = '&nbsp;';
$tplVars['{SAVED_ITEM_MESSAGE}'] = '&nbsp;';
$tplVars['{DELETED_ITEM_MESSAGE}'] = '&nbsp;';

echo (new templateParser("../$tplPath/tpl/commonItemBody.html", $tplVars));

if ($pageError == 1) {
	// Warning message
	$tplVars['{SERVER_MESSAGE_CLASS}'] = 'warningMessage';
	$tplVars['{SERVER_MESSAGE}'] = '<p>'.$langMsg['Field_required'].'</p>';	

	echo (new templateParser("../$tplPath/tpl/serverMessage.html", $tplVars));
} elseif ($actionMade == 1) {
	// Server message
	$tplVars['{SERVER_MESSAGE_CLASS}'] = 'serverMessage';
	$tplVars['{SERVER_MESSAGE}'] = '<p>'.$langMsg['Saved_cword_message'].'</p>';
	echo (new templateParser("../$tplPath/tpl/serverMessage.html", $tplVars));
} elseif ($actionMade == 2) {
	// Server message
	$tplVars['{SERVER_MESSAGE_CLASS}'] = 'serverMessage';
	$tplVars['{SERVER_MESSAGE}'] = '<p>'.$langMsg['Deleted_cword_message'].'</p>';
	echo (new templateParser("../$tplPath/tpl/serverMessage.html", $tplVars));
}

// Showing admin CP footer
$mainTpl->showFooter();
//----------------
// End page output
//----------------
?>