<?php
//---------------------------------------------------------------------
//  -- Adriel Media --
//---------------------------------------------------------------------
// Admin Control Panel * Manage comments page
// Product: Faisan Guestbook
// Written by: Adriel Ricardo Torres aka RicarDooM
// Website: http://adrielmedia.com
// Date:    08/12/2009
// Updated: 08/04/2010
//---------------------------------------------------------------------

//---------------------------------------------------------------------
// File name: mng_comments.php
// File version: 1.0
//---------------------------------------------------------------------

//---------------------------------------------------------------------
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation.
//---------------------------------------------------------------------
require_once('adminHeader.php');

if ($isLogged != 1)
	header("Location: index.php");
//------------------
// Begin page source
//------------------
$pageError = array();
$iIndex = 0;
$actionMade = 0;
$commentType = 0;
$commentId = 0;
$commentFile = new fileManager('../'.$cf_dataPath.'/comments.php', 'r');
$strToInsert = '';
$arrData = array();
$arrToShow = array();

// Setting comments type
if ($action == $langMsg['Unpublished'])
	$_SESSION['sesCommentType'] = 1;
elseif ($action == $langMsg['Spam'])
	$_SESSION['sesCommentType'] = 2;
elseif ($action == $langMsg['Published'])
	$_SESSION['sesCommentType'] = 0;
	
$commentType = $_SESSION['sesCommentType'];
	
// Actions
if (isset($_GET['id']))
	$commentId = htmlentities($_GET['id'], ENT_QUOTES);

// Delete Single Comment
if ($commentId > 0 && is_writable('../'.$cf_dataPath.'/comments.php') && $commentFile->getRows() > 1) {
	if ($action == 'D') {
		$actionMade = 1;
		for ($i = 0; $i < $commentFile->getRows(); $i++) {
			$arrData = explode('|', $commentFile->getDataRow($i));

			if ($arrData[0] == $commentId)
				$iIndex = $i;
			else
				$strToInsert .= $commentFile->getDataRow($i);
		}
		$commentFile->deleteDataRow($iIndex);

		$saveFile = new fileManager('../'.$cf_dataPath.'/comments.php', 'w');
		$saveFile->saveData($strToInsert);
	} elseif ($action == 'P') {
		$actionMade = 2;
		for ($i = 0; $i < $commentFile->getRows(); $i++) {
			$arrData = explode('|', $commentFile->getDataRow($i));

			if ($arrData[0] == $commentId) {
				$iIndex = $i;
				$strToInsert .= $arrData[0].'|'.
								$arrData[1].'|0|'.
								$arrData[3].'|'.
								$arrData[4].'|'.
								$arrData[5].'|'.
								$arrData[6].'|'.
								$arrData[7].'|'.
								$arrData[8].'|'.
								$arrData[9].'|'."\n";
			} else
				$strToInsert .= $commentFile->getDataRow($i);
		}
		$commentFile->deleteDataRow($iIndex);

		$saveFile = new fileManager('../'.$cf_dataPath.'/comments.php', 'w');
		$saveFile->saveData($strToInsert);
	}
} elseif ($commentType != 0 && is_writable('../'.$cf_dataPath.'/comments.php') && $commentFile->getRows() > 1) {
	if ($action == 'DAll') {
		$actionMade = 3;
		for ($i = 0; $i < $commentFile->getRows(); $i++) {
			$arrData = explode('|', $commentFile->getDataRow($i));

			if ($arrData[2] != $commentType)
				$strToInsert .= $commentFile->getDataRow($i);
		}
		$saveFile = new fileManager('../'.$cf_dataPath.'/comments.php', 'w');
		$saveFile->saveData($strToInsert);
	} elseif ($action == 'PAll') {
		$actionMade = 4;
		for ($i = 0; $i < $commentFile->getRows(); $i++) {		
			// Checking if commnet line is not corrupted
			if ($i == 0 || $commentFile->getRowFields($i, '|') == constant('COMMENTS_FIELDS')) {
				$arrData = explode('|', $commentFile->getDataRow($i));

				if ($arrData[2] == $commentType) {
					$strToInsert .= $arrData[0].'|'.
									$arrData[1].'|0|'.
									$arrData[3].'|'.
									$arrData[4].'|'.
									$arrData[5].'|'.
									$arrData[6].'|'.
									$arrData[7].'|'.
									$arrData[8].'|'.
									$arrData[9].'|'."\n";
				} else
					$strToInsert .= $commentFile->getDataRow($i);
			}
		}
		$saveFile = new fileManager('../'.$cf_dataPath.'/comments.php', 'w');
		$saveFile->saveData($strToInsert);
	}
}

if ($actionMade < 3) {
	for ($i = 1; $i < $commentFile->getRows(); $i++) {		
		// Checking if commnet line is not corrupted
		if ($commentFile->getRowFields($i, '|') == constant('COMMENTS_FIELDS')) {
			$arrData = explode('|', $commentFile->getDataRow($i));

			if ($arrData[2] == $commentType)
				$arrToShow[] = $commentFile->getDataRow($i);
		}
		else
			$debug[] = "Warning. Data on line $i is corrupted, current line would be ommited.\n";
	}
	$arrLines = count($arrToShow);
} else
	$arrLines = 0;
	
// Loading Paginatior class
$iPage = 1;

if (isset($_GET['page']))
	$iPage = intval(htmlentities($_GET['page']));

$pPaginator = new amPaginator($arrLines, $iPage, 20, 5);
//------------------
// End page source
//------------------
//******************
//------------------
// Begin page output
//------------------
if (defined('DEBUG')) {
	echo "<!--\n";
	for ($i=0; $i<count($debug); $i++)
		echo $debug[$i];
	echo "-->\n";
}

// Showing admin header
$mainTpl->showHeader($isLogged);

// Manage comments body
$tplVars['{MANAGE_COMMENTS}'] = $langMsg['Manage_comments'];
$tplVars['{VIEW}'] = $langMsg['View'];
$tplVars['{PUBLISHED}'] = $langMsg['Published'];
$tplVars['{UNPUBLISHED}'] = $langMsg['Unpublished'];
$tplVars['{SPAM}'] = $langMsg['Spam'];
$tplVars['{COMMENT_CUANTITY}'] = $arrLines;
$tplVars['{COMMENT_ACTIONS}'] = ' - <a href="#" onclick="js_confirm_action(\''.$langMsg['Confirm_question'].'\', \'?action=PAll\')">'.$langMsg['Publish_all'].'</a> - <a href="#" onclick="js_confirm_action(\''.$langMsg['Confirm_question'].'\', \'?action=DAll\')">'.$langMsg['Delete_all'].'</a>';
$tplVars['{PAGE}'] = $langMsg['Page'];
$tplVars['{NUM_PAGE}'] = $pPaginator->getThisPage();
$tplVars['{OF}'] = $langMsg['Of'];
$tplVars['{TOTAL_PAGES}'] = $pPaginator->getTotalPages();
$tplVars['{PAGINATION}'] = $pPaginator->getPaginator();
$rowType = '';

if ($commentType == 1) {
	$tplVars['{COMMENT_TITLE}'] = $langMsg['Unpublished_comments'];
	$rowType = 3;
} elseif ($commentType == 2) {
	$tplVars['{COMMENT_TITLE}'] = $langMsg['Spam_comments'];
	$rowType = 4;
} else {
	$tplVars['{COMMENT_TITLE}'] = $langMsg['Published_comments'];
	$tplVars['{COMMENT_ACTIONS}'] = '';
	$rowType = 2;
}

if ($arrLines > 0) {
	$commenRowClass = '';
	$bFlag = true;
	$strComments = '<table class="commentTable">
				   <tr class="thClass'.$rowType.'"><th>'.$langMsg['Name'].'</th><th>'.$langMsg['Ip'].'</th><th>'.$langMsg['Added'].'</th><th>&nbsp;</th></tr>';
	for ($i = $pPaginator->getInitial(); $i < $arrLines && $i < $pPaginator->getLimit(); $i++) {
		$arrData = explode('|', $arrToShow[$i]);
		
		if ($bFlag == true) {
			$commenRowClass = 1;
			$bFlag = false;
		} else {
			$commenRowClass = $rowType;
			$bFlag = true;
		}
		
		if ($commentType == 0)
			$strAction = '<a href="edit_comment.php?id='.$arrData[0].'">'.$langMsg['Edit'].'</a>';
		elseif ($commentType == 1)
			$strAction = '<a href="?action=P&id='.$arrData[0].'">'.$langMsg['Publish'].'</a>';
		elseif ($commentType == 2)
			$strAction = '<a href="?action=P&id='.$arrData[0].'">'.$langMsg['Publish'].'</a>';
		
		
		$strComments .= '<tr class="commentRow'.$commenRowClass.'"><td>'.$arrData[4].'</td><td>'.$arrData[5].'</td><td>'.cf_getDate($arrData[3], $cf_dateFormat, $cf_timeZone).'</td>
						<td><span title="'.$arrData[1].'"><b>View Body</b></span> - '.$strAction.' - <a href="#" onclick="js_confirm_action(\''.$langMsg['Confirm_question'].'\', \'?action=D&id='.$arrData[0].'\')">'.$langMsg['Delete'].'</a></td></tr>';
	}
	$strComments .= '</table>';
	$tplVars['{COMMENT_TABLE_LIST}'] = $strComments;
}
else
	$tplVars['{COMMENT_TABLE_LIST}'] = '<p><strong>'.$langMsg['Empty_list'].'</strong></p>';

echo (new templateParser("../$tplPath/tpl/commentsBody.html", $tplVars));

if ($actionMade > 0) {
	// Server message
	$tplVars['{SERVER_MESSAGE_CLASS}'] = 'serverMessage';
	
	if ($actionMade == 1)
		$tplVars['{SERVER_MESSAGE}'] = '<p>'.$langMsg['Delete_comment_message'].'</p>';
	elseif ($actionMade == 2)
		$tplVars['{SERVER_MESSAGE}'] = '<p>'.$langMsg['Publish_comment_message'].'</p>';
	elseif ($actionMade == 3)
		$tplVars['{SERVER_MESSAGE}'] = '<p>'.$langMsg['Delete_all_comments_message'].'</p>';
	elseif ($actionMade == 4)
		$tplVars['{SERVER_MESSAGE}'] = '<p>'.$langMsg['Publish_all_comments_message'].'</p>';
		
	echo (new templateParser("../$tplPath/tpl/serverMessage.html", $tplVars));
}

// Showing admin footer
$mainTpl->showFooter();
//----------------
// End page output
//----------------
?>