<?php
//---------------------------------------------------------------------
//  -- Adriel Media --
//---------------------------------------------------------------------
// Admin page
// Product: Faisan Guestbook
// Written by: Adriel Ricardo Torres aka RicarDooM
// Website: http://adrielmedia.com
// Date:    02/12/2009
// Updated: 20/07/2010
//---------------------------------------------------------------------

//---------------------------------------------------------------------
// File name: admin.php
// File version: 1.0
//---------------------------------------------------------------------

//---------------------------------------------------------------------
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation.
//---------------------------------------------------------------------
session_start();

ini_set('arg_separator.output','&amp;');
define('IN_SCRIPT', true);

//define('DEBUG', true); // Uncomment this line only if you want debug the application
$debug = array();
$isLogged = 0;
$attempts = 0;
$action = '';
$i = 0;

// Loading configuration files
require_once('../appConfig.php');

if ($cf_isInstalled == 0)
	die("<b>[Warning]</b> $cf_appName $cf_appProduct $cf_appVersion isn't installed on server.");

// User logged out
if (isset($_GET['logout'])) {
	session_destroy();
	header("Location: index.php");
	die();
}

require_once('../'.$cf_dataPath.'/config.php');
require_once('../'.$cf_langPath.'/'.$cf_appLang.'.inc');

// Loading application source
require_once('../'.$cf_sourcePath.'/owner/hfoAdminClassAPP.php');

// Loading utilities source
require_once('../'.$cf_sourcePath.'/util/amCode.php');
require_once('../'.$cf_sourcePath.'/util/amPaginator.php');
require_once('../'.$cf_sourcePath.'/util/fileManager.php');
require_once('../'.$cf_sourcePath.'/util/replaceString.php');
require_once('../'.$cf_sourcePath.'/util/templateParser.php');
require_once('../'.$cf_sourcePath.'/util/commonF.php');
require_once('../'.$cf_sourcePath.'/util/antiSpamClass.php');
// Loading VO classes
require_once('../'.$cf_sourcePath.'/vo/commentsVO.php');
require_once('../'.$cf_sourcePath.'/vo/usersVO.php');
require_once('../'.$cf_sourcePath.'/vo/itemsVO.php');
require_once('../'.$cf_sourcePath.'/vo/smileysVO.php');

define('COMMENTS_FIELDS', 10);

if (isset($_POST['action']))
	$action = htmlentities($_POST['action'], ENT_QUOTES);
elseif (isset($_GET['action']))
	$action = htmlentities($_GET['action'], ENT_QUOTES);

// Checking is user is logged in
if (isset($_SESSION['sesIsLogged'])) {
	if (htmlentities($_SESSION['sesIsLogged'], ENT_QUOTES) == 1) {
		$fileUserLogin = new fileManager('../'.$cf_dataPath.'/users.php', 'r');
		
		for ($i = 0; $i < $fileUserLogin->getRows(); $i++) {
			$arrData = explode("|", $fileUserLogin->getDataRow($i));			
			if ($arrData[0] == htmlentities($_SESSION['sesUserId'], ENT_QUOTES) && $arrData[2] == htmlentities($_SESSION['sesUserPass'], ENT_QUOTES)) {
				$isLogged = 1;
				break;
			}
		}
		$fileUserLogin->closeFile();		
	}
}

// Initializing template variables
$tplVars = array();
$tplPath = $cf_adminPath;

// Loading main header/footer output template class
$pageName = $cf_appName.' '.$cf_appProduct.' - '.$langMsg['Admin_CP'];

$mainTpl = new hfoAdminClassAPP($tplPath, $cf_sourcePath, $langMsg, $pageName);
?>