﻿/*=============================================================================================

VEIL-RUS (c)
Version: 2.13.6.14

Author: VanDerSaAr

Enveil-rus converts base64 text to random russian text with simple sentences. Deveil-rus
converts this generated russian text to base64-text. Enveilized text hides base64 text.

See example: http://cryptbb.site40.net/rus/

~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

License: MIT

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.
 
-----------------------------------------------------------------------------------------------

Changelog:
2013-06-14: Publicated first version.

*///===========================================================================================
//=============================================================================================
//=============================================================================================

// enveil-rus.js
// Version: 2.13.6.14
// Author: VanDerSaAr
// License: MIT

function func_enveil_rus(text_unveil) {
  if (text_unveil.length == 0) { // if unveilized text is empty text
    return ""; // exit
  } // if (text_unveil.length == 0)

  var text_result = ""; // clear result text
  
//set symbol string base64+pad+space (standart/custom)
//var str_symbol = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=_";
  var str_symbol = "ABCDEFGH:JKLMN-PQRSTUVWXYZabcdefghijk;mnopqrstuvwxyz~!23456789.,=_";
  
//=============================================================================================

var arr_noun_name_male_nom = new Array( // word noun, type name, gender male, case nominative
"Алексей",
"Лёша",
"Анатолий",
"Толя",
"Андрей",//
"Антон",
"Тоша",
"Артём",
"Тёма",
"Борис",
"Боря",
"Вадим",//
"Владимир",
"Вова",
"Владислав",
"Влад",
"Василий",
"Вася",
"Виктор",//
"Виталий",
"Витя",
"Вячеслав",
"Слава",
"Геннадий",
"Гена",
"Глеб",//
"Даниил",
"Даня",
"Денис",//
"Дмитрий",
"Дима",
"Захар",//
"Игорь",//
"Иван",
"Ваня",
"Илья",//
"Константин",
"Костя",
"Кирилл",//
"Леонид",
"Лёня",
"Максим",
"Макс",
"Михаил",
"Миша",
"Николай",
"Коля",
"Олег",//
"Павел",
"Паша",
"Пётр",
"Петя",
"Роман",
"Рома",
"Тарас",//
"Фёдор",
"Федя",
"Семён",
"Сеня",
"Сергей",
"Серёга",
"Степан",
"Стёпа",
"Эдуард",//
"Юрий",
"Юра"
); // var arr_noun_name_male_nom = new Array

var arr_noun_name_fem_nom = new Array( // word noun, type name, gender female, case nominative
"Александра",
"Саша",
"Алиса",//
"Алла",//
"Анастасия",
"Настя",
"Анна",//
"Валерия",
"Валя",
"Вероника",
"Вера",
"Виктория",
"Вика",
"Галина",
"Галя",
"Дарья",
"Даша",
"Диана",
"Дина",
"Евгения",
"Женя",
"Екатерина",
"Катя",
"Елена",
"Лена",
"Елизавета",
"Лиза",
"Зинаида",
"Зина",
"Зоя",//
"Инна",//
"Ирина",
"Ира",
"Ксения",
"Ксюша",
"Лариса",
"Лара",
"Лидия",
"Лида",
"Луиза",//
"Любовь",
"Люба",
"Людмила",
"Люда",
"Маргарита",
"Рита",
"Мария",
"Маша",
"Милана",
"Мила",
"Марина",//
"Надежда",
"Надя",
"Наталия",
"Наташа",
"Оксана",//
"Ольга",
"Оля",
"Полина",//
"Роза",//
"Светлана",
"Света",
"Татьяна",
"Таня",
"Юлия",
"Юля"
); // var arr_noun_name_fem_nom = new Array

var arr_verb_past_sing_male = new Array( // word verb, tense past, number singular, gender male
"бросил",
"взял",
"вернул",
"вспомнил",
"выбросил",
"выкинул",
"вынял",
"вытащил",
"вытер",
"дал",
"достал",
"забыл",
"заклеил",
"закрепил",
"захотел",
"кинул",
"купил",
"накрыл",
"нашёл",
"опустил",
"оставил",
"отдал",
"отобрал",
"отпустил",
"очистил",
"передал",
"переложил",
"переместил",
"подарил",
"подбросил",
"подержал",
"подкинул",
"поднял",
"пожелал",
"поискал",
"покрасил",
"показал",
"покрутил",
"положил",
"получил",
"посмотрел на",
"потерял",
"потребовал",
"потрогал",
"потряс",
"предложил",
"прижал",
"приклеил",
"прикрепил",
"принёс",
"принял",
"приобрёл",
"продал",
"попросил",
"спрятал",
"нарисовал",
"сжал",
"скрыл",
"убрал",
"увидел",
"указал на",
"украл",
"унёс",
"уронил",
"утаил",
"швырнул"
); // var arr_verb_past_sing_male = new Array

var arr_verb_past_sing_fem = new Array( // word verb, tense past, number singular, gender female
"бросила",
"взяла",
"вернула",
"вспомнила",
"выбросила",
"выкинула",
"выняла",
"вытащила",
"вытерла",
"дала",
"достала",
"забыла",
"заклеила",
"закрепила",
"захотела",
"кинула",
"купила",
"накрыла",
"нашла",
"опустила",
"оставила",
"отдала",
"отобрала",
"отпустила",
"очистила",
"передала",
"переложила",
"переместила",
"подарила",
"подбросила",
"подержала",
"подкинула",
"подняла",
"пожелала",
"поискала",
"покрасила",
"показала",
"покрутила",
"положила",
"получила",
"посмотрела на",
"потеряла",
"потребовала",
"потрогала",
"потрясла",
"предложила",
"прижала",
"приклеила",
"прикрепила",
"принесла",
"приняла",
"приобрела",
"продала",
"попросила",
"спрятала",
"нарисовала",
"сжала",
"скрыла",
"убрала",
"увидела",
"указала на",
"украла",
"унесла",
"уронила",
"утаила",
"швырнула"
); // var arr_verb_past_sing_fem = new Array

var arr_verb_past_plur = new Array( // word verb, tense past, number plural
"бросили",
"взяли",
"вернули",
"вспомнили",
"выбросили",
"выкинули",
"выняли",
"вытащили",
"вытерли",
"дали",
"достали",
"забыли",
"заклеили",
"закрепили",
"захотели",
"кинули",
"купили",
"накрыли",
"нашли",
"опустили",
"оставили",
"отдали",
"отобрали",
"отпустили",
"очистили",
"передали",
"переложили",
"переместили",
"подарили",
"подбросили",
"подержали",
"подкинули",
"подняли",
"пожелали",
"поискали",
"покрасили",
"показали",
"покрутили",
"положили",
"получили",
"посмотрели на",
"потеряли",
"потребовали",
"потрогали",
"потрясли",
"предложили",
"прижали",
"приклеили",
"прикрепили",
"принесли",
"приняли",
"приобрели",
"продали",
"попросили",
"спрятали",
"нарисовали",
"сжали",
"скрыли",
"убрали",
"увидели",
"указали на",
"украли",
"унесли",
"уронили",
"утаили",
"швырнули"
); // var arr_verb_past_plur = new Array

var arr_ger = new Array( // word gerund
"бросая",
"беря",
"возвращая",
"вспоминая",
"выбрасывая",
"выкидывая",
"вынимая",
"вытаскивая",
"вытирая",
"давая",
"доставая",
"забывая",
"заклеивая",
"закрепляя",
"хотя",
"кидая",
"покупая",
"накрывая",
"находя",
"опуская",
"оставляя",
"отдавая",
"отбирая",
"отпуская",
"очищая",
"передавая",
"перекладывая",
"перемещая",
"даря",
"подбрасывая",
"держа",
"подкидывая",
"поднимая",
"желая",
"ища",
"крася",
"показывая",
"крутя",
"кладя",
"получая",
"смотря на",
"теряя",
"требуя",
"трогая",
"тряся",
"предлагая",
"прижимая",
"приклеивая",
"прикрепляя",
"принося",
"принимая",
"приобретая",
"продавая",
"прося",
"пряча",
"рисуя",
"сжимая",
"скрывая",
"убирая",
"видя",
"указывая на",
"крадя",
"унося",
"роняя",
"утаивая",
"швыряя"
); // var arr_ger = new Array

var arr_adv = new Array( // word adverb
"аккуратно",
"акцентированно",
"безбоязненно",
"беззаботно",
"беззлобно",
"безобидно",
"безответственно",
"безрадостно",
"безразлично",
"безрассудно",
"безуспешно",
"беспечно",
"беспокойно",
"бессмысленно",
"бодро",
"боязненно",
"быстро",
"вдохновенно",
"весело",
"внимательно",
"восхищённо",
"вынужденно",
"глупо",
"гордо",
"громко",
"грубо",
"грустно",
"доверчиво",
"добровольно",
"доброжелательно",
"добросовестно",
"довольно",
"измождённо",
"легко",
"лениво",
"ловко",
"мастерски",
"медленно",
"мечтательно",
"молниеносно",
"мрачно",
"недоверчиво",
"недовольно",
"незаметно",
"неприметно",
"необдуманно",
"неуверенно",
"неумышленно",
"обоснованно",
"предупредительно",
"предусмотрительно",
"принуждённо",
"радостно",
"разочарованно",
"рассеянно",
"скромно",
"случайно",
"спокойно",
"старательно",
"тихо",
"тщетно",
"тяжело",
"уверенно",
"увлечённо",
"устало",
"эмоционально"
); // var arr_adv = new Array

var arr_noun_obj_acc = new Array( // word noun, type object, case accusative
"апельсин",
"банку",
"батарейку",
"билет",
"брелок",
"бутылку",
"вилку",
"газету",
"грушу",
"диск",
"документы",
"жвачку",
"журнал",
"зажигалку",
"зеркало",
"игрушку",
"карандаш",
"картину",
"кисточку",
"ключ",
"камеру",
"компас",
"конверт",
"коробку",
"книгу",
"кружку",
"куртку",
"ластик",
"лампу",
"линейку",
"ложку",
"маркер",
"монетку",
"ножницы",
"открывашку",
"пакет",
"печенье",
"письмо",
"платок",
"плеер",
"полотенце",
"пуговицу",
"расчёску",
"ручку",
"сигарету",
"скотч",
"скрепку",
"спички",
"стакан",
"степлер",
"сумку",
"таблетку",
"тарелку",
"телефон",
"тетрадь",
"тюбик",
"учебник",
"фломастер",
"фотоаппарат",
"фотографию",
"фонарик",
"часы",
"чашку",
"шапку",
"щётку",
"яблоко"
); // var arr_noun_obj_acc = new Array

var arr_noun_name_male_gen = new Array( // word noun, type name, gender male, case genitive
"Алексея",
"Лёши",
"Анатолия",
"Толи",
"Андрея",//
"Антона",
"Тоши",
"Артёма",
"Тёмы",
"Бориса",
"Бори",
"Вадима",//
"Владимира",
"Вовы",
"Владислава",
"Влада",
"Василия",
"Васи",
"Виктора",//
"Виталия",
"Вити",
"Вячеслава",
"Славы",
"Геннадия",
"Гены",
"Глеба",//
"Даниила",
"Дани",
"Дениса",//
"Дмитрия",
"Димы",
"Захара",//
"Игоря",//
"Ивана",
"Вани",
"Ильи",//
"Константина",
"Кости",
"Кирилла",//
"Леонида",
"Лёни",
"Максима",
"Макса",
"Михаила",
"Миши",
"Николая",
"Коли",
"Олега",//
"Павла",
"Паши",
"Петра",
"Пети",
"Романа",
"Ромы",
"Тараса",//
"Фёдора",
"Феди",
"Семёна",
"Сени",
"Сергея",
"Серёги",
"Степана",
"Стёпы",
"Эдуарда",//
"Юрия",
"Юры"
); // var arr_noun_name_male_gen = new Array

var arr_noun_name_fem_gen = new Array( // word noun, type name, gender female, case genitive
"Александры",
"Саши",
"Алисы",//
"Аллы",//
"Анастасии",
"Насти",
"Анны",//
"Валерии",
"Вали",
"Вероники",
"Веры",
"Виктории",
"Вики",
"Галины",
"Гали",
"Дарьи",
"Даши",
"Дианы",
"Дины",
"Евгении",
"Жени",
"Екатерины",
"Кати",
"Елены",
"Лены",
"Елизаветы",
"Лизы",
"Зинаиды",
"Зины",
"Зои",//
"Инны",//
"Ирины",
"Иры",
"Ксении",
"Ксюши",
"Ларисы",
"Лары",
"Лидии",
"Лиды",
"Луизы",//
"Любови",
"Любы",
"Людмилы",
"Люды",
"Маргариты",
"Риты",
"Марии",
"Маши",
"Миланы",
"Милы",
"Марины",//
"Надежды",
"Нади",
"Наталии",
"Наташи",
"Оксаны",//
"Ольги",
"Оли",
"Полины",//
"Розы",//
"Светланы",
"Светы",
"Татьяны",
"Тани",
"Юлии",
"Юли"
); // var arr_noun_name_fem_gen = new Array

//=============================================================================================

var snt_len_max = 8; // set max count of core words in sentence
var parag_word_count_min = 30; // set max word count for split text to paragraphs
	
//---------------------------------------------------------------------------------------------

var arr_snt_len_1 = new Array( // structure of sentence with 1 core word

"AndOr M-name M-wasThere .",
"AndOr F-name F-wasThere ."

); // var arr_snt_len_1 = new Array

//---------------------------------------------------------------------------------------------

var arr_snt_len_2 = new Array( // structure of sentence with 2 core words
	
"AndOr M-name notOr vpsm !",
"AndOr F-name notOr vpsf !"

); // var arr_snt_len_2 = new Array

//---------------------------------------------------------------------------------------------

var arr_snt_len_3 = new Array( // structure of sentence with 3 core words

"LaterOr M-name vpsm noun .",
"LaterOr F-name vpsf noun .",
"AndOr M-name notOr vpsm noun .",
"AndOr F-name notOr vpsf noun ."

); // var arr_snt_len_3 = new Array

//---------------------------------------------------------------------------------------------

var arr_snt_len_4 = new Array( // structure of sentence with 4 core words

"LaterOr M-name M-said \" F-name notOr vpsf noun ! \"",
"LaterOr F-name F-said \" M-name notOr vpsm noun ! \"",
"AndOr M-name M-said \" F-name notOr vpsf noun ! \"",
"AndOr F-name F-said \" M-name notOr vpsm noun ! \"",

"LaterOr M-name vpsm noun of-F-name .",
"LaterOr F-name vpsf noun of-M-name .",
"AndOr M-name notOr vpsm noun of-F-name .",
"AndOr F-name notOr vpsf noun of-M-name .",

"LaterOr M-name adv vpsm noun .",
"LaterOr F-name adv vpsf noun .",
"AndOr M-name notOr vpsm noun adv .",
"AndOr F-name notOr vpsf noun adv .",

"LaterOr M-name and F-name vpp noun .",
"LaterOr F-name and M-name vpp noun .",
"AndOr M-name and F-name notOr vpp noun .",
"AndOr F-name and M-name notOr vpp noun ."

); // var arr_snt_len_4 = new Array

//---------------------------------------------------------------------------------------------

var arr_snt_len_5 = new Array( // structure of sentence with 5 core words

"LaterOr M-name , ger noun , vpsm noun .",
"LaterOr F-name , ger noun , vpsf noun .",
"AndOr M-name , ger noun , vpsm noun .",
"AndOr F-name , ger noun , vpsf noun .",

"LaterOr M-name M-said \" F-name notOr vpsf noun of-M-name ! \"",
"LaterOr F-name F-said \" M-name notOr vpsm noun of-F-name ! \"",
"AndOr M-name M-said \" F-name notOr vpsf noun of-M-name ! \"",
"AndOr F-name F-said \" M-name notOr vpsm noun of-F-name ! \"",

"LaterOr M-name adv vpsm noun of-F-name .",
"LaterOr F-name adv vpsf noun of-M-name .",
"AndOr M-name notOr vpsm noun of-F-name adv .",
"AndOr F-name notOr vpsf noun of-M-name adv .",

"LaterOr M-name adv M-said \" F-name notOr vpsf noun ! \"",
"LaterOr F-name adv F-said \" M-name notOr vpsm noun ! \"",
"AndOr M-name adv M-said \" F-name notOr vpsf noun ! \"",
"AndOr F-name adv F-said \" M-name notOr vpsm noun ! \"",

"LaterOr M-name and F-name adv vpp noun .",
"LaterOr F-name and M-name adv vpp noun .",
"AndOr M-name and F-name notOr vpp noun adv .",
"AndOr F-name and M-name notOr vpp noun adv ."

); // var arr_snt_len_5 = new Array

//---------------------------------------------------------------------------------------------

var arr_snt_len_6 = new Array( // structure of sentence with 6 core words

"LaterOr M-name , ger noun , vpsm noun of-F-name .",
"LaterOr F-name , ger noun , vpsf noun of-M-name .",
"LaterOr M-name , ger noun of-F-name , vpsm noun .",
"LaterOr F-name , ger noun of-M-name , vpsf noun .",
"AndOr M-name , ger noun , vpsm noun of-F-name .",
"AndOr F-name , ger noun , vpsf noun of-M-name .",
"AndOr M-name , ger noun of-F-name , vpsm noun .",
"AndOr F-name , ger noun of-M-name , vpsf noun .",

"AndOr M-name vpsm noun , causeOr F-name notOr vpsf noun .",
"AndOr F-name vpsf noun , causeOr M-name notOr vpsm noun .",

"LaterOr M-name , ger noun , M-said \" F-name notOr vpsf noun ! \"",
"LaterOr F-name , ger noun , F-said \" M-name notOr vpsm noun ! \"",
"AndOr M-name , ger noun , M-said \" F-name notOr vpsf noun ! \"",
"AndOr F-name , ger noun , F-said \" M-name notOr vpsm noun ! \"",

"LaterOr M-name and F-name , ger noun , vpp noun .",
"LaterOr F-name and M-name , ger noun , vpp noun .",
"AndOr M-name and F-name , ger noun , notOr vpp noun .",
"AndOr F-name and M-name , ger noun , notOr vpp noun .",

"LaterOr M-name , adv ger noun , vpsm noun .",
"LaterOr F-name , adv ger noun , vpsf noun .",
"AndOr M-name , adv ger noun , notOr vpsm noun .",
"AndOr F-name , adv ger noun , notOr vpsf noun .",

"LaterOr M-name adv M-said \" F-name notOr vpsf noun of-M-name ! \"",
"LaterOr F-name adv F-said \" M-name notOr vpsm noun of-F-name ! \"",
"AndOr M-name adv M-said \" F-name notOr vpsf noun of-M-name ! \"",
"AndOr F-name adv F-said \" M-name notOr vpsm noun of-F-name ! \""

); // var arr_snt_len_6 = new Array

//---------------------------------------------------------------------------------------------

var arr_snt_len_7 = new Array( // structure of sentence with 7 core words

"LaterOr M-name , ger noun of-F-name , vpsm noun of-F-name .",
"LaterOr F-name , ger noun of-M-name , vpsf noun of-M-name .",
"AndOr M-name , ger noun of-F-name , notOr vpsm noun of-F-name .",
"AndOr F-name , ger noun of-M-name , notOr vpsf noun of-M-name .",

"AndOr M-name notOr vpsm noun , causeOr F-name notOr vpsf noun adv .",
"AndOr F-name notOr vpsf noun , causeOr M-name notOr vpsm noun adv .",
"AndOr M-name notOr vpsm noun adv , causeOr F-name notOr vpsf noun .",
"AndOr F-name notOr vpsf noun adv , causeOr M-name notOr vpsm noun .",

"AndOr M-name vpsm noun , causeOr F-name notOr vpsf noun of-M-name .",
"AndOr F-name vpsf noun , causeOr M-name notOr vpsm noun of-F-name .",
"AndOr M-name vpsm noun of-F-name , causeOr F-name notOr vpsf noun .",
"AndOr F-name vpsf noun of-M-name , causeOr M-name notOr vpsm noun .",

"AndOr M-name and F-name vpp noun , causeOr M-name vpsm noun .",
"AndOr F-name and M-name vpp noun , causeOr F-name vpsf noun .",

"LaterOr M-name , ger noun , M-said \" F-name notOr vpsf noun of-M-name ! \"",
"LaterOr F-name , ger noun , F-said \" M-name notOr vpsm noun of-F-name ! \"",
"AndOr M-name , ger noun , M-said \" F-name notOr vpsf noun of-M-name ! \"",
"AndOr F-name , ger noun , F-said \" M-name notOr vpsm noun of-F-name ! \"",
"LaterOr M-name , ger noun of-F-name , M-said \" F-name notOr vpsf noun ! \"",
"LaterOr F-name , ger noun of-M-name , F-said \" M-name notOr vpsm noun ! \"",
"AndOr M-name , ger noun of-F-name , M-said \" F-name notOr vpsf noun ! \"",
"AndOr F-name , ger noun of-M-name , F-said \" M-name notOr vpsm noun ! \"",

"LaterOr M-name , ger noun of-F-name , M-said \" F-name notOr vpsf noun ! \"",
"LaterOr F-name , ger noun of-M-name , F-said \" M-name notOr vpsm noun ! \"",
"AndOr M-name , ger noun of-F-name , M-said \" F-name notOr vpsf noun ! \"",
"AndOr F-name , ger noun of-M-name , F-said \" M-name notOr vpsm noun ! \"",

"LaterOr M-name , ger noun of-F-name , vpsm noun of-F-name .",
"LaterOr F-name , ger noun of-M-name , vpsf noun of-M-name .",
"AndOr M-name , ger noun of-F-name , notOr vpsm noun of-F-name .",
"AndOr F-name , ger noun of-M-name , notOr vpsf noun of-M-name .",

"LaterOr M-name and F-name , ger noun , vpp noun of-M-name .",
"LaterOr F-name and M-name , ger noun , vpp noun of-F-name .",
"AndOr M-name and F-name , ger noun , notOr vpp noun of-F-name .",
"AndOr F-name and M-name , ger noun , notOr vpp noun of-M-name .",
"LaterOr M-name and F-name , ger noun of-M-name , vpp noun .",
"LaterOr F-name and M-name , ger noun of-F-name , vpp noun .",
"AndOr M-name and F-name , ger noun of-M-name , notOr vpp noun .",
"AndOr F-name and M-name , ger noun of-F-name , notOr vpp noun .",

"LaterOr M-name , adv ger noun , vpsm noun of-F-name .",
"LaterOr F-name , adv ger noun , vpsf noun of-M-name .",
"AndOr M-name , adv ger noun , notOr vpsm noun of-F-name .",
"AndOr F-name , adv ger noun , notOr vpsf noun of-M-name .",
"LaterOr M-name , adv ger noun of-F-name , vpsm noun .",
"LaterOr F-name , adv ger noun of-M-name , vpsf noun .",
"AndOr M-name , adv ger noun of-F-name , notOr vpsm noun .",
"AndOr F-name , adv ger noun of-M-name , notOr vpsf noun ."

); // var arr_snt_len_7 = new Array

//---------------------------------------------------------------------------------------------

var arr_snt_len_8 = new Array( // structure of sentence with 8 core words

"AndOr M-name notOr vpsm noun of-F-name , causeOr F-name notOr vpsf noun of-M-name .",
"AndOr F-name notOr vpsf noun of-M-name , causeOr M-name notOr vpsm noun of-F-name .",

"AndOr M-name notOr vpsm noun , causeOr F-name notOr vpsf noun of-M-name adv .",
"AndOr F-name notOr vpsf noun , causeOr M-name notOr vpsm noun of-F-name adv .",
"AndOr M-name notOr vpsm noun of-M-name , causeOr F-name notOr vpsf noun adv .",
"AndOr F-name notOr vpsf noun of-M-name , causeOr M-name notOr vpsm noun adv .",

"AndOr M-name notOr vpsm noun adv , causeOr F-name notOr vpsf noun of-M-name .",
"AndOr F-name notOr vpsf noun adv , causeOr M-name notOr vpsm noun of-F-name .",
"AndOr M-name notOr vpsm noun of-M-name adv , causeOr F-name notOr vpsf noun .",
"AndOr F-name notOr vpsf noun of-M-name adv , causeOr M-name notOr vpsm noun .",

"AndOr M-name and F-name notOr vpp noun , causeOr M-name notOr vpsm noun of-F-name .",
"AndOr F-name and M-name notOr vpp noun , causeOr F-name notOr vpsf noun of-M-name .",
"AndOr M-name and F-name notOr vpp noun of-M-name , causeOr M-name notOr vpsm noun .",
"AndOr F-name and M-name notOr vpp noun of-F-name , causeOr F-name notOr vpsf noun .",

"AndOr M-name and F-name notOr vpp noun adv , causeOr M-name notOr vpsm noun .",
"AndOr F-name and M-name notOr vpp noun adv , causeOr F-name notOr vpsf noun .",
"AndOr M-name and F-name notOr vpp noun , causeOr M-name notOr vpsm noun adv .",
"AndOr F-name and M-name notOr vpp noun , causeOr F-name notOr vpsf noun adv .",

"LaterOr M-name , ger noun of-F-name , M-said \" F-name notOr vpsf noun of-M-name ! \"",
"LaterOr F-name , ger noun of-M-name , F-said \" M-name notOr vpsm noun of-F-name ! \"",
"AndOr M-name , ger noun of-F-name , M-said \" F-name notOr vpsf noun of-M-name ! \"",
"AndOr F-name , ger noun of-M-name , F-said \" M-name notOr vpsm noun of-F-name ! \"",

"LaterOr M-name , adv ger noun of-F-name , vpsm noun of-F-name .",
"LaterOr F-name , adv ger noun of-M-name , vpsf noun of-M-name .",
"AndOr M-name , adv ger noun of-F-name , notOr vpsm noun of-F-name .",
"AndOr F-name , adv ger noun of-M-name , notOr vpsf noun of-M-name .",
"LaterOr M-name , adv ger noun of-F-name , adv vpsm noun .",
"LaterOr F-name , adv ger noun of-M-name , adv vpsf noun .",
"AndOr M-name , adv ger noun of-F-name , notOr vpsm noun adv .",
"AndOr F-name , adv ger noun of-M-name , notOr vpsf noun adv .",

"LaterOr M-name and F-name , ger noun of-M-name , vpp noun of-M-name .",
"LaterOr F-name and M-name , ger noun of-F-name , vpp noun of-F-name .",
"AndOr M-name and F-name , ger noun of-M-name , notOr vpp noun of-M-name .",
"AndOr F-name and M-name , ger noun of-F-name , notOr vpp noun of-F-name .",

"LaterOr M-name and F-name , adv ger noun of-M-name , vpp noun .",
"LaterOr F-name and M-name , adv ger noun of-F-name , vpp noun .",
"AndOr M-name and F-name , adv ger noun of-M-name , notOr vpp noun .",
"AndOr F-name and M-name , adv ger noun of-F-name , notOr vpp noun .",
"LaterOr M-name and F-name , ger noun of-M-name , adv vpp noun .",
"LaterOr F-name and M-name , ger noun of-F-name , adv vpp noun .",
"AndOr M-name and F-name , ger noun of-M-name , notOr vpp noun adv .",
"AndOr F-name and M-name , ger noun of-F-name , notOr vpp noun adv .",

"LaterOr M-name , adv ger noun of-F-name , vpsm noun of-F-name .",
"LaterOr F-name , adv ger noun of-M-name , vpsf noun of-M-name .",
"AndOr M-name , adv ger noun of-F-name , notOr vpsm noun of-F-name .",
"AndOr F-name , adv ger noun of-M-name , notOr vpsf noun of-M-name .",

"LaterOr M-name , adv ger noun , adv vpsm noun of-F-name .",
"LaterOr F-name , adv ger noun , adv vpsf noun of-M-name .",
"AndOr M-name , adv ger noun , notOr vpsm noun of-F-name adv .",
"AndOr F-name , adv ger noun , notOr vpsf noun of-M-name adv ."

); // var arr_snt_len_8 = new Array

//=============================================================================================

var len_symbol = str_symbol.length; // get symbol string's char count
var arr_symbol = new Array(); // assign symbol string array
var arr_symbol = str_symbol.split(""); // load chars to symbol string array

var len_unveil = text_unveil.length; // get unveilized text's char count
var arr_unveil = new Array(); // assign unveilized text array
var arr_unveil = text_unveil.split(""); // load chars to unveilized text array

//---------------------------------------------------------------------------------------------

var veil_snt = "Begin"; // add begin to sentence text
var i = 0; // reset char index

while (i < len_unveil) { // cycle unveilized text's chars
  
  var snt_len_cur = Math.floor(Math.random() * (snt_len_max - 2))
    + 3; // randomize core word count of current sentence
  if ((i + snt_len_cur)
    > len_unveil) { // if core word count exceed further unveilized text's core word count
    var snt_len_cur = len_unveil - i; // set word count of current sentence
  } // if ((i + snt_len_cur) > len_unveil)

//---------------------------------------------------------------------------------------------
 
  if (snt_len_cur == 1) { // if word count of current sentence equal this value
    var m = Math.floor(Math.random() * arr_snt_len_1.length); // randomize type of sentence
    var veil_snt = veil_snt + " " + arr_snt_len_1[m]; // set sentence text to temp string
  } // if (snt_len_cur == 1)

  if (snt_len_cur == 2) { // if word count of current sentence equal this value
    var m = Math.floor(Math.random() * arr_snt_len_2.length); // randomize type of sentence
    var veil_snt = veil_snt + " " + arr_snt_len_2[m]; // set sentence text to temp string
  } // if (snt_len_cur == 2)

  if (snt_len_cur == 3) { // if word count of current sentence equal this value
    var m = Math.floor(Math.random() * arr_snt_len_3.length); // randomize type of sentence
    var veil_snt = veil_snt + " " + arr_snt_len_3[m]; // set sentence text to temp string
  } // if (snt_len_cur == 3)

  if (snt_len_cur == 4) { // if word count of current sentence equal this value
    var m = Math.floor(Math.random() * arr_snt_len_4.length); // randomize type of sentence
    var veil_snt = veil_snt + " " + arr_snt_len_4[m]; // set sentence text to temp string
  } // if (snt_len_cur == 4)

  if (snt_len_cur == 5) { // if word count of current sentence equal this value
    var m = Math.floor(Math.random() * arr_snt_len_5.length); // randomize type of sentence
    var veil_snt = veil_snt + " " + arr_snt_len_5[m]; // set sentence text to temp string
  } // if (snt_len_cur == 5)

  if (snt_len_cur == 6) { // if word count of current sentence equal this value
    var m = Math.floor(Math.random() * arr_snt_len_6.length); // randomize type of sentence
    var veil_snt = veil_snt + " " + arr_snt_len_6[m]; // set sentence text to temp string
  } // if (snt_len_cur == 6)

  if (snt_len_cur == 7) { // if word count of current sentence equal this value
    var m = Math.floor(Math.random() * arr_snt_len_7.length); // randomize type of sentence
    var veil_snt = veil_snt + " " + arr_snt_len_7[m]; // set sentence text to temp string
  } // if (snt_len_cur == 7)
  
  if (snt_len_cur == 8) { // if word count of current sentence equal this value
    var m = Math.floor(Math.random() * arr_snt_len_8.length); // randomize type of sentence
    var veil_snt = veil_snt + " " + arr_snt_len_8[m]; // set sentence text to temp string
  } // if (snt_len_cur == 8)

//---------------------------------------------------------------------------------------------
  
  var i = i + snt_len_cur; // increase cycle index with core word count of current sentence
} // while (i < len_unveil)

var veil_snt = veil_snt + " End"; // add end to sentence text

//=============================================================================================

var arr_enveil = new Array(); // assign sentence word array
var arr_enveil = veil_snt.split(" "); // load words from sentence text to sentence word array

var veil_str = ""; // clear enveilized text

var m = 0; // clear veiltext word number
var q = 0; // clear sentence word number

for (i = 0; i < arr_enveil.length; ++i) { // cycle sentence words of sentence text from 2nd
  if (arr_enveil[i] == ".") { // if current sentence word equal dot
    var veil_str = veil_str + arr_enveil[i]; // add this word to enveilized text
	
    if (q > parag_word_count_min) { // if sentence word number more min paragraph word count
      if (Math.floor(Math.random() * 2) == 1) { // if random 50/50
	    var veil_str = veil_str + "\n"; // add breakline to enveilized text
  	    var q = 0; // reset sentence word number
	  } // if (Math.floor(Math.random() * 2) == 1)
    } // if (q > parag_word_count_min)
	
	continue; // go to next sentence word of sentence text in cycle
  } // if (arr_enveil[i] == ".")
  
  if (arr_enveil[i] == ",") { // if current sentence word equal comma
    var veil_str = veil_str + arr_enveil[i]; // add this word to enveilized text
	continue; // go to next sentence word of sentence text in cycle
  } // if (arr_enveil[i] == ",")
  if (arr_enveil[i] == "!") { // if current sentence word equal exclamation mark
    var veil_str = veil_str + arr_enveil[i]; // add this word to enveilized text
	continue; // go to next sentence word of sentence text in cycle
  } // if (arr_enveil[i] == "!")
  if (arr_enveil[i] == "\"") { // if current sentence word equal quote
    var veil_str = veil_str + arr_enveil[i]; // add this word to enveilized text
	continue; // go to next sentence word of sentence text in cycle
  } // if (arr_enveil[i] == "\"")

  if (arr_enveil[i] == "Begin") { // if current sentence word equal begin
    var n = Math.floor(Math.random() * 8); // randomize type of phrase
	if (n == 0) { veil_str = veil_str + " " + "Потом было так."; }
	if (n == 1) { veil_str = veil_str + " " + "Далее было интереснее."; }
	if (n >= 2) {}
	continue; // go to next sentence word of sentence text in cycle
  } // if (arr_enveil[i] == "Begin")
  if (arr_enveil[i] == "End") { // if current sentence word equal end
    var n = Math.floor(Math.random() * 8); // randomize type of phrase
	if (n == 0) { veil_str = veil_str + " " + "Вот было так."; }
	if (n == 1) { veil_str = veil_str + " " + "Это было так."; }
	if (n >= 2) {}
	continue; // go to next sentence word of sentence text in cycle
  } // if (arr_enveil[i] == "End")
  
  if (arr_enveil[i] == "and") { // if current sentence word equal this word
    var veil_str = veil_str + " " + "и";
	continue; // go to next sentence word of sentence text in cycle
  } // if (arr_enveil[i] == "and")
  if (arr_enveil[i] == "AndOr") { // if current sentence word equal this word
    var n = Math.floor(Math.random() * 8); // randomize type of phrase
	if (n == 0) { veil_str = veil_str + " " + "А"; }
	if (n == 1) { veil_str = veil_str + " " + "Но"; }
	if (n == 2) { veil_str = veil_str + " " + "И тогда"; }
	if (n == 3) { veil_str = veil_str + " " + "Кстати,"; }
	if (n == 4) { veil_str = veil_str + " " + "Разумеется,"; }
	if (n >= 5) {}
	continue; // go to next sentence word of sentence text in cycle
  } // if (arr_enveil[i] == "AndOr")
  if (arr_enveil[i] == "LaterOr") { // if current sentence word equal this word
    var n = Math.floor(Math.random() * 8); // randomize type of phrase
	if (n == 0) { veil_str = veil_str + " " + "Затем"; }
	if (n == 1) { veil_str = veil_str + " " + "Позднее"; }
	if (n == 2) { veil_str = veil_str + " " + "Далее"; }
	if (n == 3) { veil_str = veil_str + " " + "После этого"; }
	if (n == 4) { veil_str = veil_str + " " + "Неожиданно"; }
	if (n == 5) { veil_str = veil_str + " " + "Внезапно"; }
	if (n >= 6) {}
	continue; // go to next sentence word of sentence text in cycle
  } // if (arr_enveil[i] == "LaterOr")
  if (arr_enveil[i] == "causeOr") { // if current sentence word equal this word
    var n = Math.floor(Math.random() * 4); // randomize type of phrase
	if (n == 0) { veil_str = veil_str + " " + "поэтому"; }
	if (n == 1) { veil_str = veil_str + " " + "потому"; }
	if (n >= 2) { veil_str = veil_str + " " + "потому что"; }
	continue; // go to next sentence word of sentence text in cycle
  } // if (arr_enveil[i] == "causeOr")
  
  if (arr_enveil[i] == "M-said") { // if current sentence word equal this word
    var n = Math.floor(Math.random() * 2); // randomize type of phrase
	if (n == 0) { veil_str = veil_str + " " + "сказал:"; }
	if (n == 1) { veil_str = veil_str + " " + "крикнул:"; }
	continue; // go to next sentence word of sentence text in cycle
  } // if (arr_enveil[i] == "M-said")
  if (arr_enveil[i] == "F-said") { // if current sentence word equal this word
    var n = Math.floor(Math.random() * 2); // randomize type of phrase
	if (n == 0) { veil_str = veil_str + " " + "сказала:"; }
	if (n == 1) { veil_str = veil_str + " " + "крикнула:"; }
	continue; // go to next sentence word of sentence text in cycle
  } // if (arr_enveil[i] == "F-said")
  if (arr_enveil[i] == "notOr") { // if current sentence word equal this word
    var n = Math.floor(Math.random() * 2); // randomize type of phrase
	if (n == 0) { veil_str = veil_str + " " + "не"; }
	if (n == 1) {}
	continue; // go to next sentence word of sentence text in cycle
  } // if (arr_enveil[i] == "notOr")

  if (arr_enveil[i] == "M-wasThere") { // if current sentence word equal this word
    var n = Math.floor(Math.random() * 2); // randomize type of phrase
	if (n == 0) { veil_str = veil_str + " " + "был там"; }
	if (n == 1) { veil_str = veil_str + " " + "это видел"; }
	continue; // go to next sentence word of sentence text in cycle
  } // if (arr_enveil[i] == "M-wasThere")
  if (arr_enveil[i] == "F-wasThere") { // if current sentence word equal this word
    var n = Math.floor(Math.random() * 2); // randomize type of phrase
	if (n == 0) { veil_str = veil_str + " " + "была там"; }
	if (n == 1) { veil_str = veil_str + " " + "это видела"; }
	continue; // go to next sentence word of sentence text in cycle
  } // if (arr_enveil[i] == "F-wasThere")
  
//---------------------------------------------------------------------------------------------
  
  var s = arr_unveil[m]; // set current char of unveilized text array to temp string  
  var k = -1; // reset current char's number in base64 text
  
  for (j = 0; j < len_symbol; ++j) { // cycle chars of base64 text
    if (s == arr_symbol[j]) { // if temp string equal char of base64 text
 	  var k = j; // set current char's number
	  break; // exit from cycle
    } // if (s == arr_symbol[j])
  } // for (j = 0; j < len_symbol; ++j)
  
  if (k == -1) { // if current char's number was not founded in base64 text
	return ""; // exit
  } // if (k == -1)
  
  // change sentence words to real words
  if (arr_enveil[i] == "M-name") {
    var veil_str = veil_str + " " + arr_noun_name_male_nom[k];
  } // if (arr_enveil[i] == "M-name")
  if (arr_enveil[i] == "F-name") {
    var veil_str = veil_str + " " + arr_noun_name_fem_nom[k];
  } // if (arr_enveil[i] == "F-name")
  if (arr_enveil[i] == "adv") {
    var veil_str = veil_str + " " + arr_adv[k];
  } // if (arr_enveil[i] == "adv")
  if (arr_enveil[i] == "ger") {
    var veil_str = veil_str + " " + arr_ger[k];
  } // if (arr_enveil[i] == "ger")
  if (arr_enveil[i] == "vpsm") {
    var veil_str = veil_str + " " + arr_verb_past_sing_male[k];
  } // if (arr_enveil[i] == "vpsm")
  if (arr_enveil[i] == "vpsf") {
    var veil_str = veil_str + " " + arr_verb_past_sing_fem[k];
  } // if (arr_enveil[i] == "vpsf")
  if (arr_enveil[i] == "vpp") {
    var veil_str = veil_str + " " + arr_verb_past_plur[k];
  } // if (arr_enveil[i] == "vpp")
  if (arr_enveil[i] == "noun") {
    var veil_str = veil_str + " " + arr_noun_obj_acc[k];
  } // if (arr_enveil[i] == "noun")
  if (arr_enveil[i] == "of-M-name") {
    var veil_str = veil_str + " " + arr_noun_name_male_gen[k];
  } // if (arr_enveil[i] == "of-M-name")
  if (arr_enveil[i] == "of-F-name") {
    var veil_str = veil_str + " " + arr_noun_name_fem_gen[k];
  } // if (arr_enveil[i] == "of-F-name")
  
  var m = m + 1; // increase veiltext word number
  var q = q + 1; // increase sentence word number
} // for (i = 0; i < arr_enveil.length; ++i)

//=============================================================================================

  // correct enveilized text
  var a = new Array(); // assign temp array
  var a = veil_str.split(""); // load chars of enveilized text to temp array

  // shift quotes to right near colons
  for (i = 1; i < a.length; ++i) { // cycle chars of enveilized text
    if (a[i] == "\"") { // if current char is quote
      if (a[i - 1] == ":") { // if previous char is colon
	    a[i] = " "; // set space to current char
		a[i + 1] = "\""; // set quote to next char
		var i = i + 2; // increase index of array with 2
	  } // if (a[i - 1] == ":")
	} // if (a[i] == "\"")
  } // for (i = 1; i < a.length; ++i)
  
  // remove spaces in begining of paragraphs
  for (i = 0; i < a.length; ++i) { // cycle chars of edited enveilized text
    if (a[i] == "\n") { // if current char is breakline
      if (a[i + 1] == " ") { // if next char is space
		a[i + 1] = ""; // clear next char
		var i = i + 2; // increase index of array with 2
	  } // if (a[i + 1] == " ")
	} // if (a[i] == "\n")
  } // for (i = 0; i < a.length; ++i)

//---------------------------------------------------------------------------------------------
  
  // rebuild enveilized text
  var veil_str = ""; // clear enveilized text
  for (i = 1; i < a.length; ++i) { // cycle chars of edited enveilized text
    var veil_str = veil_str + a[i]; // add char to enveilized text if not clear
  } // for (i = 1; i < a.length; ++i)
  
//=============================================================================================

  var text_result = text_result + veil_str; // add enveilized text to result text
  return text_result; // print result text
} // function func_enveil_rus(text_unveil, str_symbol)

//=============================================================================================
//=============================================================================================
//=============================================================================================

// deveil-rus.js
// Version: 2.13.6.14
// Author: VanDerSaAr
// License: MIT

function func_deveil_rus(text_enveil) {
  if (text_enveil.length == 0) { // if enveilized text is empty text
    return ""; // exit
  } // if (text_enveil.length == 0)

  var text_result = ""; // clear result text
  
//set symbol string base64+pad+space (standart/custom)
//var str_symbol = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=_";
  var str_symbol = "ABCDEFGH:JKLMN-PQRSTUVWXYZabcdefghijk;mnopqrstuvwxyz~!23456789.,=_";

  var arr_symbol = new Array(); // assign symbol string array
  var arr_symbol = str_symbol.split(""); // load chars to symbol string array

//=============================================================================================

var arr_word_17 = new Array(
"предусмотрительно");
var arr_word_16 = new Array(
"предупредительно");
var arr_word_15 = new Array(
"безответственно", "доброжелательно");
var arr_word_14 = new Array(
"акцентированно");
var arr_word_13 = new Array(
"добросовестно", "разочарованно");
var arr_word_12 = new Array(
"безбоязненно", "бессмысленно", "перекладывая", "эмоционально");
var arr_word_11 = new Array(
"Константина", "безрадостно", "безразлично", "безрассудно", "вдохновенно", "внимательно", "добровольно", "мечтательно", "молниеносно", "недоверчиво", "необдуманно", "неумышленно", "обоснованно", "переместила", "переместили", "подбрасывая", "потребовала", "потребовали", "принуждённо", "старательно", "фотоаппарат");
var arr_word_10 = new Array(
"Александра", "Александры", "Владислава", "Константин", "беззаботно", "безуспешно", "беспокойно", "восхищённо", "выбрасывая", "вынужденно", "вытаскивая", "измождённо", "нарисовала", "нарисовали", "недовольно", "неприметно", "неуверенно", "открывашку", "переложила", "переложили", "переместил", "подбросила", "подбросили", "подкидывая", "посмотрела", "посмотрели", "потребовал", "предложила", "предложили", "приклеивая", "прикрепила", "прикрепили", "прикрепляя", "приобретая", "фотографию");
var arr_word_9 = new Array(
"Анастасии", "Анастасия", "Владимира", "Владислав", "Вячеслава", "Екатерина", "Екатерины", "Елизавета", "Елизаветы", "Маргарита", "Маргариты", "аккуратно", "батарейку", "беззлобно", "безобидно", "боязненно", "возвращая", "вспоминая", "вспомнила", "вспомнили", "выбросила", "выбросили", "выкидывая", "доверчиво", "документы", "зажигалку", "заклеивая", "закрепила", "закрепили", "закрепляя", "мастерски", "нарисовал", "незаметно", "отпустила", "отпустили", "передавая", "переложил", "перемещая", "подбросил", "подержала", "подержали", "подкинула", "подкинули", "показывая", "покрасила", "покрасили", "покрутила", "покрутили", "полотенце", "попросила", "попросили", "посмотрел", "потрогала", "потрогали", "предлагая", "предложил", "приклеила", "приклеили", "прикрепил", "приобрела", "приобрели", "рассеянно", "увлечённо", "фломастер");
var arr_word_8 = new Array(
"Анатолий", "Анатолия", "Вероника", "Вероники", "Виктории", "Виктория", "Владимир", "Вячеслав", "Геннадий", "Геннадия", "Светлана", "Светланы", "апельсин", "беспечно", "вспомнил", "выбросил", "выкинула", "выкинули", "вытащила", "вытащили", "довольно", "доставая", "заклеила", "заклеили", "закрепил", "захотела", "захотели", "карандаш", "кисточку", "медленно", "накрывая", "опустила", "опустили", "оставила", "оставили", "оставляя", "отобрала", "отобрали", "отпуская", "отпустил", "очистила", "очистили", "передала", "передали", "подарила", "подарили", "подержал", "подкинул", "поднимая", "пожелала", "пожелали", "поискала", "поискали", "показала", "показали", "покрасил", "покрутил", "положила", "положили", "получила", "получили", "попросил", "потеряла", "потеряли", "потрогал", "потрясла", "потрясли", "прижимая", "приклеил", "принесла", "принесли", "принимая", "приобрёл", "продавая", "пуговицу", "радостно", "расчёску", "сигарету", "случайно", "спокойно", "спрятала", "спрятали", "таблетку", "уверенно", "указывая", "швырнула", "швырнули");
var arr_word_7 = new Array(
"Алексей", "Алексея", "Валерии", "Валерия", "Василий", "Василия", "Виктора", "Виталий", "Виталия", "Даниила", "Дмитрий", "Дмитрия", "Евгении", "Евгения", "Зинаида", "Зинаиды", "Кирилла", "Леонида", "Людмила", "Людмилы", "Максима", "Михаила", "Надежда", "Надежды", "Наталии", "Наталия", "Николай", "Николая", "Степана", "Татьяна", "Татьяны", "Эдуарда", "бросила", "бросили", "бутылку", "вернула", "вернули", "выкинул", "вынимая", "вытащил", "вытерла", "вытерли", "вытирая", "грустно", "достала", "достали", "забывая", "заклеил", "захотел", "зеркало", "игрушку", "картину", "конверт", "коробку", "линейку", "монетку", "накрыла", "накрыли", "ножницы", "опуская", "опустил", "оставил", "отбирая", "отдавая", "отобрал", "очистил", "передал", "печенье", "подарил", "подняла", "подняли", "пожелал", "поискал", "показал", "покупая", "положил", "получая", "получил", "потерял", "прижала", "прижали", "принося", "приняла", "приняли", "продала", "продали", "скрепку", "скромно", "скрывая", "спрятал", "степлер", "тарелку", "телефон", "тетрадь", "увидела", "увидели", "указала", "указали", "уронила", "уронили", "утаивая", "учебник", "фонарик", "швырнул");
var arr_word_6 = new Array(
"Андрей", "Андрея", "Антона", "Артёма", "Бориса", "Вадима", "Виктор", "Галина", "Галины", "Даниил", "Дениса", "Захара", "Кирилл", "Ксении", "Ксения", "Лариса", "Ларисы", "Леонид", "Любови", "Любовь", "Максим", "Марина", "Марины", "Милана", "Миланы", "Михаил", "Наташа", "Наташи", "Оксана", "Оксаны", "Полина", "Полины", "Романа", "Семёна", "Сергей", "Сергея", "Серёга", "Серёги", "Степан", "Тараса", "Фёдора", "Эдуард", "брелок", "бросая", "бросил", "быстро", "вернул", "весело", "выняла", "выняли", "газету", "громко", "достал", "жвачку", "журнал", "забыла", "забыли", "камеру", "кинула", "кинули", "компас", "кружку", "купила", "купили", "куртку", "ластик", "лениво", "маркер", "мрачно", "накрыл", "находя", "отдала", "отдали", "очищая", "письмо", "платок", "поднял", "потряс", "прижал", "принял", "принёс", "продал", "сжимая", "скрыла", "скрыли", "смотря", "спички", "стакан", "требуя", "трогая", "тщетно", "тяжело", "убирая", "убрала", "убрали", "увидел", "указал", "украла", "украли", "унесла", "унесли", "уронил", "устало", "утаила", "утаили", "швыряя", "яблоко");
var arr_word_5 = new Array(
"Алиса", "Алисы", "Антон", "Артём", "Борис", "Вадим", "Влада", "Глеба", "Дарьи", "Дарья", "Денис", "Диана", "Дианы", "Елена", "Елены", "Захар", "Ивана", "Игорь", "Игоря", "Ирина", "Ирины", "Кости", "Костя", "Ксюша", "Ксюши", "Лидии", "Лидия", "Луиза", "Луизы", "Макса", "Марии", "Мария", "Насти", "Настя", "Олега", "Ольга", "Ольги", "Павел", "Павла", "Петра", "Роман", "Света", "Светы", "Семён", "Слава", "Славы", "Стёпа", "Стёпы", "Тарас", "Фёдор", "банку", "билет", "бодро", "взяла", "взяли", "вилку", "вынял", "вытер", "глупо", "гордо", "грубо", "грушу", "давая", "держа", "желая", "забыл", "кидая", "кинул", "кладя", "книгу", "крадя", "крася", "крутя", "купил", "лампу", "легко", "ловко", "ложку", "нашла", "нашли", "нашёл", "отдал", "пакет", "плеер", "прося", "пряча", "рисуя", "роняя", "ручку", "сжала", "сжали", "скотч", "скрыл", "сумку", "теряя", "тряся", "тюбик", "убрал", "украл", "унося", "утаил", "чашку", "шапку", "щётку");
var arr_word_4 = new Array(
"Алла", "Аллы", "Анна", "Анны", "Бори", "Боря", "Вали", "Валя", "Вани", "Ваня", "Васи", "Вася", "Вера", "Веры", "Вика", "Вики", "Вити", "Витя", "Влад", "Вова", "Вовы", "Гали", "Галя", "Гена", "Гены", "Глеб", "Дани", "Даня", "Даша", "Даши", "Дима", "Димы", "Дина", "Дины", "Жени", "Женя", "Зина", "Зины", "Иван", "Ильи", "Илья", "Инна", "Инны", "Кати", "Катя", "Коли", "Коля", "Лара", "Лары", "Лена", "Лены", "Лида", "Лиды", "Лиза", "Лизы", "Люба", "Любы", "Люда", "Люды", "Лёни", "Лёня", "Лёша", "Лёши", "Макс", "Маша", "Маши", "Мила", "Милы", "Миша", "Миши", "Нади", "Надя", "Олег", "Паша", "Паши", "Пети", "Петя", "Пётр", "Рита", "Риты", "Роза", "Розы", "Рома", "Ромы", "Саша", "Саши", "Сени", "Сеня", "Тани", "Таня", "Толи", "Толя", "Тоша", "Тоши", "Тёма", "Тёмы", "Феди", "Федя", "Юлии", "Юлия", "Юрий", "Юрия", "беря", "взял", "видя", "дала", "дали", "даря", "диск", "ключ", "сжал", "тихо", "унёс", "хотя", "часы");
var arr_word_3 = new Array(
"Зои", "Зоя", "Ира", "Иры", "Оли", "Оля", "Юли", "Юля", "Юра", "Юры", "дал", "ища");

var arr_num_17 = new Array(
"50");
var arr_num_16 = new Array(
"49");
var arr_num_15 = new Array(
"6", "29");
var arr_num_14 = new Array(
"1");
var arr_num_13 = new Array(
"30", "53");
var arr_num_12 = new Array(
"2", "13", "26", "65");
var arr_num_11 = new Array(
"36", "7", "8", "9", "17", "19", "28", "38", "39", "41", "45", "47", "48", "27", "27", "29", "42", "42", "51", "58", "58");
var arr_num_10 = new Array(
"0", "0", "14", "36", "3", "10", "12", "20", "4", "21", "7", "32", "55", "55", "42", "44", "46", "34", "26", "26", "27", "29", "29", "31", "40", "40", "42", "45", "45", "47", "48", "48", "48", "51", "59");
var arr_num_9 = new Array(
"4", "4", "12", "14", "21", "21", "21", "25", "25", "44", "44", "0", "2", "4", "5", "15", "2", "3", "3", "3", "4", "4", "5", "27", "10", "13", "12", "13", "13", "13", "36", "55", "43", "23", "23", "25", "26", "27", "29", "30", "30", "31", "31", "36", "35", "35", "37", "37", "40", "53", "53", "40", "43", "43", "45", "45", "47", "47", "48", "51", "51", "54", "63", "57");
var arr_num_8 = new Array(
"2", "2", "9", "9", "11", "11", "12", "21", "23", "23", "60", "60", "0", "11", "3", "4", "5", "5", "7", "7", "31", "10", "12", "12", "13", "14", "14", "16", "18", "37", "17", "19", "19", "20", "20", "20", "22", "22", "23", "23", "24", "24", "25", "25", "28", "28", "30", "31", "32", "33", "33", "34", "34", "36", "36", "35", "37", "38", "38", "39", "39", "53", "41", "41", "43", "44", "44", "46", "47", "49", "49", "50", "51", "52", "41", "52", "42", "44", "56", "57", "54", "54", "51", "62", "60", "65", "65");
var arr_num_7 = new Array(
"0", "0", "7", "7", "16", "16", "18", "19", "19", "26", "29", "29", "19", "19", "27", "27", "38", "39", "42", "42", "41", "43", "51", "51", "53", "53", "45", "45", "61", "62", "62", "63", "0", "0", "5", "2", "2", "5", "6", "7", "8", "8", "8", "26", "10", "10", "11", "12", "14", "14", "15", "17", "22", "23", "29", "32", "17", "17", "33", "19", "19", "20", "22", "21", "22", "24", "25", "36", "28", "32", "32", "33", "34", "36", "16", "38", "39", "39", "41", "46", "46", "49", "50", "50", "52", "52", "46", "55", "57", "54", "49", "52", "53", "54", "59", "59", "60", "60", "63", "63", "64", "56", "60", "65");
var arr_num_6 = new Array(
"4", "4", "5", "7", "9", "11", "18", "13", "13", "26", "28", "31", "38", "33", "33", "35", "35", "39", "40", "40", "41", "50", "50", "48", "48", "43", "54", "54", "55", "55", "58", "58", "52", "57", "59", "59", "60", "60", "61", "54", "55", "63", "4", "0", "0", "16", "2", "18", "6", "6", "7", "24", "10", "11", "12", "11", "11", "20", "15", "15", "21", "25", "16", "16", "26", "27", "34", "31", "40", "17", "18", "21", "21", "24", "37", "38", "32", "44", "46", "50", "49", "52", "56", "57", "57", "40", "47", "48", "42", "43", "60", "61", "58", "58", "58", "59", "60", "61", "61", "62", "62", "63", "64", "64", "64", "65", "65");
var arr_num_5 = new Array(
"2", "2", "5", "7", "9", "11", "15", "25", "15", "15", "28", "17", "17", "23", "23", "31", "33", "32", "32", "31", "31", "37", "37", "34", "34", "37", "37", "39", "39", "42", "46", "46", "5", "5", "47", "56", "56", "48", "48", "50", "52", "61", "61", "57", "22", "22", "62", "62", "54", "55", "1", "3", "14", "1", "1", "6", "6", "8", "22", "23", "25", "8", "9", "30", "33", "11", "15", "15", "38", "24", "61", "35", "37", "16", "28", "33", "35", "30", "18", "18", "18", "21", "35", "39", "53", "54", "55", "63", "43", "56", "56", "45", "57", "50", "41", "44", "55", "58", "61", "62", "64", "62", "63", "64");
var arr_num_4 = new Array(
"3", "3", "6", "6", "10", "10", "8", "8", "34", "34", "17", "17", "10", "10", "12", "12", "20", "20", "15", "13", "13", "14", "14", "24", "24", "25", "27", "27", "16", "16", "30", "30", "18", "18", "20", "20", "28", "28", "33", "35", "35", "30", "30", "22", "22", "46", "46", "36", "36", "24", "24", "38", "38", "26", "26", "41", "41", "43", "43", "40", "40", "1", "1", "42", "47", "47", "49", "49", "44", "44", "52", "52", "47", "49", "49", "51", "51", "50", "45", "45", "59", "59", "53", "53", "1", "1", "58", "58", "63", "63", "3", "3", "6", "6", "8", "8", "56", "56", "64", "64", "64", "64", "1", "1", "59", "9", "9", "28", "9", "19", "56", "59", "62", "14", "61");
var arr_num_3 = new Array(
"29", "29", "32", "32", "57", "57", "65", "65", "65", "65", "9", "34");

//=============================================================================================

var arr_enveil = new Array(); // assign enveilized text array
var arr_enveil = text_enveil.split(""); // load chars to enveilized text array

var text_enveil = ""; // clear enveilized text
var t = ""; // clear temp word

for (i = 0; i < arr_enveil.length; ++i) { // cycle chars of enveilized array
  var s = arr_enveil[i]; // set current char
  
  var b = false; // set mark for construct word
  if (s == " ") { var b = true; } // if this char is space then set mark for parse word
  if (b == false) { // if mark for construct word
    if (s == ".") { var b = true; } // if this char is dot then set mark for parse word
  } // if (b == false)
  if (b == false) { // if mark for construct word
    if (s == ",") { var b = true; } // if this char is comma then set mark for parse word
  } // if (b == false)
  if (b == false) { // if mark for construct word
    if (s == ":") { var b = true; } // if this char is colon then set mark for parse word
  } // if (b == false)
  if (b == false) { // if mark for construct word
    if (s == "!") { var b = true; } // if this char is exclam then set mark for parse word
  } // if (b == false)
  if (b == false) { // if mark for construct word
    if (s == "\"") { var b = true; } // if this char is quote then set mark for parse word
  } // if (b == false)
  if (b == false) { // if mark for construct word
    if (s == "\n") { var b = true; } // if this char is break then set mark for parse word
  } // if (b == false)
  
  if (b == false) { // if mark for construct word
    var t = t + s; // add current char to temp word
	continue; // go to next cycle
  } // if (b == false)
  
  if (t == "") { continue; } // if temp word is empty str then go to next cycle
 
  var k = t.length; // get length of temp word

//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  
  if (k == 3) { // if length of temp word equal this value
  var b = false; // set mark for search word
  if (b == false) { // if mark for search word
    if (t == "так") { var b = true; } // if this word then set mark for ignore word
  } // if (b == false)
  if (b == false) { // if mark for search word
    if (t == "Вот") { var b = true; } // if this word then set mark for ignore word
  } // if (b == false)
  if (b == false) { // if mark for search word
    if (t == "Это") { var b = true; } // if this word then set mark for ignore word
  } // if (b == false)
  if (b == false) { // if mark for search word
    if (t == "был") { var b = true; } // if this word then set mark for ignore word
  } // if (b == false)
  if (b == false) { // if mark for search word
    if (t == "там") { var b = true; } // if this word then set mark for ignore word
  } // if (b == false)
  if (b == false) { // if mark for search word
    if (t == "это") { var b = true; } // if this word then set mark for ignore word
  } // if (b == false)

  if (b == false) { // if mark for search word
  for (j = 0; j < arr_word_3.length; ++j) { // cycle words of core word array
	if (arr_word_3[j] == t) { // if core word equal temp word
	  var text_enveil = text_enveil + arr_symbol[arr_num_3[j]]; // add symbol to enveil text
	  break; // exit from cycle j
	} // if (arr_word_3[j] == t)
  } // for (j = 0; j < arr_word_3.length; ++j)
  } // if (b == false)
  } // if (k == x)
  
  if (k == 4) { // if length of temp word equal this value
  var b = false; // set mark for search word
  if (b == false) { // if mark for search word
    if (t == "было") { var b = true; } // if this word then set mark for ignore word
  } // if (b == false)
  if (b == false) { // if mark for search word
    if (t == "была") { var b = true; } // if this word then set mark for ignore word
  } // if (b == false)

  if (b == false) { // if mark for search word
  for (j = 0; j < arr_word_4.length; ++j) { // cycle words of core word array
	if (arr_word_4[j] == t) { // if core word equal temp word
	  var text_enveil = text_enveil + arr_symbol[arr_num_4[j]]; // add symbol to enveil text
	  break; // exit from cycle j
	} // if (arr_word_4[j] == t)
  } // for (j = 0; j < arr_word_4.length; ++j)
  } // if (b == false)
  } // if (k == x)
  
  if (k == 5) { // if length of temp word equal this value
  var b = false; // set mark for search word
  if (b == false) { // if mark for search word
    if (t == "Потом") { var b = true; } // if this word then set mark for ignore word
  } // if (b == false)
  if (b == false) { // if mark for search word
    if (t == "Далее") { var b = true; } // if this word then set mark for ignore word
  } // if (b == false)
  if (b == false) { // if mark for search word
    if (t == "тогда") { var b = true; } // if this word then set mark for ignore word
  } // if (b == false)
  if (b == false) { // if mark for search word
    if (t == "Затем") { var b = true; } // if this word then set mark for ignore word
  } // if (b == false)
  if (b == false) { // if mark for search word
    if (t == "После") { var b = true; } // if this word then set mark for ignore word
  } // if (b == false)
  if (b == false) { // if mark for search word
    if (t == "этого") { var b = true; } // if this word then set mark for ignore word
  } // if (b == false)
  if (b == false) { // if mark for search word
    if (t == "видел") { var b = true; } // if this word then set mark for ignore word
  } // if (b == false)

  if (b == false) { // if mark for search word
  for (j = 0; j < arr_word_5.length; ++j) { // cycle words of core word array
	if (arr_word_5[j] == t) { // if core word equal temp word
	  var text_enveil = text_enveil + arr_symbol[arr_num_5[j]]; // add symbol to enveil text
	  break; // exit from cycle j
	} // if (arr_word_5[j] == t)
  } // for (j = 0; j < arr_word_5.length; ++j)
  } // if (b == false)
  } // if (k == x)
  
  if (k == 6) { // if length of temp word equal this value
  var b = false; // set mark for search word
  if (b == false) { // if mark for search word
    if (t == "Кстати") { var b = true; } // if this word then set mark for ignore word
  } // if (b == false)
  if (b == false) { // if mark for search word
    if (t == "потому") { var b = true; } // if this word then set mark for ignore word
  } // if (b == false)
  if (b == false) { // if mark for search word
    if (t == "сказал") { var b = true; } // if this word then set mark for ignore word
  } // if (b == false)
  if (b == false) { // if mark for search word
    if (t == "видела") { var b = true; } // if this word then set mark for ignore word
  } // if (b == false)

  if (b == false) { // if mark for search word
  for (j = 0; j < arr_word_6.length; ++j) { // cycle words of core word array
	if (arr_word_6[j] == t) { // if core word equal temp word
	  var text_enveil = text_enveil + arr_symbol[arr_num_6[j]]; // add symbol to enveil text
	  break; // exit from cycle j
	} // if (arr_word_6[j] == t)
  } // for (j = 0; j < arr_word_6.length; ++j)
  } // if (b == false)
  } // if (k == x)
  
  if (k == 7) { // if length of temp word equal this value
  var b = false; // set mark for search word
  if (b == false) { // if mark for search word
    if (t == "Позднее") { var b = true; } // if this word then set mark for ignore word
  } // if (b == false)
  if (b == false) { // if mark for search word
    if (t == "поэтому") { var b = true; } // if this word then set mark for ignore word
  } // if (b == false)
  if (b == false) { // if mark for search word
    if (t == "крикнул") { var b = true; } // if this word then set mark for ignore word
  } // if (b == false)
  if (b == false) { // if mark for search word
    if (t == "сказала") { var b = true; } // if this word then set mark for ignore word
  } // if (b == false)

  if (b == false) { // if mark for search word
  for (j = 0; j < arr_word_7.length; ++j) { // cycle words of core word array
	if (arr_word_7[j] == t) { // if core word equal temp word
	  var text_enveil = text_enveil + arr_symbol[arr_num_7[j]]; // add symbol to enveil text
	  break; // exit from cycle j
	} // if (arr_word_7[j] == t)
  } // for (j = 0; j < arr_word_7.length; ++j)
  } // if (b == false)
  } // if (k == x)
  
  if (k == 8) { // if length of temp word equal this value
  var b = false; // set mark for search word
  if (b == false) { // if mark for search word
    if (t == "Внезапно") { var b = true; } // if this word then set mark for ignore word
  } // if (b == false)
  if (b == false) { // if mark for search word
    if (t == "крикнула") { var b = true; } // if this word then set mark for ignore word
  } // if (b == false)

  if (b == false) { // if mark for search word
  for (j = 0; j < arr_word_8.length; ++j) { // cycle words of core word array
	if (arr_word_8[j] == t) { // if core word equal temp word
	  var text_enveil = text_enveil + arr_symbol[arr_num_8[j]]; // add symbol to enveil text
	  break; // exit from cycle j
	} // if (arr_word_8[j] == t)
  } // for (j = 0; j < arr_word_8.length; ++j)
  } // if (b == false)
  } // if (k == x)
  
  if (k == 9) { // if length of temp word equal this value
  var b = false; // set mark for search word

  if (b == false) { // if mark for search word
  for (j = 0; j < arr_word_9.length; ++j) { // cycle words of core word array
	if (arr_word_9[j] == t) { // if core word equal temp word
	  var text_enveil = text_enveil + arr_symbol[arr_num_9[j]]; // add symbol to enveil text
	  break; // exit from cycle j
	} // if (arr_word_9[j] == t)
  } // for (j = 0; j < arr_word_9.length; ++j)
  } // if (b == false)
  } // if (k == x)
  
  if (k == 10) { // if length of temp word equal this value
  var b = false; // set mark for search word
  if (b == false) { // if mark for search word
    if (t == "Разумеется") { var b = true; } // if this word then set mark for ignore word
  } // if (b == false)
  if (b == false) { // if mark for search word
    if (t == "Неожиданно") { var b = true; } // if this word then set mark for ignore word
  } // if (b == false)

  if (b == false) { // if mark for search word
  for (j = 0; j < arr_word_10.length; ++j) { // cycle words of core word array
	if (arr_word_10[j] == t) { // if core word equal temp word
	  var text_enveil = text_enveil + arr_symbol[arr_num_10[j]]; // add symbol to enveil text
	  break; // exit from cycle j
	} // if (arr_word_10[j] == t)
  } // for (j = 0; j < arr_word_10.length; ++j)
  } // if (b == false)
  } // if (k == x)
  
  if (k == 11) { // if length of temp word equal this value
  var b = false; // set mark for search word

  if (b == false) { // if mark for search word
  for (j = 0; j < arr_word_11.length; ++j) { // cycle words of core word array
	if (arr_word_11[j] == t) { // if core word equal temp word
	  var text_enveil = text_enveil + arr_symbol[arr_num_11[j]]; // add symbol to enveil text
	  break; // exit from cycle j
	} // if (arr_word_11[j] == t)
  } // for (j = 0; j < arr_word_11.length; ++j)
  } // if (b == false)
  } // if (k == x)
  
  if (k == 12) { // if length of temp word equal this value
  var b = false; // set mark for search word

  if (b == false) { // if mark for search word
  for (j = 0; j < arr_word_12.length; ++j) { // cycle words of core word array
	if (arr_word_12[j] == t) { // if core word equal temp word
	  var text_enveil = text_enveil + arr_symbol[arr_num_12[j]]; // add symbol to enveil text
	  break; // exit from cycle j
	} // if (arr_word_12[j] == t)
  } // for (j = 0; j < arr_word_12.length; ++j)
  } // if (b == false)
  } // if (k == x)
  
  if (k == 13) { // if length of temp word equal this value
  var b = false; // set mark for search word

  if (b == false) { // if mark for search word
  for (j = 0; j < arr_word_13.length; ++j) { // cycle words of core word array
	if (arr_word_13[j] == t) { // if core word equal temp word
	  var text_enveil = text_enveil + arr_symbol[arr_num_13[j]]; // add symbol to enveil text
	  break; // exit from cycle j
	} // if (arr_word_13[j] == t)
  } // for (j = 0; j < arr_word_13.length; ++j)
  } // if (b == false)
  } // if (k == x)
  
  if (k == 14) { // if length of temp word equal this value
  var b = false; // set mark for search word

  if (b == false) { // if mark for search word
  for (j = 0; j < arr_word_14.length; ++j) { // cycle words of core word array
	if (arr_word_14[j] == t) { // if core word equal temp word
	  var text_enveil = text_enveil + arr_symbol[arr_num_14[j]]; // add symbol to enveil text
	  break; // exit from cycle j
	} // if (arr_word_14[j] == t)
  } // for (j = 0; j < arr_word_14.length; ++j)
  } // if (b == false)
  } // if (k == x)
  
  if (k == 15) { // if length of temp word equal this value
  var b = false; // set mark for search word

  if (b == false) { // if mark for search word
  for (j = 0; j < arr_word_15.length; ++j) { // cycle words of core word array
	if (arr_word_15[j] == t) { // if core word equal temp word
	  var text_enveil = text_enveil + arr_symbol[arr_num_15[j]]; // add symbol to enveil text
	  break; // exit from cycle j
	} // if (arr_word_15[j] == t)
  } // for (j = 0; j < arr_word_15.length; ++j)
  } // if (b == false)
  } // if (k == x)
  
  if (k == 16) { // if length of temp word equal this value
  var b = false; // set mark for search word

  if (b == false) { // if mark for search word
  for (j = 0; j < arr_word_16.length; ++j) { // cycle words of core word array
	if (arr_word_16[j] == t) { // if core word equal temp word
	  var text_enveil = text_enveil + arr_symbol[arr_num_16[j]]; // add symbol to enveil text
	  break; // exit from cycle j
	} // if (arr_word_16[j] == t)
  } // for (j = 0; j < arr_word_16.length; ++j)
  } // if (b == false)
  } // if (k == x)
  
  if (k == 17) { // if length of temp word equal this value
  var b = false; // set mark for search word

  if (b == false) { // if mark for search word
  for (j = 0; j < arr_word_17.length; ++j) { // cycle words of core word array
	if (arr_word_17[j] == t) { // if core word equal temp word
	  var text_enveil = text_enveil + arr_symbol[arr_num_17[j]]; // add symbol to enveil text
	  break; // exit from cycle j
	} // if (arr_word_17[j] == t)
  } // for (j = 0; j < arr_word_17.length; ++j)
  } // if (b == false)
  } // if (k == x)
  
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  
  var t = ""; // clear temp word
} // for (i = 0; i < arr_enveil.length; ++i)

//=============================================================================================

  var text_result = text_result + text_enveil; // add enveilized text to result text
  return text_result; // print result text
} // function func_deveil_rus(text_enveil, str_symbol)

//=============================================================================================
