/*=============================================================================================

VEIL-ENG (c)
Version: 3.14.2.1

Author: VanDerSaAr

Enveil-eng converts base64 text to random english text with simple sentences. Deveil-eng
converts this generated english text to base64-text. Enveilized text hides base64 text.

See example: http://cryptbb.site40.net

~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

License: MIT

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.
 
-----------------------------------------------------------------------------------------------

Changelog:
2014-02-01: Removed some commas in sentenses.
2013-06-14: Publicated first version.

*///===========================================================================================
//=============================================================================================
//=============================================================================================

// enveil-eng.js
// Version: 3.14.2.1
// Author: VanDerSaAr
// License: MIT

function func_enveil_eng(text_unveil) {
  if (text_unveil.length == 0) { // if unveilized text is empty text
    return ""; // exit
  } // if (text_unveil.length == 0)

  var text_result = ""; // clear result text
  
//set symbol string base64+pad+space (standart/custom)
//var str_symbol = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=_";
  var str_symbol = "ABCDEFGH:JKLMN-PQRSTUVWXYZabcdefghijk;mnopqrstuvwxyz~!23456789.,=_";
  
//=============================================================================================

arr_noun_name_male = new Array( // word noun, type name
"Alexander",
"Andrew",
"Anthony",
"Bill",
"Bob",
"Brad",
"Brandon",
"Brian",
"Bruce",
"Carl",
"Charles",
"Christian",
"Christopher",
"Daniel",
"Darrell",
"David",
"Dennis",
"Edward",
"Eric",
"Ethan",
"Jack",
"Jackson",
"Jacob",
"James",
"Jason",
"Jayden",
"Jeff",
"Jeffrey",
"Jeremy",
"Jerry",
"Jim",
"Joe",
"John",
"Joseph",
"Justin",
"Kevin",
"Kurt",
"Larry",
"Liam",
"Logan",
"Lucas",
"Mason",
"Matthew",
"Michael",
"Mike",
"Patrick",
"Paul",
"Peter",
"Raymond",
"Rick",
"Richard",
"Rob",
"Robert",
"Robin",
"Roger",
"Ron",
"Ronald",
"Ryan",
"Sam",
"Scott",
"Steve",
"Ted",
"Terry",
"Tom",
"Thomas",
"William"
); // arr_noun_name_male = new Array

arr_noun_name_fem = new Array( // word noun, type name
"Abigail",
"Alexis",
"Alicia",
"Allison",
"Audrey",
"Amanda",
"Angela",
"Angelina",
"Ann",
"Ashley",
"Ava",
"Barbara",
"Betty",
"Brenda",
"Camila",
"Carolyn",
"Chloe",
"Clare",
"Courtney",
"Daniela",
"Dorothy",
"Dana",
"Deborah",
"Elizabeth",
"Emma",
"Emily",
"Fiona",
"Gabriela",
"Isabella",
"Janet",
"Jennifer",
"Jasmine",
"Jessica",
"Julia",
"Karen",
"Katy",
"Kelly",
"Laura",
"Leah",
"Linda",
"Lisa",
"Madison",
"Margaret",
"Maria",
"Mariana",
"Martha",
"Mary",
"Melissa",
"Nancy",
"Olivia",
"Pamela",
"Patricia",
"Rachel",
"Rebeca",
"Sabrine",
"Samantha",
"Sandra",
"Sarah",
"Sharon",
"Shyla",
"Sophia",
"Susan",
"Tracy",
"Valeria",
"Valentina",
"Victoria"
); // arr_noun_name_fem = new Array

arr_verb_part2 = new Array( // word verb, tense participle 2
"acquired",
"asked about",
"attached",
"brought",
"bought",
"cleared",
"came with",
"concealed",
"covered",
"drown",
"dropped",
"fastened",
"found",
"fixed",
"forgotten",
"got",
"given",
"gone with",
"heard about",
"hidden",
"held",
"kept",
"left",
"lifted",
"looked for",
"lost",
"lowered",
"moved",
"offered",
"painted",
"picked up",
"placed",
"pointed to",
"presented",
"pressed",
"pulled out",
"pushed",
"put",
"received",
"remembered",
"reminded of",
"replaced",
"requested",
"required",
"retaken",
"returned",
"rotated",
"seen",
"sold",
"shaken",
"shifted",
"shown",
"soiled",
"spoke about",
"spoilt",
"squeezed",
"stolen",
"stuck",
"taken",
"told about",
"thrown",
"touched",
"turned",
"wanted",
"wiped",
"wished"
); // arr_verb_part2 = new Array

arr_gerund = new Array( // word gerund
"acquiring",
"asking about",
"attaching",
"bringing",
"buying",
"clearing",
"coming with",
"concealing",
"covering",
"drawing",
"droping",
"fastening",
"finding",
"fixing",
"forgeting",
"geting",
"giving",
"going with",
"hearing about",
"hiding",
"holding",
"keeping",
"leaving",
"lifting",
"looking for",
"losing",
"lowering",
"moving",
"offering",
"painting",
"picking up",
"placing",
"pointing to",
"presenting",
"pressing",
"pulling out",
"pushing",
"puting",
"receiving",
"remembering",
"reminding of",
"replacing",
"requesting",
"requiring",
"retaking",
"returning",
"rotating",
"seeing",
"selling",
"shaking",
"shifting",
"showing",
"soiling",
"speaking about",
"spoiling",
"squeezing",
"stealing",
"sticking",
"taking",
"telling about",
"throwing",
"touching",
"turning",
"wanting",
"wiping",
"wishing"
); // arr_gerund = new Array

arr_adverb = new Array( // word adverb
"admirely",//voshischionno
"accidentally",//sluchayno
"accurately",//akkuratno
"airily",//bezzabotno
"arrogantly",//vysokomerno
"benevolently",//dobrozhelatelno
"camly",//spokoyno
"carefully",//staratelno
"carelessly",//bespechno
"certainly",//uverenno
"cheerfully",//bodro
"cheerlessly",//bezradostno
"constraintly",//prinuzhdionno
"convincingly",//ubeditelno
"difficultly",//tiazhelo
"disappointedly",//razocharovanno
"distrustfully",//nedoverchivo
"easily",//legko
"emotionally",//emotsionalno
"exhaustedly",//izmozhdionno
"fearlessly",//bezboyaznenno
"fearly",//boyaznenno
"frantically",//neistovo
"gladly",//dovolno
"gloomly",//mrachno
"haughtly",//vysokomerno
"honestly",//dobrosovestno
"inanely",//bessmyslenno
"indifferently",//bezrazlichno
"inoffencively",//bezobidno
"instantly",//nemedlenno
"inspirely",//vdohnovenno
"joyfully",//radostno
"joylessly",//bezradostno
"malicious",//zlobno
"merrily",//veselo
"mildly",//bezzlobno
"modestly",//skromno
"neatly",//lovko
"passionly",//uvlechionno
"persistenly",//uporno
"persuasively",//ubeditelno
"preventively",//predupreditelno
"proudly",//gordo
"prudently",//predusmotritelno
"purposely",//umyshlenno
"quickly",//bystro
"quietly",//spokoyno
"rapidly",//bystro
"recklessly",//bezrassudno
"restlessly",//bespokoyno
"roughly",//grubo
"rudely",//grubo
"sadly",//grustno
"skilfully",//masterski
"slowly",//medlenno
"sorrowfully",//grustno
"swiftly",//bystro
"tenderly",//nezhno
"tirely",//ustalo
"trustfully",//doverchivo
"unadvisedly",//neobdumanno
"uncertainly",//neuverenno
"vainly",//tschetno
"validly",//obosnovanno
"voluntarily"//dobrovolno
); // arr_adverb = new Array

arr_noun_object = new Array( // word noun, type object
"apple",//yabloko
"bag",//sumka
"battery",//batareyka
"bell",//kolokolchik
"book",//kniga
"bottle",//butylka
"box",//korobka
"brush",//kistochka
"button",//pugovitsa
"camera",//fotokamera
"chalk",//melok
"charm",//brelok
"clip",//skrepka
"coin",//monetka
"comb",//raschioska
"compass",//kompas
"cookie",//pechenye
"cup",//chashka
"disc",//disk
"document",//dokument
"eraser",//lastik
"fineliner",//marker
"flower",//tsvetok
"flashlight",//fonarik
"fork",//vilka
"glass",//stakan
"gum",//zhvachka
"hat",//shapka
"jacket",//kurtka
"jar",//banka
"journal",//zhurnal
"key",//kliuch
"lamp",//lampa
"letter",//pismo
"magazine",//zhurnal
"matchbox",//spichechnyy-korobok
"mirror",//zerkalo
"mug",//kruzhka
"newspaper",//gazeta
"notebook",//tetrad
"orange",//apelsin
"packet",//paket
"pear",//grusha
"pen",//ruchka
"pencil",//karandash
"picture",//kartina
"plate",//tarelka
"player",//pleyer
"ruler",//lineyka
"saucer",//bliudtse
"scissors",//nozhnitsy
"scotch tape",//skotch
"spoon",//lozhka
"stamp",//marka
"tablet",//tabletka
"tankard",//metallicheskaya-kruzhka
"telephone",//telefon
"textbook",//uchebnik
"ticket",//bilet
"tooth-brush",//zubnaya-schiotka
"torch",//fonarik
"towel",//polotentse
"toy",//igrushka
"trinket",//brelok
"tube",//tiubik
"watch"//chasy
); // arr_noun_object = new Array

//=============================================================================================

var snt_len_max = 8; // set max count of core words in sentence
var parag_word_count_min = 30; // set max word count for split text to paragraphs
	
//---------------------------------------------------------------------------------------------

var arr_snt_len_1 = new Array( // structure of sentence with 1 core word

"AndOr M-name wasThere .",
"AndOr F-name wasThere ."

); // var arr_snt_len_1 = new Array

//---------------------------------------------------------------------------------------------

var arr_snt_len_2 = new Array( // structure of sentence with 2 core words
	
"AndOr M-name hasOr vp2 !",
"AndOr F-name hasOr vp2 !"

); // var arr_snt_len_2 = new Array

//---------------------------------------------------------------------------------------------

var arr_snt_len_3 = new Array( // structure of sentence with 3 core words

"LaterOr M-name has vp2 the noun .",
"LaterOr F-name has vp2 the noun .",
"AndOr M-name hasOr vp2 the noun .",
"AndOr F-name hasOr vp2 the noun ."

); // var arr_snt_len_3 = new Array

//---------------------------------------------------------------------------------------------

var arr_snt_len_4 = new Array( // structure of sentence with 4 core words

"LaterOr M-name said \" F-name has vp2 the noun ! \"",
"LaterOr F-name said \" M-name has vp2 the noun ! \"",
"AndOr M-name said \" F-name has vp2 the noun ! \"",
"AndOr F-name said \" M-name has vp2 the noun ! \"",

"LaterOr M-name has vp2 F-name's noun .",
"LaterOr F-name has vp2 M-name's noun .",
"AndOr M-name hasOr vp2 F-name's noun .",
"AndOr F-name hasOr vp2 M-name's noun .",

"LaterOr M-name adv has vp2 the noun .",
"LaterOr F-name adv has vp2 the noun .",
"AndOr M-name hasOr vp2 the noun adv .",
"AndOr F-name hasOr vp2 the noun adv .",

"LaterOr M-name and F-name have vp2 the noun .",
"LaterOr F-name and M-name have vp2 the noun .",
"AndOr M-name and F-name haveOr vp2 the noun .",
"AndOr F-name and M-name haveOr vp2 the noun ."

); // var arr_snt_len_4 = new Array

//---------------------------------------------------------------------------------------------

var arr_snt_len_5 = new Array( // structure of sentence with 5 core words

"LaterOr M-name grnd the noun has vp2 the noun .",
"LaterOr F-name grnd the noun has vp2 the noun .",
"AndOr M-name grnd the noun hasOr vp2 the noun .",
"AndOr F-name grnd the noun hasOr vp2 the noun .",

"LaterOr M-name said \" F-name has vp2 M-name's noun ! \"",
"LaterOr F-name said \" M-name has vp2 F-name's noun ! \"",
"AndOr M-name said \" F-name has vp2 M-name's noun ! \"",
"AndOr F-name said \" M-name has vp2 F-name's noun ! \"",

"LaterOr M-name adv has vp2 F-name's noun .",
"LaterOr F-name adv has vp2 M-name's noun .",
"AndOr M-name hasOr vp2 F-name's noun adv .",
"AndOr F-name hasOr vp2 M-name's noun adv .",

"LaterOr M-name adv said \" F-name has vp2 the noun ! \"",
"LaterOr F-name adv said \" M-name has vp2 the noun ! \"",
"AndOr M-name adv said \" F-name has vp2 the noun ! \"",
"AndOr F-name adv said \" M-name has vp2 the noun ! \"",

"LaterOr M-name and F-name adv have vp2 the noun .",
"LaterOr F-name and M-name adv have vp2 the noun .",
"AndOr M-name and F-name haveOr vp2 the noun adv .",
"AndOr F-name and M-name haveOr vp2 the noun adv ."

); // var arr_snt_len_5 = new Array

//---------------------------------------------------------------------------------------------

var arr_snt_len_6 = new Array( // structure of sentence with 6 core words

"LaterOr M-name grnd the noun has vp2 F-name's noun .",
"LaterOr F-name grnd the noun has vp2 M-name's noun .",
"LaterOr M-name grnd F-name's noun has vp2 the noun .",
"LaterOr F-name grnd M-name's noun has vp2 the noun .",
"AndOr M-name grnd the noun hasOr vp2 F-name's noun .",
"AndOr F-name grnd the noun hasOr vp2 M-name's noun .",
"AndOr M-name grnd F-name's noun hasOr vp2 the noun .",
"AndOr F-name grnd M-name's noun hasOr vp2 the noun .",

"AndOr M-name hasOr vp2 the noun , causeOr F-name hasOr vp2 the noun .",
"AndOr F-name hasOr vp2 the noun , causeOr M-name hasOr vp2 the noun .",
  
"LaterOr M-name grnd the noun said \" F-name has vp2 the noun ! \"",
"LaterOr F-name grnd the noun said \" M-name has vp2 the noun ! \"",
"AndOr M-name grnd the noun said \" F-name has vp2 the noun ! \"",
"AndOr F-name grnd the noun said \" M-name has vp2 the noun ! \"",

"LaterOr M-name and F-name grnd the noun have vp2 the noun .",
"LaterOr F-name and M-name grnd the noun have vp2 the noun .",
"AndOr M-name and F-name grnd the noun haveOr vp2 the noun .",
"AndOr F-name and M-name grnd the noun haveOr vp2 the noun .",

"LaterOr M-name adv grnd the noun has vp2 the noun .",
"LaterOr F-name adv grnd the noun has vp2 the noun .",
"AndOr M-name adv grnd the noun hasOr vp2 the noun .",
"AndOr F-name adv grnd the noun hasOr vp2 the noun .",
  
"LaterOr M-name adv said \" F-name has vp2 M-name's noun ! \"",
"LaterOr F-name adv said \" M-name has vp2 F-name's noun ! \"",
"AndOr M-name adv said \" F-name has vp2 M-name's noun ! \"",
"AndOr F-name adv said \" M-name has vp2 F-name's noun ! \""

); // var arr_snt_len_6 = new Array

//---------------------------------------------------------------------------------------------

var arr_snt_len_7 = new Array( // structure of sentence with 7 core words

"LaterOr M-name grnd F-name's noun has vp2 F-name's noun .",
"LaterOr F-name grnd M-name's noun has vp2 M-name's noun .",
"AndOr M-name grnd F-name's noun hasOr vp2 F-name's noun .",
"AndOr F-name grnd M-name's noun hasOr vp2 M-name's noun .",

"AndOr M-name hasOr vp2 the noun , causeOr F-name hasOr vp2 the noun adv .",
"AndOr F-name hasOr vp2 the noun , causeOr M-name hasOr vp2 the noun adv .",
"AndOr M-name hasOr vp2 the noun adv , causeOr F-name hasOr vp2 the noun .",
"AndOr F-name hasOr vp2 the noun adv , causeOr M-name hasOr vp2 the noun .",

"AndOr M-name hasOr vp2 the noun , causeOr F-name hasOr vp2 M-name's noun .",
"AndOr F-name hasOr vp2 the noun , causeOr M-name hasOr vp2 F-name's noun .",
"AndOr M-name hasOr vp2 F-name's noun , causeOr F-name hasOr vp2 the noun .",
"AndOr F-name hasOr vp2 M-name's noun , causeOr M-name hasOr vp2 the noun .",

"AndOr M-name and F-name haveOr vp2 the noun , causeOr M-name hasOr vp2 the noun .",
"AndOr F-name and M-name haveOr vp2 the noun , causeOr F-name hasOr vp2 the noun .",

"LaterOr M-name grnd the noun said \" F-name has vp2 M-name's noun ! \"",
"LaterOr F-name grnd the noun said \" M-name has vp2 F-name's noun ! \"",
"AndOr M-name grnd the noun said \" F-name has vp2 M-name's noun ! \"",
"AndOr F-name grnd the noun said \" M-name has vp2 F-name's noun ! \"",
"LaterOr M-name grnd F-name's noun said \" F-name has vp2 the noun ! \"",
"LaterOr F-name grnd M-name's noun said \" M-name has vp2 the noun ! \"",
"AndOr M-name grnd F-name's noun said \" F-name has vp2 the noun ! \"",
"AndOr F-name grnd M-name's noun said \" M-name has vp2 the noun ! \"",

"LaterOr M-name grnd F-name's noun said \" F-name has vp2 the noun ! \"",
"LaterOr F-name grnd M-name's noun said \" M-name has vp2 the noun ! \"",
"AndOr M-name grnd F-name's noun said \" F-name has vp2 the noun ! \"",
"AndOr F-name grnd M-name's noun said \" M-name has vp2 the noun ! \"",

"LaterOr M-name grnd F-name's noun has vp2 F-name's noun .",
"LaterOr F-name grnd M-name's noun has vp2 M-name's noun .",
"AndOr M-name grnd F-name's noun hasOr vp2 F-name's noun .",
"AndOr F-name grnd M-name's noun hasOr vp2 M-name's noun .",

"LaterOr M-name and F-name grnd the noun have vp2 M-name's noun .",
"LaterOr F-name and M-name grnd the noun have vp2 F-name's noun .",
"AndOr M-name and F-name grnd the noun haveOr vp2 M-name's noun .",
"AndOr F-name and M-name grnd the noun haveOr vp2 F-name's noun .",
"LaterOr M-name and F-name grnd M-name's noun have vp2 the noun .",
"LaterOr F-name and M-name grnd F-name's noun have vp2 the noun .",
"AndOr M-name and F-name grnd M-name's noun haveOr vp2 the noun .",
"AndOr F-name and M-name grnd F-name's noun haveOr vp2 the noun .",

"LaterOr M-name adv grnd the noun has vp2 F-name's noun .",
"LaterOr F-name adv grnd the noun has vp2 M-name's noun .",
"AndOr M-name adv grnd the noun hasOr vp2 F-name's noun .",
"AndOr F-name adv grnd the noun hasOr vp2 M-name's noun .",
"LaterOr M-name adv grnd F-name's noun has vp2 the noun .",
"LaterOr F-name adv grnd M-name's noun has vp2 the noun .",
"AndOr M-name adv grnd F-name's noun hasOr vp2 the noun .",
"AndOr F-name adv grnd M-name's noun hasOr vp2 the noun ."

); // var arr_snt_len_7 = new Array

//---------------------------------------------------------------------------------------------

var arr_snt_len_8 = new Array( // structure of sentence with 8 core words

"AndOr M-name hasOr vp2 F-name's noun , causeOr F-name hasOr vp2 M-name's noun .",
"AndOr F-name hasOr vp2 M-name's noun , causeOr M-name hasOr vp2 F-name's noun .",

"AndOr M-name hasOr vp2 the noun , causeOr F-name hasOr vp2 M-name's noun adv .",
"AndOr F-name hasOr vp2 the noun , causeOr M-name hasOr vp2 F-name's noun adv .",
"AndOr M-name hasOr vp2 F-name's noun , causeOr F-name hasOr vp2 the noun adv .",
"AndOr F-name hasOr vp2 M-name's noun , causeOr M-name hasOr vp2 the noun adv .",
  
"AndOr M-name hasOr vp2 the noun adv , causeOr F-name hasOr vp2 M-name's noun .",
"AndOr F-name hasOr vp2 the noun adv , causeOr M-name hasOr vp2 F-name's noun .",
"AndOr M-name hasOr vp2 F-name's noun adv , causeOr F-name hasOr vp2 the noun .",
"AndOr F-name hasOr vp2 M-name's noun adv , causeOr M-name hasOr vp2 the noun .",

"AndOr M-name and F-name haveOr vp2 the noun , causeOr M-name hasOr vp2 F-name's noun .",
"AndOr F-name and M-name haveOr vp2 the noun , causeOr F-name hasOr vp2 M-name's noun .",
"AndOr M-name and F-name haveOr vp2 M-name's noun , causeOr F-name hasOr vp2 the noun .",
"AndOr F-name and M-name haveOr vp2 F-name's noun , causeOr M-name hasOr vp2 the noun .",

"AndOr M-name and F-name haveOr vp2 the noun adv , causeOr M-name hasOr vp2 the noun .",
"AndOr F-name and M-name haveOr vp2 the noun adv , causeOr F-name hasOr vp2 the noun .",
"AndOr M-name and F-name haveOr vp2 the noun , causeOr M-name hasOr vp2 the noun adv .",
"AndOr F-name and M-name haveOr vp2 the noun , causeOr F-name hasOr vp2 the noun adv .",

"LaterOr M-name grnd F-name's noun said \" F-name hasOr vp2 M-name's noun ! \"",
"LaterOr F-name grnd M-name's noun said \" M-name hasOr vp2 F-name's noun ! \"",
"AndOr M-name grnd F-name's noun said \" F-name hasOr vp2 M-name's noun ! \"",
"AndOr F-name grnd M-name's noun said \" M-name hasOr vp2 F-name's noun ! \"",

"LaterOr M-name adv grnd F-name's noun has vp2 F-name's noun .",
"LaterOr F-name adv grnd M-name's noun has vp2 M-name's noun .",
"AndOr M-name adv grnd F-name's noun hasOr vp2 F-name's noun .",
"AndOr F-name adv grnd M-name's noun hasOr vp2 M-name's noun .",
"LaterOr M-name grnd F-name's noun has vp2 F-name's noun adv .",
"LaterOr F-name grnd M-name's noun has vp2 M-name's noun adv .",
"AndOr M-name grnd F-name's noun hasOr vp2 F-name's noun adv .",
"AndOr F-name grnd M-name's noun hasOr vp2 M-name's noun adv .",

"LaterOr M-name and F-name grnd M-name's noun have vp2 F-name's noun .",
"LaterOr F-name and M-name grnd F-name's noun have vp2 M-name's noun .",
"AndOr M-name and F-name grnd M-name's noun haveOr vp2 F-name's noun .",
"AndOr F-name and M-name grnd F-name's noun haveOr vp2 M-name's noun .",

"LaterOr M-name and F-name adv grnd M-name's noun have vp2 the noun .",
"LaterOr F-name and M-name adv grnd F-name's noun have vp2 the noun .",
"AndOr M-name and F-name adv grnd M-name's noun haveOr vp2 the noun .",
"AndOr F-name and M-name adv grnd F-name's noun haveOr vp2 the noun .",
"LaterOr M-name and F-name grnd M-name's noun have vp2 the noun adv .",
"LaterOr F-name and M-name grnd F-name's noun have vp2 the noun adv .",
"AndOr M-name and F-name grnd M-name's noun haveOr vp2 the noun adv .",
"AndOr F-name and M-name grnd F-name's noun haveOr vp2 the noun adv .",

"LaterOr M-name adv grnd F-name's noun has vp2 F-name's noun .",
"LaterOr F-name adv grnd M-name's noun has vp2 M-name's noun .",
"AndOr M-name adv grnd F-name's noun hasOr vp2 F-name's noun .",
"AndOr F-name adv grnd M-name's noun hasOr vp2 M-name's noun .",

"LaterOr M-name adv grnd the noun has vp2 F-name's noun adv .",
"LaterOr F-name adv grnd the noun has vp2 M-name's noun adv .",
"AndOr M-name adv grnd the noun hasOr vp2 F-name's noun adv .",
"AndOr F-name adv grnd the noun hasOr vp2 M-name's noun adv ."

); // var arr_snt_len_8 = new Array

//=============================================================================================

var len_symbol = str_symbol.length; // get symbol string's char count
var arr_symbol = new Array(); // assign symbol string array
var arr_symbol = str_symbol.split(""); // load chars to symbol string array

var len_unveil = text_unveil.length; // get unveilized text's char count
var arr_unveil = new Array(); // assign unveilized text array
var arr_unveil = text_unveil.split(""); // load chars to unveilized text array

//---------------------------------------------------------------------------------------------

var veil_snt = "Begin"; // add begin to sentence text
var i = 0; // reset char index

while (i < len_unveil) { // cycle unveilized text's chars
  
  var snt_len_cur = Math.floor(Math.random() * (snt_len_max - 2))
    + 3; // randomize core word count of current sentence
  if ((i + snt_len_cur)
    > len_unveil) { // if core word count exceed further unveilized text's core word count
    var snt_len_cur = len_unveil - i; // set word count of current sentence
  } // if ((i + snt_len_cur) > len_unveil)

//---------------------------------------------------------------------------------------------
 
  if (snt_len_cur == 1) { // if word count of current sentence equal this value
    var m = Math.floor(Math.random() * arr_snt_len_1.length); // randomize type of sentence
    var veil_snt = veil_snt + " " + arr_snt_len_1[m]; // set sentence text to temp string
  } // if (snt_len_cur == 1)

  if (snt_len_cur == 2) { // if word count of current sentence equal this value
    var m = Math.floor(Math.random() * arr_snt_len_2.length); // randomize type of sentence
    var veil_snt = veil_snt + " " + arr_snt_len_2[m]; // set sentence text to temp string
  } // if (snt_len_cur == 2)

  if (snt_len_cur == 3) { // if word count of current sentence equal this value
    var m = Math.floor(Math.random() * arr_snt_len_3.length); // randomize type of sentence
    var veil_snt = veil_snt + " " + arr_snt_len_3[m]; // set sentence text to temp string
  } // if (snt_len_cur == 3)

  if (snt_len_cur == 4) { // if word count of current sentence equal this value
    var m = Math.floor(Math.random() * arr_snt_len_4.length); // randomize type of sentence
    var veil_snt = veil_snt + " " + arr_snt_len_4[m]; // set sentence text to temp string
  } // if (snt_len_cur == 4)

  if (snt_len_cur == 5) { // if word count of current sentence equal this value
    var m = Math.floor(Math.random() * arr_snt_len_5.length); // randomize type of sentence
    var veil_snt = veil_snt + " " + arr_snt_len_5[m]; // set sentence text to temp string
  } // if (snt_len_cur == 5)

  if (snt_len_cur == 6) { // if word count of current sentence equal this value
    var m = Math.floor(Math.random() * arr_snt_len_6.length); // randomize type of sentence
    var veil_snt = veil_snt + " " + arr_snt_len_6[m]; // set sentence text to temp string
  } // if (snt_len_cur == 6)

  if (snt_len_cur == 7) { // if word count of current sentence equal this value
    var m = Math.floor(Math.random() * arr_snt_len_7.length); // randomize type of sentence
    var veil_snt = veil_snt + " " + arr_snt_len_7[m]; // set sentence text to temp string
  } // if (snt_len_cur == 7)
  
  if (snt_len_cur == 8) { // if word count of current sentence equal this value
    var m = Math.floor(Math.random() * arr_snt_len_8.length); // randomize type of sentence
    var veil_snt = veil_snt + " " + arr_snt_len_8[m]; // set sentence text to temp string
  } // if (snt_len_cur == 8)

//---------------------------------------------------------------------------------------------
  
  var i = i + snt_len_cur; // increase cycle index with core word count of current sentence
} // while (i < len_unveil)

var veil_snt = veil_snt + " End"; // add end to sentence text

//=============================================================================================

var arr_enveil = new Array(); // assign sentence word array
var arr_enveil = veil_snt.split(" "); // load words from sentence text to sentence word array

var veil_str = ""; // clear enveilized text

var m = 0; // clear veiltext word number
var q = 0; // clear sentence word number

for (i = 0; i < arr_enveil.length; ++i) { // cycle sentence words of sentence text from 2nd
  if (arr_enveil[i] == ".") { // if current sentence word equal dot
    var veil_str = veil_str + arr_enveil[i]; // add this word to enveilized text
	
    if (q > parag_word_count_min) { // if sentence word number more min paragraph word count
      if (Math.floor(Math.random() * 2) == 1) { // if random 50/50
	    var veil_str = veil_str + "\n"; // add breakline to enveilized text
  	    var q = 0; // reset sentence word number
	  } // if (Math.floor(Math.random() * 2) == 1)
    } // if (q > parag_word_count_min)
	
	continue; // go to next sentence word of sentence text in cycle
  } // if (arr_enveil[i] == ".")
  
  if (arr_enveil[i] == ",") { // if current sentence word equal comma
    var veil_str = veil_str + arr_enveil[i]; // add this word to enveilized text
	continue; // go to next sentence word of sentence text in cycle
  } // if (arr_enveil[i] == ",")
  if (arr_enveil[i] == "!") { // if current sentence word equal exclamation mark
    var veil_str = veil_str + arr_enveil[i]; // add this word to enveilized text
	continue; // go to next sentence word of sentence text in cycle
  } // if (arr_enveil[i] == "!")
  if (arr_enveil[i] == "\"") { // if current sentence word equal quote
    var veil_str = veil_str + arr_enveil[i]; // add this word to enveilized text
	continue; // go to next sentence word of sentence text in cycle
  } // if (arr_enveil[i] == "\"")

  if (arr_enveil[i] == "Begin") { // if current sentence word equal begin
    var n = Math.floor(Math.random() * 8); // randomize type of phrase
	if (n == 0) { veil_str = veil_str + " " + "Then it was so."; }
	if (n == 1) { veil_str = veil_str + " " + "Further it was insteresting."; }
	if (n >= 2) {}
	continue; // go to next sentence word of sentence text in cycle
  } // if (arr_enveil[i] == "Begin")
  if (arr_enveil[i] == "End") { // if current sentence word equal end
    var n = Math.floor(Math.random() * 8); // randomize type of phrase
	if (n == 0) { veil_str = veil_str + " " + "That was so."; }
	if (n == 1) { veil_str = veil_str + " " + "This was so."; }
	if (n >= 2) {}
	continue; // go to next sentence word of sentence text in cycle
  } // if (arr_enveil[i] == "End")
  
  if (arr_enveil[i] == "and") { // if current sentence word equal this word
    var veil_str = veil_str + " " + "and";
	continue; // go to next sentence word of sentence text in cycle
  } // if (arr_enveil[i] == "and")
  if (arr_enveil[i] == "AndOr") { // if current sentence word equal this word
    var n = Math.floor(Math.random() * 4); // randomize type of phrase
	if (n == 0) { veil_str = veil_str + " " + "And"; }
	if (n == 1) { veil_str = veil_str + " " + "But"; }
	if (n >= 2) {}
	continue; // go to next sentence word of sentence text in cycle
  } // if (arr_enveil[i] == "AndOr")
  
  if (arr_enveil[i] == "has") { // if current sentence word equal this word
    var veil_str = veil_str + " " + "has";
	continue; // go to next sentence word of sentence text in cycle
  } // if (arr_enveil[i] == "has")
  if (arr_enveil[i] == "hasOr") { // if current sentence word equal this word
    var n = Math.floor(Math.random() * 4); // randomize type of phrase
	if (n == 0) { veil_str = veil_str + " " + "hasn't"; }
	if (n == 1) { veil_str = veil_str + " " + "has not"; }
	if (n >= 2) { veil_str = veil_str + " " + "has"; }
	continue; // go to next sentence word of sentence text in cycle
  } // if (arr_enveil[i] == "hasOr")
  if (arr_enveil[i] == "have") { // if current sentence word equal this word
    var veil_str = veil_str + " " + "have";
	continue; // go to next sentence word of sentence text in cycle
  } // if (arr_enveil[i] == "have")
  if (arr_enveil[i] == "haveOr") { // if current sentence word equal this word
    var n = Math.floor(Math.random() * 4); // randomize type of phrase
	if (n == 0) { veil_str = veil_str + " " + "haven't"; }
	if (n == 1) { veil_str = veil_str + " " + "have not"; }
	if (n >= 2) { veil_str = veil_str + " " + "have"; }
	continue; // go to next sentence word of sentence text in cycle
  } // if (arr_enveil[i] == "haveOr")

  if (arr_enveil[i] == "The") { // if current sentence word equal this word
    var veil_str = veil_str + " " + "The";
	continue; // go to next sentence word of sentence text in cycle
  } // if (arr_enveil[i] == "The")
  if (arr_enveil[i] == "the") { // if current sentence word equal this word
    var veil_str = veil_str + " " + "the";
	continue; // go to next sentence word of sentence text in cycle
  } // if (arr_enveil[i] == "the")
  
  if (arr_enveil[i] == "said") { // if current sentence word equal this word
    var n = Math.floor(Math.random() * 2); // randomize type of phrase
	if (n == 0) { veil_str = veil_str + " " + "said:"; } //skazal
	if (n == 1) { veil_str = veil_str + " " + "cried:"; } //kriknul
	continue; // go to next sentence word of sentence text in cycle
  } // if (arr_enveil[i] == "said")
  if (arr_enveil[i] == "causeOr") { // if current sentence word equal this word
    var n = Math.floor(Math.random() * 4); // randomize type of phrase
	if (n == 0) { veil_str = veil_str + " " + "therefore"; } //poetomu
	if (n == 1) { veil_str = veil_str + " " + "that is why"; } //potomu
	if (n >= 2) { veil_str = veil_str + " " + "because"; } //potomu-chto
	continue; // go to next sentence word of sentence text in cycle
  } // if (arr_enveil[i] == "causeOr")

  if (arr_enveil[i] == "LaterOr") { // if current sentence word equal this word
    var n = Math.floor(Math.random() * 9); // randomize type of phrase
	if (n == 0) { veil_str = veil_str + " " + "Then"; } //zatem
	if (n == 1) { veil_str = veil_str + " " + "Later"; } //pozdneye
	if (n == 2) { veil_str = veil_str + " " + "Further"; } //daleye
	if (n == 3) { veil_str = veil_str + " " + "Afterwards"; } //posle
	if (n == 4) { veil_str = veil_str + " " + "Suddenly"; } //neozhidanno
	if (n == 5) { veil_str = veil_str + " " + "Unexpectedly"; } //vnezapno
	if (n == 6) { veil_str = veil_str + " " + "By the way,"; } //kstati
	if (n == 7) { veil_str = veil_str + " " + "Of course,"; } //razumeyetsia
	continue; // go to next sentence word of sentence text in cycle
  } // if (arr_enveil[i] == "LaterOr")

  if (arr_enveil[i] == "wasThere") { // if current sentence word equal this word
    var n = Math.floor(Math.random() * 2); // randomize type of phrase
	if (n == 0) { veil_str = veil_str + " " + "was there"; } //zatem
	if (n == 1) { veil_str = veil_str + " " + "saw it"; } //pozdneye
	continue; // go to next sentence word of sentence text in cycle
  } // if (arr_enveil[i] == "wasThere")
  
//---------------------------------------------------------------------------------------------
  
  var s = arr_unveil[m]; // set current char of unveilized text array to temp string  
  var k = -1; // reset current char's number in base64 text
  
  for (j = 0; j < len_symbol; ++j) { // cycle chars of base64 text
    if (s == arr_symbol[j]) { // if temp string equal char of base64 text
 	  var k = j; // set current char's number
	  break; // exit from cycle
    } // if (s == arr_symbol[j])
  } // for (j = 0; j < len_symbol; ++j)
  
  if (k == -1) { // if current char's number was not founded in base64 text
	return ""; // exit
  } // if (k == -1)
  
  // change sentence words to real words
  if (arr_enveil[i] == "M-name") {
    veil_str = veil_str + " " + arr_noun_name_male[k];
  } // if (arr_enveil[i] == "M-name")
  if (arr_enveil[i] == "F-name") {
    veil_str = veil_str + " " + arr_noun_name_fem[k];
  } // if (arr_enveil[i] == "F-name")
  if (arr_enveil[i] == "adv") {
    veil_str = veil_str + " " + arr_adverb[k];
  } // if (arr_enveil[i] == "adv")
  if (arr_enveil[i] == "grnd") {
    veil_str = veil_str + " " + arr_gerund[k];
  } // if (arr_enveil[i] == "grnd")
  if (arr_enveil[i] == "vp2") {
    veil_str = veil_str + " " + arr_verb_part2[k];
  } // if (arr_enveil[i] == "vp2")
  if (arr_enveil[i] == "M-name's") {
    veil_str = veil_str + " " + arr_noun_name_male[k] + "'s";
  } // if (arr_enveil[i] == "M-name's")
  if (arr_enveil[i] == "F-name's") {
    veil_str = veil_str + " " + arr_noun_name_fem[k] + "'s";
  } // if (arr_enveil[i] == "F-name's")
  if (arr_enveil[i] == "noun") {
    veil_str = veil_str + " " + arr_noun_object[k];
  } // if (arr_enveil[i] == "noun")
  
  var m = m + 1; // increase veiltext word number
  var q = q + 1; // increase sentence word number
} // for (i = 0; i < arr_enveil.length; ++i)

//=============================================================================================

  // correct enveilized text
  var a = new Array(); // assign temp array
  var a = veil_str.split(""); // load chars of enveilized text to temp array

  // shift quotes to right near colons
  for (i = 1; i < a.length; ++i) { // cycle chars of enveilized text
    if (a[i] == "\"") { // if current char is quote
      if (a[i - 1] == ":") { // if previous char is colon
	    a[i] = " "; // set space to current char
		a[i + 1] = "\""; // set quote to next char
		var i = i + 2; // increase index of array with 2
	  } // if (a[i - 1] == ":")
	} // if (a[i] == "\"")
  } // for (i = 1; i < a.length; ++i)
  
  // remove spaces in begining of paragraphs
  for (i = 0; i < a.length; ++i) { // cycle chars of edited enveilized text
    if (a[i] == "\n") { // if current char is breakline
      if (a[i + 1] == " ") { // if next char is space
		a[i + 1] = ""; // clear next char
		var i = i + 2; // increase index of array with 2
	  } // if (a[i + 1] == " ")
	} // if (a[i] == "\n")
  } // for (i = 0; i < a.length; ++i)

//---------------------------------------------------------------------------------------------
  
  // rebuild enveilized text
  var veil_str = ""; // clear enveilized text
  for (i = 1; i < a.length; ++i) { // cycle chars of edited enveilized text
    var veil_str = veil_str + a[i]; // add char to enveilized text if not clear
  } // for (i = 1; i < a.length; ++i)
  
//=============================================================================================

  var text_result = text_result + veil_str; // add enveilized text to result text
  return text_result; // print result text
} // function func_enveil_eng(text_unveil, str_symbol)

//=============================================================================================
//=============================================================================================
//=============================================================================================

// deveil-eng.js
// Version: 2.13.6.14
// Author: VanDerSaAr
// License: MIT

function func_deveil_eng(text_enveil) {
  if (text_enveil.length == 0) { // if enveilized text is empty text
    return ""; // exit
  } // if (text_enveil.length == 0)

  var text_result = ""; // clear result text
  
//set symbol string base64+pad+space (standart/custom)
//var str_symbol = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=_";
  var str_symbol = "ABCDEFGH:JKLMN-PQRSTUVWXYZabcdefghijk;mnopqrstuvwxyz~!23456789.,=_";

  var arr_symbol = new Array(); // assign symbol string array
  var arr_symbol = str_symbol.split(""); // load chars to symbol string array

//=============================================================================================

var arr_word_14 = new Array(
"disappointedly");
var arr_word_13 = new Array(
"Christopher's", "distrustfully", "indifferently", "inoffencively");
var arr_word_12 = new Array(
"accidentally", "benevolently", "constraintly", "convincingly", "persuasively", "preventively");
var arr_word_11 = new Array(
"Alexander's", "Christian's", "Christopher", "Elizabeth's", "Valentina's", "cheerlessly", "difficultly", "emotionally", "exhaustedly", "frantically", "persistenly", "remembering", "sorrowfully", "tooth-brush", "unadvisedly", "uncertainly", "voluntarily");
var arr_word_10 = new Array(
"Angelina's", "Courtney's", "Gabriela's", "Isabella's", "Jennifer's", "Margaret's", "Patricia's", "Samantha's", "Victoria's", "accurately", "arrogantly", "carelessly", "cheerfully", "concealing", "fearlessly", "flashlight", "presenting", "recklessly", "remembered", "requesting", "restlessly", "trustfully");
var arr_word_9 = new Array(
"Abigail's", "Alexander", "Allison's", "Anthony's", "Barbara's", "Brandon's", "Carolyn's", "Charles's", "Christian", "Daniela's", "Darrell's", "Deborah's", "Dorothy's", "Elizabeth", "Jackson's", "Jasmine's", "Jeffrey's", "Jessica's", "Madison's", "Mariana's", "Matthew's", "Melissa's", "Michael's", "Patrick's", "Raymond's", "Richard's", "Sabrine's", "Valentina", "Valeria's", "William's", "acquiring", "attaching", "carefully", "certainly", "concealed", "fastening", "fineliner", "forgeting", "forgotten", "inspirely", "instantly", "joylessly", "malicious", "newspaper", "passionly", "presented", "prudently", "purposely", "receiving", "reminding", "replacing", "requested", "requiring", "returning", "skilfully", "squeezing", "telephone");
var arr_word_8 = new Array(
"Alexis's", "Alicia's", "Amanda's", "Andrew's", "Angela's", "Angelina", "Ashley's", "Audrey's", "Brenda's", "Camila's", "Courtney", "Daniel's", "Dennis's", "Edward's", "Gabriela", "Isabella", "Jayden's", "Jennifer", "Jeremy's", "Joseph's", "Justin's", "Margaret", "Martha's", "Olivia's", "Pamela's", "Patricia", "Rachel's", "Rebeca's", "Robert's", "Ronald's", "Samantha", "Sandra's", "Sharon's", "Sophia's", "Thomas's", "Victoria", "acquired", "admirely", "attached", "bringing", "clearing", "covering", "document", "fastened", "haughtly", "honestly", "joyfully", "lowering", "magazine", "matchbox", "modestly", "notebook", "offering", "painting", "pointing", "pressing", "received", "reminded", "replaced", "required", "retaking", "returned", "rotating", "scissors", "shifting", "speaking", "spoiling", "squeezed", "stealing", "sticking", "tenderly", "textbook", "throwing", "touching");
var arr_word_7 = new Array(
"Abigail", "Allison", "Anthony", "Barbara", "Betty's", "Brandon", "Brian's", "Bruce's", "Carolyn", "Charles", "Chloe's", "Clare's", "Daniela", "Darrell", "David's", "Deborah", "Dorothy", "Emily's", "Ethan's", "Fiona's", "Jackson", "Jacob's", "James's", "Janet's", "Jasmine", "Jason's", "Jeffrey", "Jerry's", "Jessica", "Julia's", "Karen's", "Kelly's", "Kevin's", "Larry's", "Laura's", "Linda's", "Logan's", "Lucas's", "Madison", "Maria's", "Mariana", "Mason's", "Matthew", "Melissa", "Michael", "Nancy's", "Patrick", "Peter's", "Raymond", "Richard", "Robin's", "Roger's", "Sabrine", "Sarah's", "Scott's", "Shyla's", "Steve's", "Susan's", "Terry's", "Tracy's", "Valeria", "William", "battery", "brought", "cleared", "compass", "covered", "drawing", "droping", "dropped", "finding", "gloomly", "hearing", "holding", "inanely", "journal", "keeping", "leaving", "lifting", "looking", "lowered", "merrily", "offered", "painted", "picking", "picture", "placing", "pointed", "pressed", "proudly", "pulling", "pushing", "quickly", "quietly", "rapidly", "retaken", "rotated", "roughly", "selling", "shaking", "shifted", "showing", "soiling", "swiftly", "tankard", "telling", "touched", "trinket", "turning", "validly", "wanting", "wishing");
var arr_word_6 = new Array(
"Alexis", "Alicia", "Amanda", "Andrew", "Angela", "Ashley", "Audrey", "Bill's", "Brad's", "Brenda", "Camila", "Carl's", "Dana's", "Daniel", "Dennis", "Edward", "Emma's", "Eric's", "Jack's", "Jayden", "Jeff's", "Jeremy", "John's", "Joseph", "Justin", "Katy's", "Kurt's", "Leah's", "Liam's", "Lisa's", "Martha", "Mary's", "Mike's", "Olivia", "Pamela", "Paul's", "Rachel", "Rebeca", "Rick's", "Robert", "Ronald", "Ryan's", "Sandra", "Sharon", "Sophia", "Thomas", "airily", "asking", "bottle", "bought", "button", "buying", "camera", "coming", "cookie", "easily", "eraser", "fearly", "fixing", "flower", "geting", "giving", "gladly", "hidden", "hiding", "jacket", "letter", "lifted", "looked", "losing", "mildly", "mirror", "moving", "neatly", "orange", "packet", "pencil", "picked", "placed", "player", "pulled", "pushed", "puting", "rudely", "saucer", "scotch", "seeing", "shaken", "slowly", "soiled", "spoilt", "stolen", "tablet", "taking", "thrown", "ticket", "tirely", "turned", "vainly", "wanted", "wiping", "wished");
var arr_word_5 = new Array(
"Ann's", "Ava's", "Betty", "Bob's", "Brian", "Bruce", "Chloe", "Clare", "David", "Emily", "Ethan", "Fiona", "Jacob", "James", "Janet", "Jason", "Jerry", "Jim's", "Joe's", "Julia", "Karen", "Kelly", "Kevin", "Larry", "Laura", "Linda", "Logan", "Lucas", "Maria", "Mason", "Nancy", "Peter", "Rob's", "Robin", "Roger", "Ron's", "Sam's", "Sarah", "Scott", "Shyla", "Steve", "Susan", "Ted's", "Terry", "Tom's", "Tracy", "apple", "asked", "brush", "camly", "chalk", "charm", "drown", "fixed", "found", "given", "glass", "going", "heard", "moved", "plate", "ruler", "sadly", "shown", "spoke", "spoon", "stamp", "stuck", "taken", "torch", "towel", "watch", "wiped");
var arr_word_4 = new Array(
"Bill", "Brad", "Carl", "Dana", "Emma", "Eric", "Jack", "Jeff", "John", "Katy", "Kurt", "Leah", "Liam", "Lisa", "Mary", "Mike", "Paul", "Rick", "Ryan", "bell", "book", "came", "clip", "coin", "comb", "disc", "fork", "gone", "held", "kept", "lamp", "left", "lost", "pear", "seen", "sold", "told", "tube");
var arr_word_3 = new Array(
"Ann", "Ava", "Bob", "Jim", "Joe", "Rob", "Ron", "Sam", "Ted", "Tom", "bag", "box", "cup", "got", "gum", "hat", "jar", "key", "mug", "pen", "put", "toy");

var arr_num_14 = new Array(
"15");
var arr_num_13 = new Array(
"12", "16", "28", "29");
var arr_num_12 = new Array(
"1", "5", "12", "13", "41", "42");
var arr_num_11 = new Array(
"0", "11", "12", "23", "64", "11", "14", "18", "19", "22", "40", "39", "56", "59", "61", "62", "65");
var arr_num_10 = new Array(
"7", "18", "27", "28", "30", "42", "51", "55", "65", "2", "4", "8", "10", "7", "20", "23", "33", "49", "39", "42", "50", "60");
var arr_num_9 = new Array(
"0", "0", "3", "2", "11", "6", "15", "10", "11", "19", "14", "22", "20", "23", "21", "31", "27", "32", "41", "44", "42", "47", "43", "45", "48", "50", "54", "64", "63", "65", "0", "2", "7", "9", "7", "11", "21", "14", "14", "31", "30", "33", "34", "38", "39", "33", "44", "45", "38", "40", "41", "42", "43", "45", "54", "55", "56");
var arr_num_8 = new Array(
"1", "2", "5", "1", "6", "7", "9", "4", "13", "14", "18", "13", "16", "17", "27", "28", "25", "30", "28", "33", "34", "42", "45", "49", "50", "51", "52", "53", "52", "56", "55", "56", "58", "60", "64", "65", "0", "0", "2", "3", "5", "8", "19", "11", "25", "26", "32", "26", "34", "35", "37", "39", "28", "29", "32", "34", "38", "40", "41", "43", "44", "45", "46", "50", "50", "53", "54", "55", "56", "57", "58", "57", "60", "61");
var arr_num_7 = new Array(
"0", "3", "2", "11", "12", "6", "7", "8", "15", "10", "16", "17", "19", "14", "15", "22", "20", "25", "19", "26", "21", "22", "23", "29", "31", "24", "27", "29", "32", "33", "34", "36", "35", "37", "37", "39", "39", "40", "41", "43", "44", "41", "42", "47", "43", "48", "45", "47", "48", "50", "53", "54", "54", "57", "59", "59", "60", "61", "62", "62", "63", "65", "2", "3", "5", "15", "8", "9", "10", "10", "12", "24", "18", "20", "27", "30", "21", "22", "23", "24", "26", "35", "28", "29", "30", "45", "31", "32", "34", "43", "35", "36", "46", "47", "48", "44", "46", "51", "48", "49", "50", "51", "52", "57", "55", "59", "61", "63", "62", "64", "63", "65");
var arr_num_6 = new Array(
"1", "2", "5", "1", "6", "9", "4", "3", "5", "13", "14", "9", "21", "13", "16", "17", "24", "18", "20", "25", "26", "28", "32", "33", "34", "35", "36", "38", "38", "40", "45", "46", "44", "49", "50", "46", "52", "53", "49", "52", "56", "57", "56", "58", "60", "64", "3", "1", "5", "4", "8", "4", "9", "6", "16", "17", "20", "21", "13", "22", "15", "16", "23", "19", "19", "28", "33", "23", "24", "25", "36", "36", "27", "38", "40", "41", "44", "30", "31", "47", "35", "36", "37", "52", "49", "51", "47", "49", "55", "52", "54", "56", "54", "58", "60", "58", "59", "62", "63", "63", "64", "65");
var arr_num_5 = new Array(
"8", "10", "12", "4", "7", "8", "16", "17", "15", "25", "19", "26", "22", "23", "29", "24", "29", "30", "31", "33", "34", "36", "35", "37", "37", "39", "39", "40", "43", "41", "48", "47", "51", "53", "54", "55", "58", "57", "59", "59", "60", "61", "61", "62", "63", "62", "0", "1", "7", "6", "10", "11", "9", "13", "12", "16", "25", "17", "18", "27", "46", "48", "53", "51", "53", "52", "53", "57", "58", "60", "61", "65", "64");
var arr_num_4 = new Array(
"3", "5", "9", "21", "24", "18", "20", "26", "32", "35", "36", "38", "38", "40", "46", "44", "46", "49", "57", "3", "4", "6", "12", "13", "14", "18", "24", "17", "20", "21", "32", "22", "25", "42", "47", "48", "59", "64");
var arr_num_3 = new Array(
"8", "10", "4", "30", "31", "51", "55", "58", "61", "63", "1", "6", "17", "15", "26", "27", "29", "31", "37", "43", "37", "62");

//=============================================================================================

var arr_enveil = new Array(); // assign enveilized text array
var arr_enveil = text_enveil.split(""); // load chars to enveilized text array

var text_enveil = ""; // clear enveilized text
var t = ""; // clear temp word

for (i = 0; i < arr_enveil.length; ++i) { // cycle chars of enveilized array
  var s = arr_enveil[i]; // set current char
  
  var b = false; // set mark for construct word
  if (s == " ") { var b = true; } // if this char is space then set mark for parse word
  if (b == false) { // if mark for construct word
    if (s == ".") { var b = true; } // if this char is dot then set mark for parse word
  } // if (b == false)
  if (b == false) { // if mark for construct word
    if (s == ",") { var b = true; } // if this char is comma then set mark for parse word
  } // if (b == false)
  if (b == false) { // if mark for construct word
    if (s == ":") { var b = true; } // if this char is colon then set mark for parse word
  } // if (b == false)
  if (b == false) { // if mark for construct word
    if (s == "!") { var b = true; } // if this char is exclam then set mark for parse word
  } // if (b == false)
  if (b == false) { // if mark for construct word
    if (s == "\"") { var b = true; } // if this char is quote then set mark for parse word
  } // if (b == false)
  if (b == false) { // if mark for construct word
    if (s == "\n") { var b = true; } // if this char is break then set mark for parse word
  } // if (b == false)
  
  if (b == false) { // if mark for construct word
    var t = t + s; // add current char to temp word
	continue; // go to next cycle
  } // if (b == false)
  
  if (t == "") { continue; } // if temp word is empty str then go to next cycle
 
  var k = t.length; // get length of temp word

//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  
  if (k == 3) { // if length of temp word equal this value
  var b = false; // set mark for search word
  if (b == false) { // if mark for search word
    if (t == "and") { var b = true; } // if this word then set mark for ignore word
  } // if (b == false)
  if (b == false) { // if mark for search word
    if (t == "And") { var b = true; } // if this word then set mark for ignore word
  } // if (b == false)
  if (b == false) { // if mark for search word
    if (t == "But") { var b = true; } // if this word then set mark for ignore word
  } // if (b == false)
  if (b == false) { // if mark for search word
    if (t == "has") { var b = true; } // if this word then set mark for ignore word
  } // if (b == false)
  if (b == false) { // if mark for search word
    if (t == "not") { var b = true; } // if this word then set mark for ignore word
  } // if (b == false)
  if (b == false) { // if mark for search word
    if (t == "The") { var b = true; } // if this word then set mark for ignore word
  } // if (b == false)
  if (b == false) { // if mark for search word
    if (t == "the") { var b = true; } // if this word then set mark for ignore word
  } // if (b == false)
  if (b == false) { // if mark for search word
    if (t == "why") { var b = true; } // if this word then set mark for ignore word
  } // if (b == false)
  if (b == false) { // if mark for search word
    if (t == "way") { var b = true; } // if this word then set mark for ignore word
  } // if (b == false)
  if (b == false) { // if mark for search word
    if (t == "saw") { var b = true; } // if this word then set mark for ignore word
  } // if (b == false)

  if (b == false) { // if mark for search word
  for (j = 0; j < arr_word_3.length; ++j) { // cycle words of core word array
	if (arr_word_3[j] == t) { // if core word equal temp word
	  var text_enveil = text_enveil + arr_symbol[arr_num_3[j]]; // add symbol to enveil text
	  break; // exit from cycle j
	} // if (arr_word_3[j] == t)
  } // for (j = 0; j < arr_word_3.length; ++j)
  } // if (b == false)
  } // if (k == x)
  
  if (k == 4) { // if length of temp word equal this value
  var b = false; // set mark for search word
  if (b == false) { // if mark for search word
    if (t == "Then") { var b = true; } // if this word then set mark for ignore word
  } // if (b == false)
  if (b == false) { // if mark for search word
    if (t == "That") { var b = true; } // if this word then set mark for ignore word
  } // if (b == false)
  if (b == false) { // if mark for search word
    if (t == "This") { var b = true; } // if this word then set mark for ignore word
  } // if (b == false)
  if (b == false) { // if mark for search word
    if (t == "have") { var b = true; } // if this word then set mark for ignore word
  } // if (b == false)
  if (b == false) { // if mark for search word
    if (t == "said") { var b = true; } // if this word then set mark for ignore word
  } // if (b == false)
  if (b == false) { // if mark for search word
    if (t == "that") { var b = true; } // if this word then set mark for ignore word
  } // if (b == false)

  if (b == false) { // if mark for search word
  for (j = 0; j < arr_word_4.length; ++j) { // cycle words of core word array
	if (arr_word_4[j] == t) { // if core word equal temp word
	  var text_enveil = text_enveil + arr_symbol[arr_num_4[j]]; // add symbol to enveil text
	  break; // exit from cycle j
	} // if (arr_word_4[j] == t)
  } // for (j = 0; j < arr_word_4.length; ++j)
  } // if (b == false)
  } // if (k == x)
  
  if (k == 5) { // if length of temp word equal this value
  var b = false; // set mark for search word
  if (b == false) { // if mark for search word
    if (t == "cried") { var b = true; } // if this word then set mark for ignore word
  } // if (b == false)
  if (b == false) { // if mark for search word
    if (t == "Later") { var b = true; } // if this word then set mark for ignore word
  } // if (b == false)
  if (b == false) { // if mark for search word
    if (t == "there") { var b = true; } // if this word then set mark for ignore word
  } // if (b == false)

  if (b == false) { // if mark for search word
  for (j = 0; j < arr_word_5.length; ++j) { // cycle words of core word array
	if (arr_word_5[j] == t) { // if core word equal temp word
	  var text_enveil = text_enveil + arr_symbol[arr_num_5[j]]; // add symbol to enveil text
	  break; // exit from cycle j
	} // if (arr_word_5[j] == t)
  } // for (j = 0; j < arr_word_5.length; ++j)
  } // if (b == false)
  } // if (k == x)
  
  if (k == 6) { // if length of temp word equal this value
  var b = false; // set mark for search word
  if (b == false) { // if mark for search word
    if (t == "hasn't") { var b = true; } // if this word then set mark for ignore word
  } // if (b == false)
  if (b == false) { // if mark for search word
    if (t == "course") { var b = true; } // if this word then set mark for ignore word
  } // if (b == false)

  if (b == false) { // if mark for search word
  for (j = 0; j < arr_word_6.length; ++j) { // cycle words of core word array
	if (arr_word_6[j] == t) { // if core word equal temp word
	  var text_enveil = text_enveil + arr_symbol[arr_num_6[j]]; // add symbol to enveil text
	  break; // exit from cycle j
	} // if (arr_word_6[j] == t)
  } // for (j = 0; j < arr_word_6.length; ++j)
  } // if (b == false)
  } // if (k == x)
  
  if (k == 7) { // if length of temp word equal this value
  var b = false; // set mark for search word
  if (b == false) { // if mark for search word
    if (t == "Further") { var b = true; } // if this word then set mark for ignore word
  } // if (b == false)
  if (b == false) { // if mark for search word
    if (t == "haven't") { var b = true; } // if this word then set mark for ignore word
  } // if (b == false)
  if (b == false) { // if mark for search word
    if (t == "because") { var b = true; } // if this word then set mark for ignore word
  } // if (b == false)

  if (b == false) { // if mark for search word
  for (j = 0; j < arr_word_7.length; ++j) { // cycle words of core word array
	if (arr_word_7[j] == t) { // if core word equal temp word
	  var text_enveil = text_enveil + arr_symbol[arr_num_7[j]]; // add symbol to enveil text
	  break; // exit from cycle j
	} // if (arr_word_7[j] == t)
  } // for (j = 0; j < arr_word_7.length; ++j)
  } // if (b == false)
  } // if (k == x)
  
  if (k == 8) { // if length of temp word equal this value
  var b = false; // set mark for search word
  if (b == false) { // if mark for search word
    if (t == "Suddenly") { var b = true; } // if this word then set mark for ignore word
  } // if (b == false)

  if (b == false) { // if mark for search word
  for (j = 0; j < arr_word_8.length; ++j) { // cycle words of core word array
	if (arr_word_8[j] == t) { // if core word equal temp word
	  var text_enveil = text_enveil + arr_symbol[arr_num_8[j]]; // add symbol to enveil text
	  break; // exit from cycle j
	} // if (arr_word_8[j] == t)
  } // for (j = 0; j < arr_word_8.length; ++j)
  } // if (b == false)
  } // if (k == x)
  
  if (k == 9) { // if length of temp word equal this value
  var b = false; // set mark for search word
  if (b == false) { // if mark for search word
    if (t == "therefore") { var b = true; } // if this word then set mark for ignore word
  } // if (b == false)

  if (b == false) { // if mark for search word
  for (j = 0; j < arr_word_9.length; ++j) { // cycle words of core word array
	if (arr_word_9[j] == t) { // if core word equal temp word
	  var text_enveil = text_enveil + arr_symbol[arr_num_9[j]]; // add symbol to enveil text
	  break; // exit from cycle j
	} // if (arr_word_9[j] == t)
  } // for (j = 0; j < arr_word_9.length; ++j)
  } // if (b == false)
  } // if (k == x)
  
  if (k == 10) { // if length of temp word equal this value
  var b = false; // set mark for search word
  if (b == false) { // if mark for search word
    if (t == "Afterwards") { var b = true; } // if this word then set mark for ignore word
  } // if (b == false)

  if (b == false) { // if mark for search word
  for (j = 0; j < arr_word_10.length; ++j) { // cycle words of core word array
	if (arr_word_10[j] == t) { // if core word equal temp word
	  var text_enveil = text_enveil + arr_symbol[arr_num_10[j]]; // add symbol to enveil text
	  break; // exit from cycle j
	} // if (arr_word_10[j] == t)
  } // for (j = 0; j < arr_word_10.length; ++j)
  } // if (b == false)
  } // if (k == x)
  
  if (k == 11) { // if length of temp word equal this value
  var b = false; // set mark for search word
  if (b == false) { // if mark for search word
    if (t == "instresting") { var b = true; } // if this word then set mark for ignore word
  } // if (b == false)

  if (b == false) { // if mark for search word
  for (j = 0; j < arr_word_11.length; ++j) { // cycle words of core word array
	if (arr_word_11[j] == t) { // if core word equal temp word
	  var text_enveil = text_enveil + arr_symbol[arr_num_11[j]]; // add symbol to enveil text
	  break; // exit from cycle j
	} // if (arr_word_11[j] == t)
  } // for (j = 0; j < arr_word_11.length; ++j)
  } // if (b == false)
  } // if (k == x)
  
  if (k == 12) { // if length of temp word equal this value
  var b = false; // set mark for search word
  if (b == false) { // if mark for search word
    if (t == "Unexpectedly") { var b = true; } // if this word then set mark for ignore word
  } // if (b == false)

  if (b == false) { // if mark for search word
  for (j = 0; j < arr_word_12.length; ++j) { // cycle words of core word array
	if (arr_word_12[j] == t) { // if core word equal temp word
	  var text_enveil = text_enveil + arr_symbol[arr_num_12[j]]; // add symbol to enveil text
	  break; // exit from cycle j
	} // if (arr_word_12[j] == t)
  } // for (j = 0; j < arr_word_12.length; ++j)
  } // if (b == false)
  } // if (k == x)
  
  if (k == 13) { // if length of temp word equal this value
  var b = false; // set mark for search word

  if (b == false) { // if mark for search word
  for (j = 0; j < arr_word_13.length; ++j) { // cycle words of core word array
	if (arr_word_13[j] == t) { // if core word equal temp word
	  var text_enveil = text_enveil + arr_symbol[arr_num_13[j]]; // add symbol to enveil text
	  break; // exit from cycle j
	} // if (arr_word_13[j] == t)
  } // for (j = 0; j < arr_word_13.length; ++j)
  } // if (b == false)
  } // if (k == x)
  
  if (k == 14) { // if length of temp word equal this value
  var b = false; // set mark for search word

  if (b == false) { // if mark for search word
  for (j = 0; j < arr_word_14.length; ++j) { // cycle words of core word array
	if (arr_word_14[j] == t) { // if core word equal temp word
	  var text_enveil = text_enveil + arr_symbol[arr_num_14[j]]; // add symbol to enveil text
	  break; // exit from cycle j
	} // if (arr_word_14[j] == t)
  } // for (j = 0; j < arr_word_14.length; ++j)
  } // if (b == false)
  } // if (k == x)
  
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  
  var t = ""; // clear temp word
} // for (i = 0; i < arr_enveil.length; ++i)

//=============================================================================================

  var text_result = text_result + text_enveil; // add enveilized text to result text
  return text_result; // print result text
} // function func_deveil_eng(text_enveil, str_symbol)

//=============================================================================================
