﻿<?php

/*=============================================================================================

VEIL-RUS (c)
Version: 2.13.6.14

Author: VanDerSaAr

Enveil-rus converts base64 text to random russian text with simple sentences. Deveil-rus
converts this generated russian text to base64-text. Enveilized text hides base64 text.

See example: http://cryptbb.site40.net/rus/

~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

License: MIT

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.
 
-----------------------------------------------------------------------------------------------

How to use:

<code>
<?php
$s = "ABC";
include("enveil-rus-2.13.6.14.php");
$s = func_enveil_rus($s);
echo "<P>This is enveilized text in russian language: " . $s;
include("deveil-rus-2.13.6.14.php");
$s = func_deveil_rus($s);
echo "<P>This is deveilized text in base64 code: " . $s;
?>
</code>

-----------------------------------------------------------------------------------------------

Changelog:
2013-06-14: Publicated first version.

*///===========================================================================================
#==============================================================================================
#==============================================================================================

// enveil-rus.php
// Version: 2.13.6.14
// Author: VanDerSaAr
// License: MIT

function func_enveil_rus($text_unveil) {
  if (mb_strlen($text_unveil, "utf8") == 0) { // if unveilized text is empty text
    return ""; // exit
  } // if (mb_strlen($text_unveil, "utf8") == 0)
  
  $text_result = ""; // clear result text
  
//set symbol string base64+pad+space (standart/custom)
//$str_symbol = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=_";
  $str_symbol = "ABCDEFGH:JKLMN-PQRSTUVWXYZabcdefghijk;mnopqrstuvwxyz~!23456789.,=_";
  
//=============================================================================================

$arr_noun_name_male_nom = array( // word noun, type name, gender male, case nominative
"Алексей",
"Лёша",
"Анатолий",
"Толя",
"Андрей",//
"Антон",
"Тоша",
"Артём",
"Тёма",
"Борис",
"Боря",
"Вадим",//
"Владимир",
"Вова",
"Владислав",
"Влад",
"Василий",
"Вася",
"Виктор",//
"Виталий",
"Витя",
"Вячеслав",
"Слава",
"Геннадий",
"Гена",
"Глеб",//
"Даниил",
"Даня",
"Денис",//
"Дмитрий",
"Дима",
"Захар",//
"Игорь",//
"Иван",
"Ваня",
"Илья",//
"Константин",
"Костя",
"Кирилл",//
"Леонид",
"Лёня",
"Максим",
"Макс",
"Михаил",
"Миша",
"Николай",
"Коля",
"Олег",//
"Павел",
"Паша",
"Пётр",
"Петя",
"Роман",
"Рома",
"Тарас",//
"Фёдор",
"Федя",
"Семён",
"Сеня",
"Сергей",
"Серёга",
"Степан",
"Стёпа",
"Эдуард",//
"Юрий",
"Юра"
); // $arr_noun_name_male_nom = array

$arr_noun_name_fem_nom = array( // word noun, type name, gender female, case nominative
"Александра",
"Саша",
"Алиса",//
"Алла",//
"Анастасия",
"Настя",
"Анна",//
"Валерия",
"Валя",
"Вероника",
"Вера",
"Виктория",
"Вика",
"Галина",
"Галя",
"Дарья",
"Даша",
"Диана",
"Дина",
"Евгения",
"Женя",
"Екатерина",
"Катя",
"Елена",
"Лена",
"Елизавета",
"Лиза",
"Зинаида",
"Зина",
"Зоя",//
"Инна",//
"Ирина",
"Ира",
"Ксения",
"Ксюша",
"Лариса",
"Лара",
"Лидия",
"Лида",
"Луиза",//
"Любовь",
"Люба",
"Людмила",
"Люда",
"Маргарита",
"Рита",
"Мария",
"Маша",
"Милана",
"Мила",
"Марина",//
"Надежда",
"Надя",
"Наталия",
"Наташа",
"Оксана",//
"Ольга",
"Оля",
"Полина",//
"Роза",//
"Светлана",
"Света",
"Татьяна",
"Таня",
"Юлия",
"Юля"
); // $arr_noun_name_fem_nom = array

$arr_verb_past_sing_male = array( // word verb, tense past, number singular, gender male
"бросил",
"взял",
"вернул",
"вспомнил",
"выбросил",
"выкинул",
"вынял",
"вытащил",
"вытер",
"дал",
"достал",
"забыл",
"заклеил",
"закрепил",
"захотел",
"кинул",
"купил",
"накрыл",
"нашёл",
"опустил",
"оставил",
"отдал",
"отобрал",
"отпустил",
"очистил",
"передал",
"переложил",
"переместил",
"подарил",
"подбросил",
"подержал",
"подкинул",
"поднял",
"пожелал",
"поискал",
"покрасил",
"показал",
"покрутил",
"положил",
"получил",
"посмотрел на",
"потерял",
"потребовал",
"потрогал",
"потряс",
"предложил",
"прижал",
"приклеил",
"прикрепил",
"принёс",
"принял",
"приобрёл",
"продал",
"попросил",
"спрятал",
"нарисовал",
"сжал",
"скрыл",
"убрал",
"увидел",
"указал на",
"украл",
"унёс",
"уронил",
"утаил",
"швырнул"
); // $arr_verb_past_sing_male = array

$arr_verb_past_sing_fem = array( // word verb, tense past, number singular, gender female
"бросила",
"взяла",
"вернула",
"вспомнила",
"выбросила",
"выкинула",
"выняла",
"вытащила",
"вытерла",
"дала",
"достала",
"забыла",
"заклеила",
"закрепила",
"захотела",
"кинула",
"купила",
"накрыла",
"нашла",
"опустила",
"оставила",
"отдала",
"отобрала",
"отпустила",
"очистила",
"передала",
"переложила",
"переместила",
"подарила",
"подбросила",
"подержала",
"подкинула",
"подняла",
"пожелала",
"поискала",
"покрасила",
"показала",
"покрутила",
"положила",
"получила",
"посмотрела на",
"потеряла",
"потребовала",
"потрогала",
"потрясла",
"предложила",
"прижала",
"приклеила",
"прикрепила",
"принесла",
"приняла",
"приобрела",
"продала",
"попросила",
"спрятала",
"нарисовала",
"сжала",
"скрыла",
"убрала",
"увидела",
"указала на",
"украла",
"унесла",
"уронила",
"утаила",
"швырнула"
); // $arr_verb_past_sing_fem = array

$arr_verb_past_plur = array( // word verb, tense past, number plural
"бросили",
"взяли",
"вернули",
"вспомнили",
"выбросили",
"выкинули",
"выняли",
"вытащили",
"вытерли",
"дали",
"достали",
"забыли",
"заклеили",
"закрепили",
"захотели",
"кинули",
"купили",
"накрыли",
"нашли",
"опустили",
"оставили",
"отдали",
"отобрали",
"отпустили",
"очистили",
"передали",
"переложили",
"переместили",
"подарили",
"подбросили",
"подержали",
"подкинули",
"подняли",
"пожелали",
"поискали",
"покрасили",
"показали",
"покрутили",
"положили",
"получили",
"посмотрели на",
"потеряли",
"потребовали",
"потрогали",
"потрясли",
"предложили",
"прижали",
"приклеили",
"прикрепили",
"принесли",
"приняли",
"приобрели",
"продали",
"попросили",
"спрятали",
"нарисовали",
"сжали",
"скрыли",
"убрали",
"увидели",
"указали на",
"украли",
"унесли",
"уронили",
"утаили",
"швырнули"
); // $arr_verb_past_plur = array

$arr_ger = array( // word gerund
"бросая",
"беря",
"возвращая",
"вспоминая",
"выбрасывая",
"выкидывая",
"вынимая",
"вытаскивая",
"вытирая",
"давая",
"доставая",
"забывая",
"заклеивая",
"закрепляя",
"хотя",
"кидая",
"покупая",
"накрывая",
"находя",
"опуская",
"оставляя",
"отдавая",
"отбирая",
"отпуская",
"очищая",
"передавая",
"перекладывая",
"перемещая",
"даря",
"подбрасывая",
"держа",
"подкидывая",
"поднимая",
"желая",
"ища",
"крася",
"показывая",
"крутя",
"кладя",
"получая",
"смотря на",
"теряя",
"требуя",
"трогая",
"тряся",
"предлагая",
"прижимая",
"приклеивая",
"прикрепляя",
"принося",
"принимая",
"приобретая",
"продавая",
"прося",
"пряча",
"рисуя",
"сжимая",
"скрывая",
"убирая",
"видя",
"указывая на",
"крадя",
"унося",
"роняя",
"утаивая",
"швыряя"
); // $arr_ger = array

$arr_adv = array( // word adverb
"аккуратно",
"акцентированно",
"безбоязненно",
"беззаботно",
"беззлобно",
"безобидно",
"безответственно",
"безрадостно",
"безразлично",
"безрассудно",
"безуспешно",
"беспечно",
"беспокойно",
"бессмысленно",
"бодро",
"боязненно",
"быстро",
"вдохновенно",
"весело",
"внимательно",
"восхищённо",
"вынужденно",
"глупо",
"гордо",
"громко",
"грубо",
"грустно",
"доверчиво",
"добровольно",
"доброжелательно",
"добросовестно",
"довольно",
"измождённо",
"легко",
"лениво",
"ловко",
"мастерски",
"медленно",
"мечтательно",
"молниеносно",
"мрачно",
"недоверчиво",
"недовольно",
"незаметно",
"неприметно",
"необдуманно",
"неуверенно",
"неумышленно",
"обоснованно",
"предупредительно",
"предусмотрительно",
"принуждённо",
"радостно",
"разочарованно",
"рассеянно",
"скромно",
"случайно",
"спокойно",
"старательно",
"тихо",
"тщетно",
"тяжело",
"уверенно",
"увлечённо",
"устало",
"эмоционально"
); // $arr_adv = array

$arr_noun_obj_acc = array( // word noun, type object, case accusative
"апельсин",
"банку",
"батарейку",
"билет",
"брелок",
"бутылку",
"вилку",
"газету",
"грушу",
"диск",
"документы",
"жвачку",
"журнал",
"зажигалку",
"зеркало",
"игрушку",
"карандаш",
"картину",
"кисточку",
"ключ",
"камеру",
"компас",
"конверт",
"коробку",
"книгу",
"кружку",
"куртку",
"ластик",
"лампу",
"линейку",
"ложку",
"маркер",
"монетку",
"ножницы",
"открывашку",
"пакет",
"печенье",
"письмо",
"платок",
"плеер",
"полотенце",
"пуговицу",
"расчёску",
"ручку",
"сигарету",
"скотч",
"скрепку",
"спички",
"стакан",
"степлер",
"сумку",
"таблетку",
"тарелку",
"телефон",
"тетрадь",
"тюбик",
"учебник",
"фломастер",
"фотоаппарат",
"фотографию",
"фонарик",
"часы",
"чашку",
"шапку",
"щётку",
"яблоко"
); // $arr_noun_obj_acc = array

$arr_noun_name_male_gen = array( // word noun, type name, gender male, case genitive
"Алексея",
"Лёши",
"Анатолия",
"Толи",
"Андрея",//
"Антона",
"Тоши",
"Артёма",
"Тёмы",
"Бориса",
"Бори",
"Вадима",//
"Владимира",
"Вовы",
"Владислава",
"Влада",
"Василия",
"Васи",
"Виктора",//
"Виталия",
"Вити",
"Вячеслава",
"Славы",
"Геннадия",
"Гены",
"Глеба",//
"Даниила",
"Дани",
"Дениса",//
"Дмитрия",
"Димы",
"Захара",//
"Игоря",//
"Ивана",
"Вани",
"Ильи",//
"Константина",
"Кости",
"Кирилла",//
"Леонида",
"Лёни",
"Максима",
"Макса",
"Михаила",
"Миши",
"Николая",
"Коли",
"Олега",//
"Павла",
"Паши",
"Петра",
"Пети",
"Романа",
"Ромы",
"Тараса",//
"Фёдора",
"Феди",
"Семёна",
"Сени",
"Сергея",
"Серёги",
"Степана",
"Стёпы",
"Эдуарда",//
"Юрия",
"Юры"
); // $arr_noun_name_male_gen = array

$arr_noun_name_fem_gen = array( // word noun, type name, gender female, case genitive
"Александры",
"Саши",
"Алисы",//
"Аллы",//
"Анастасии",
"Насти",
"Анны",//
"Валерии",
"Вали",
"Вероники",
"Веры",
"Виктории",
"Вики",
"Галины",
"Гали",
"Дарьи",
"Даши",
"Дианы",
"Дины",
"Евгении",
"Жени",
"Екатерины",
"Кати",
"Елены",
"Лены",
"Елизаветы",
"Лизы",
"Зинаиды",
"Зины",
"Зои",//
"Инны",//
"Ирины",
"Иры",
"Ксении",
"Ксюши",
"Ларисы",
"Лары",
"Лидии",
"Лиды",
"Луизы",//
"Любови",
"Любы",
"Людмилы",
"Люды",
"Маргариты",
"Риты",
"Марии",
"Маши",
"Миланы",
"Милы",
"Марины",//
"Надежды",
"Нади",
"Наталии",
"Наташи",
"Оксаны",//
"Ольги",
"Оли",
"Полины",//
"Розы",//
"Светланы",
"Светы",
"Татьяны",
"Тани",
"Юлии",
"Юли"
); // $arr_noun_name_fem_gen = array

//=============================================================================================

$snt_len_max = 8; // set max count of core words in sentence
$parag_word_count_min = 30; // set max word count for split text to paragraphs
	
//---------------------------------------------------------------------------------------------

$arr_snt_len_1 = array( // structure of sentence with 1 core word

"AndOr M-name M-wasThere .",
"AndOr F-name F-wasThere ."

); // $arr_snt_len_1 = array

//---------------------------------------------------------------------------------------------

$arr_snt_len_2 = array( // structure of sentence with 2 core words
	
"AndOr M-name notOr vpsm !",
"AndOr F-name notOr vpsf !"

); // $arr_snt_len_2 = array

//---------------------------------------------------------------------------------------------

$arr_snt_len_3 = array( // structure of sentence with 3 core words

"LaterOr M-name vpsm noun .",
"LaterOr F-name vpsf noun .",
"AndOr M-name notOr vpsm noun .",
"AndOr F-name notOr vpsf noun ."

); // $arr_snt_len_3 = array

//---------------------------------------------------------------------------------------------

$arr_snt_len_4 = array( // structure of sentence with 4 core words

"LaterOr M-name M-said \" F-name notOr vpsf noun ! \"",
"LaterOr F-name F-said \" M-name notOr vpsm noun ! \"",
"AndOr M-name M-said \" F-name notOr vpsf noun ! \"",
"AndOr F-name F-said \" M-name notOr vpsm noun ! \"",

"LaterOr M-name vpsm noun of-F-name .",
"LaterOr F-name vpsf noun of-M-name .",
"AndOr M-name notOr vpsm noun of-F-name .",
"AndOr F-name notOr vpsf noun of-M-name .",

"LaterOr M-name adv vpsm noun .",
"LaterOr F-name adv vpsf noun .",
"AndOr M-name notOr vpsm noun adv .",
"AndOr F-name notOr vpsf noun adv .",

"LaterOr M-name and F-name vpp noun .",
"LaterOr F-name and M-name vpp noun .",
"AndOr M-name and F-name notOr vpp noun .",
"AndOr F-name and M-name notOr vpp noun ."

); // $arr_snt_len_4 = array

//---------------------------------------------------------------------------------------------

$arr_snt_len_5 = array( // structure of sentence with 5 core words

"LaterOr M-name , ger noun , vpsm noun .",
"LaterOr F-name , ger noun , vpsf noun .",
"AndOr M-name , ger noun , vpsm noun .",
"AndOr F-name , ger noun , vpsf noun .",

"LaterOr M-name M-said \" F-name notOr vpsf noun of-M-name ! \"",
"LaterOr F-name F-said \" M-name notOr vpsm noun of-F-name ! \"",
"AndOr M-name M-said \" F-name notOr vpsf noun of-M-name ! \"",
"AndOr F-name F-said \" M-name notOr vpsm noun of-F-name ! \"",

"LaterOr M-name adv vpsm noun of-F-name .",
"LaterOr F-name adv vpsf noun of-M-name .",
"AndOr M-name notOr vpsm noun of-F-name adv .",
"AndOr F-name notOr vpsf noun of-M-name adv .",

"LaterOr M-name adv M-said \" F-name notOr vpsf noun ! \"",
"LaterOr F-name adv F-said \" M-name notOr vpsm noun ! \"",
"AndOr M-name adv M-said \" F-name notOr vpsf noun ! \"",
"AndOr F-name adv F-said \" M-name notOr vpsm noun ! \"",

"LaterOr M-name and F-name adv vpp noun .",
"LaterOr F-name and M-name adv vpp noun .",
"AndOr M-name and F-name notOr vpp noun adv .",
"AndOr F-name and M-name notOr vpp noun adv ."

); // $arr_snt_len_5 = array

//---------------------------------------------------------------------------------------------

$arr_snt_len_6 = array( // structure of sentence with 6 core words

"LaterOr M-name , ger noun , vpsm noun of-F-name .",
"LaterOr F-name , ger noun , vpsf noun of-M-name .",
"LaterOr M-name , ger noun of-F-name , vpsm noun .",
"LaterOr F-name , ger noun of-M-name , vpsf noun .",
"AndOr M-name , ger noun , vpsm noun of-F-name .",
"AndOr F-name , ger noun , vpsf noun of-M-name .",
"AndOr M-name , ger noun of-F-name , vpsm noun .",
"AndOr F-name , ger noun of-M-name , vpsf noun .",

"AndOr M-name vpsm noun , causeOr F-name notOr vpsf noun .",
"AndOr F-name vpsf noun , causeOr M-name notOr vpsm noun .",

"LaterOr M-name , ger noun , M-said \" F-name notOr vpsf noun ! \"",
"LaterOr F-name , ger noun , F-said \" M-name notOr vpsm noun ! \"",
"AndOr M-name , ger noun , M-said \" F-name notOr vpsf noun ! \"",
"AndOr F-name , ger noun , F-said \" M-name notOr vpsm noun ! \"",

"LaterOr M-name and F-name , ger noun , vpp noun .",
"LaterOr F-name and M-name , ger noun , vpp noun .",
"AndOr M-name and F-name , ger noun , notOr vpp noun .",
"AndOr F-name and M-name , ger noun , notOr vpp noun .",

"LaterOr M-name , adv ger noun , vpsm noun .",
"LaterOr F-name , adv ger noun , vpsf noun .",
"AndOr M-name , adv ger noun , notOr vpsm noun .",
"AndOr F-name , adv ger noun , notOr vpsf noun .",

"LaterOr M-name adv M-said \" F-name notOr vpsf noun of-M-name ! \"",
"LaterOr F-name adv F-said \" M-name notOr vpsm noun of-F-name ! \"",
"AndOr M-name adv M-said \" F-name notOr vpsf noun of-M-name ! \"",
"AndOr F-name adv F-said \" M-name notOr vpsm noun of-F-name ! \""

); // $arr_snt_len_6 = array

//---------------------------------------------------------------------------------------------

$arr_snt_len_7 = array( // structure of sentence with 7 core words

"LaterOr M-name , ger noun of-F-name , vpsm noun of-F-name .",
"LaterOr F-name , ger noun of-M-name , vpsf noun of-M-name .",
"AndOr M-name , ger noun of-F-name , notOr vpsm noun of-F-name .",
"AndOr F-name , ger noun of-M-name , notOr vpsf noun of-M-name .",

"AndOr M-name notOr vpsm noun , causeOr F-name notOr vpsf noun adv .",
"AndOr F-name notOr vpsf noun , causeOr M-name notOr vpsm noun adv .",
"AndOr M-name notOr vpsm noun adv , causeOr F-name notOr vpsf noun .",
"AndOr F-name notOr vpsf noun adv , causeOr M-name notOr vpsm noun .",

"AndOr M-name vpsm noun , causeOr F-name notOr vpsf noun of-M-name .",
"AndOr F-name vpsf noun , causeOr M-name notOr vpsm noun of-F-name .",
"AndOr M-name vpsm noun of-F-name , causeOr F-name notOr vpsf noun .",
"AndOr F-name vpsf noun of-M-name , causeOr M-name notOr vpsm noun .",

"AndOr M-name and F-name vpp noun , causeOr M-name vpsm noun .",
"AndOr F-name and M-name vpp noun , causeOr F-name vpsf noun .",

"LaterOr M-name , ger noun , M-said \" F-name notOr vpsf noun of-M-name ! \"",
"LaterOr F-name , ger noun , F-said \" M-name notOr vpsm noun of-F-name ! \"",
"AndOr M-name , ger noun , M-said \" F-name notOr vpsf noun of-M-name ! \"",
"AndOr F-name , ger noun , F-said \" M-name notOr vpsm noun of-F-name ! \"",
"LaterOr M-name , ger noun of-F-name , M-said \" F-name notOr vpsf noun ! \"",
"LaterOr F-name , ger noun of-M-name , F-said \" M-name notOr vpsm noun ! \"",
"AndOr M-name , ger noun of-F-name , M-said \" F-name notOr vpsf noun ! \"",
"AndOr F-name , ger noun of-M-name , F-said \" M-name notOr vpsm noun ! \"",

"LaterOr M-name , ger noun of-F-name , M-said \" F-name notOr vpsf noun ! \"",
"LaterOr F-name , ger noun of-M-name , F-said \" M-name notOr vpsm noun ! \"",
"AndOr M-name , ger noun of-F-name , M-said \" F-name notOr vpsf noun ! \"",
"AndOr F-name , ger noun of-M-name , F-said \" M-name notOr vpsm noun ! \"",

"LaterOr M-name , ger noun of-F-name , vpsm noun of-F-name .",
"LaterOr F-name , ger noun of-M-name , vpsf noun of-M-name .",
"AndOr M-name , ger noun of-F-name , notOr vpsm noun of-F-name .",
"AndOr F-name , ger noun of-M-name , notOr vpsf noun of-M-name .",

"LaterOr M-name and F-name , ger noun , vpp noun of-M-name .",
"LaterOr F-name and M-name , ger noun , vpp noun of-F-name .",
"AndOr M-name and F-name , ger noun , notOr vpp noun of-F-name .",
"AndOr F-name and M-name , ger noun , notOr vpp noun of-M-name .",
"LaterOr M-name and F-name , ger noun of-M-name , vpp noun .",
"LaterOr F-name and M-name , ger noun of-F-name , vpp noun .",
"AndOr M-name and F-name , ger noun of-M-name , notOr vpp noun .",
"AndOr F-name and M-name , ger noun of-F-name , notOr vpp noun .",

"LaterOr M-name , adv ger noun , vpsm noun of-F-name .",
"LaterOr F-name , adv ger noun , vpsf noun of-M-name .",
"AndOr M-name , adv ger noun , notOr vpsm noun of-F-name .",
"AndOr F-name , adv ger noun , notOr vpsf noun of-M-name .",
"LaterOr M-name , adv ger noun of-F-name , vpsm noun .",
"LaterOr F-name , adv ger noun of-M-name , vpsf noun .",
"AndOr M-name , adv ger noun of-F-name , notOr vpsm noun .",
"AndOr F-name , adv ger noun of-M-name , notOr vpsf noun ."

); // $arr_snt_len_7 = array

//---------------------------------------------------------------------------------------------

$arr_snt_len_8 = array( // structure of sentence with 8 core words

"AndOr M-name notOr vpsm noun of-F-name , causeOr F-name notOr vpsf noun of-M-name .",
"AndOr F-name notOr vpsf noun of-M-name , causeOr M-name notOr vpsm noun of-F-name .",

"AndOr M-name notOr vpsm noun , causeOr F-name notOr vpsf noun of-M-name adv .",
"AndOr F-name notOr vpsf noun , causeOr M-name notOr vpsm noun of-F-name adv .",
"AndOr M-name notOr vpsm noun of-M-name , causeOr F-name notOr vpsf noun adv .",
"AndOr F-name notOr vpsf noun of-M-name , causeOr M-name notOr vpsm noun adv .",

"AndOr M-name notOr vpsm noun adv , causeOr F-name notOr vpsf noun of-M-name .",
"AndOr F-name notOr vpsf noun adv , causeOr M-name notOr vpsm noun of-F-name .",
"AndOr M-name notOr vpsm noun of-M-name adv , causeOr F-name notOr vpsf noun .",
"AndOr F-name notOr vpsf noun of-M-name adv , causeOr M-name notOr vpsm noun .",

"AndOr M-name and F-name notOr vpp noun , causeOr M-name notOr vpsm noun of-F-name .",
"AndOr F-name and M-name notOr vpp noun , causeOr F-name notOr vpsf noun of-M-name .",
"AndOr M-name and F-name notOr vpp noun of-M-name , causeOr M-name notOr vpsm noun .",
"AndOr F-name and M-name notOr vpp noun of-F-name , causeOr F-name notOr vpsf noun .",

"AndOr M-name and F-name notOr vpp noun adv , causeOr M-name notOr vpsm noun .",
"AndOr F-name and M-name notOr vpp noun adv , causeOr F-name notOr vpsf noun .",
"AndOr M-name and F-name notOr vpp noun , causeOr M-name notOr vpsm noun adv .",
"AndOr F-name and M-name notOr vpp noun , causeOr F-name notOr vpsf noun adv .",

"LaterOr M-name , ger noun of-F-name , M-said \" F-name notOr vpsf noun of-M-name ! \"",
"LaterOr F-name , ger noun of-M-name , F-said \" M-name notOr vpsm noun of-F-name ! \"",
"AndOr M-name , ger noun of-F-name , M-said \" F-name notOr vpsf noun of-M-name ! \"",
"AndOr F-name , ger noun of-M-name , F-said \" M-name notOr vpsm noun of-F-name ! \"",

"LaterOr M-name , adv ger noun of-F-name , vpsm noun of-F-name .",
"LaterOr F-name , adv ger noun of-M-name , vpsf noun of-M-name .",
"AndOr M-name , adv ger noun of-F-name , notOr vpsm noun of-F-name .",
"AndOr F-name , adv ger noun of-M-name , notOr vpsf noun of-M-name .",
"LaterOr M-name , adv ger noun of-F-name , adv vpsm noun .",
"LaterOr F-name , adv ger noun of-M-name , adv vpsf noun .",
"AndOr M-name , adv ger noun of-F-name , notOr vpsm noun adv .",
"AndOr F-name , adv ger noun of-M-name , notOr vpsf noun adv .",

"LaterOr M-name and F-name , ger noun of-M-name , vpp noun of-M-name .",
"LaterOr F-name and M-name , ger noun of-F-name , vpp noun of-F-name .",
"AndOr M-name and F-name , ger noun of-M-name , notOr vpp noun of-M-name .",
"AndOr F-name and M-name , ger noun of-F-name , notOr vpp noun of-F-name .",

"LaterOr M-name and F-name , adv ger noun of-M-name , vpp noun .",
"LaterOr F-name and M-name , adv ger noun of-F-name , vpp noun .",
"AndOr M-name and F-name , adv ger noun of-M-name , notOr vpp noun .",
"AndOr F-name and M-name , adv ger noun of-F-name , notOr vpp noun .",
"LaterOr M-name and F-name , ger noun of-M-name , adv vpp noun .",
"LaterOr F-name and M-name , ger noun of-F-name , adv vpp noun .",
"AndOr M-name and F-name , ger noun of-M-name , notOr vpp noun adv .",
"AndOr F-name and M-name , ger noun of-F-name , notOr vpp noun adv .",

"LaterOr M-name , adv ger noun of-F-name , vpsm noun of-F-name .",
"LaterOr F-name , adv ger noun of-M-name , vpsf noun of-M-name .",
"AndOr M-name , adv ger noun of-F-name , notOr vpsm noun of-F-name .",
"AndOr F-name , adv ger noun of-M-name , notOr vpsf noun of-M-name .",

"LaterOr M-name , adv ger noun , adv vpsm noun of-F-name .",
"LaterOr F-name , adv ger noun , adv vpsf noun of-M-name .",
"AndOr M-name , adv ger noun , notOr vpsm noun of-F-name adv .",
"AndOr F-name , adv ger noun , notOr vpsf noun of-M-name adv ."

); // $arr_snt_len_8 = array

//=============================================================================================

$len_symbol = mb_strlen($str_symbol, "utf8"); // get symbol string's char count
$arr_symbol = array(); // assign symbol string array
$arr_symbol = str_split($str_symbol); // load chars to symbol string array

$len_unveil = mb_strlen($text_unveil, "utf8"); // get unveilized text's char count
$arr_unveil = array(); // assign unveilized text array
$arr_unveil = str_split($text_unveil); // load chars to unveilized text array

//---------------------------------------------------------------------------------------------

$veil_snt = "Begin"; // add begin to sentence text
$i = 0; // reset char index

while ($i < $len_unveil) { // cycle unveilized text's chars
  
  $snt_len_cur = mt_rand(0, ($snt_len_max - 2) - 1)
    + 3; // randomize core word count of current sentence
  if (($i + $snt_len_cur)
    > $len_unveil) { // if core word count exceed further unveilized text's core word count
    $snt_len_cur = $len_unveil - $i; // set word count of current sentence
  } // if (($i + $snt_len_cur) > $len_unveil)

//---------------------------------------------------------------------------------------------
 
  if ($snt_len_cur == 1) { // if word count of current sentence equal this value
    $m = mt_rand(0, count($arr_snt_len_1) - 1); // randomize type of sentence
    $veil_snt = $veil_snt . " " . $arr_snt_len_1[$m]; // set sentence text to temp string
  } // if ($snt_len_cur == 1)

  if ($snt_len_cur == 2) { // if word count of current sentence equal this value
    $m = mt_rand(0, count($arr_snt_len_2) - 1); // randomize type of sentence
    $veil_snt = $veil_snt . " " . $arr_snt_len_2[$m]; // set sentence text to temp string
  } // if ($snt_len_cur == 2)

  if ($snt_len_cur == 3) { // if word count of current sentence equal this value
    $m = mt_rand(0, count($arr_snt_len_3) - 1); // randomize type of sentence
    $veil_snt = $veil_snt . " " . $arr_snt_len_3[$m]; // set sentence text to temp string
  } // if ($snt_len_cur == 3)

  if ($snt_len_cur == 4) { // if word count of current sentence equal this value
    $m = mt_rand(0, count($arr_snt_len_4) - 1); // randomize type of sentence
    $veil_snt = $veil_snt . " " . $arr_snt_len_4[$m]; // set sentence text to temp string
  } // if ($snt_len_cur == 4)

  if ($snt_len_cur == 5) { // if word count of current sentence equal this value
    $m = mt_rand(0, count($arr_snt_len_5) - 1); // randomize type of sentence
    $veil_snt = $veil_snt . " " . $arr_snt_len_5[$m]; // set sentence text to temp string
  } // if ($snt_len_cur == 5)

  if ($snt_len_cur == 6) { // if word count of current sentence equal this value
    $m = mt_rand(0, count($arr_snt_len_6) - 1); // randomize type of sentence
    $veil_snt = $veil_snt . " " . $arr_snt_len_6[$m]; // set sentence text to temp string
  } // if ($snt_len_cur == 6)

  if ($snt_len_cur == 7) { // if word count of current sentence equal this value
    $m = mt_rand(0, count($arr_snt_len_7) - 1); // randomize type of sentence
    $veil_snt = $veil_snt . " " . $arr_snt_len_7[$m]; // set sentence text to temp string
  } // if ($snt_len_cur == 7)
  
  if ($snt_len_cur == 8) { // if word count of current sentence equal this value
    $m = mt_rand(0, count($arr_snt_len_8) - 1); // randomize type of sentence
    $veil_snt = $veil_snt . " " . $arr_snt_len_8[$m]; // set sentence text to temp string
  } // if ($snt_len_cur == 8)

//---------------------------------------------------------------------------------------------
  
  $i = $i + $snt_len_cur; // increase cycle index with core word count of current sentence
} // while ($i < $len_unveil)

$veil_snt = $veil_snt . " End"; // add end to sentence text

//=============================================================================================

$arr_enveil = array(); // assign sentence word array
$arr_enveil = explode(" ", $veil_snt); // load words from sentence text to sentence word array

$veil_str = ""; // clear enveilized text

$m = 0; // clear veiltext word number
$q = 0; // clear sentence word number

for ($i = 0; $i < count($arr_enveil); $i++) { // cycle sentence words of sentence text from 2nd
  if ($arr_enveil[$i] == ".") { // if current sentence word equal dot
    $veil_str = $veil_str . $arr_enveil[$i]; // add this word to enveilized text
	
    if ($q > $parag_word_count_min) { // if sentence word number more min paragraph word count
      if (mt_rand(0, 1) == 1) { // if random 50/50
	    $veil_str = $veil_str . "\n"; // add breakline to enveilized text
  	    $q = 0; // reset sentence word number
	  } // if (mt_rand(0, 1) == 1)
    } // if ($q > $parag_word_count_min)
	
	continue; // go to next sentence word of sentence text in cycle
  } // if ($arr_enveil[$i] == ".")
  
  if ($arr_enveil[$i] == ",") { // if current sentence word equal comma
    $veil_str = $veil_str . $arr_enveil[$i]; // add this word to enveilized text
	continue; // go to next sentence word of sentence text in cycle
  } // if ($arr_enveil[$i] == ",")
  if ($arr_enveil[$i] == "!") { // if current sentence word equal exclamation mark
    $veil_str = $veil_str . $arr_enveil[$i]; // add this word to enveilized text
	continue; // go to next sentence word of sentence text in cycle
  } // if ($arr_enveil[$i] == "!")
  if ($arr_enveil[$i] == "\"") { // if current sentence word equal quote
    $veil_str = $veil_str . $arr_enveil[$i]; // add this word to enveilized text
	continue; // go to next sentence word of sentence text in cycle
  } // if ($arr_enveil[$i] == "\"")

  if ($arr_enveil[$i] == "Begin") { // if current sentence word equal begin
    $n = mt_rand(0, 7); // randomize type of phrase
	if ($n == 0) { $veil_str = $veil_str . " " . "Потом было так."; }
	if ($n == 1) { $veil_str = $veil_str . " " . "Далее было интереснее."; }
	if ($n >= 2) {}
	continue; // go to next sentence word of sentence text in cycle
  } // if ($arr_enveil[$i] == "Begin")
  if ($arr_enveil[$i] == "End") { // if current sentence word equal end
    $n = mt_rand(0, 7); // randomize type of phrase
	if ($n == 0) { $veil_str = $veil_str . " " . "Вот было так."; }
	if ($n == 1) { $veil_str = $veil_str . " " . "Это было так."; }
	if ($n >= 2) {}
	continue; // go to next sentence word of sentence text in cycle
  } // if ($arr_enveil[$i] == "End")
  
  if ($arr_enveil[$i] == "and") { // if current sentence word equal this word
    $veil_str = $veil_str . " " . "и";
	continue; // go to next sentence word of sentence text in cycle
  } // if ($arr_enveil[$i] == "and")
  if ($arr_enveil[$i] == "AndOr") { // if current sentence word equal this word
    $n = mt_rand(0, 7); // randomize type of phrase
	if ($n == 0) { $veil_str = $veil_str . " " . "А"; }
	if ($n == 1) { $veil_str = $veil_str . " " . "Но"; }
	if ($n == 2) { $veil_str = $veil_str . " " . "И тогда"; }
	if ($n == 3) { $veil_str = $veil_str . " " . "Кстати,"; }
	if ($n == 4) { $veil_str = $veil_str . " " . "Разумеется,"; }
	if ($n >= 5) {}
	continue; // go to next sentence word of sentence text in cycle
  } // if ($arr_enveil[$i] == "AndOr")
  if ($arr_enveil[$i] == "LaterOr") { // if current sentence word equal this word
    $n = mt_rand(0, 7); // randomize type of phrase
	if ($n == 0) { $veil_str = $veil_str . " " . "Затем"; }
	if ($n == 1) { $veil_str = $veil_str . " " . "Позднее"; }
	if ($n == 2) { $veil_str = $veil_str . " " . "Далее"; }
	if ($n == 3) { $veil_str = $veil_str . " " . "После этого"; }
	if ($n == 4) { $veil_str = $veil_str . " " . "Неожиданно"; }
	if ($n == 5) { $veil_str = $veil_str . " " . "Внезапно"; }
	if ($n >= 6) {}
	continue; // go to next sentence word of sentence text in cycle
  } // if ($arr_enveil[$i] == "LaterOr")
  if ($arr_enveil[$i] == "causeOr") { // if current sentence word equal this word
    $n = mt_rand(0, 3); // randomize type of phrase
	if ($n == 0) { $veil_str = $veil_str . " " . "поэтому"; }
	if ($n == 1) { $veil_str = $veil_str . " " . "потому"; }
	if ($n >= 2) { $veil_str = $veil_str . " " . "потому что"; }
	continue; // go to next sentence word of sentence text in cycle
  } // if ($arr_enveil[$i] == "causeOr")
  
  if ($arr_enveil[$i] == "M-said") { // if current sentence word equal this word
    $n = mt_rand(0, 1); // randomize type of phrase
	if ($n == 0) { $veil_str = $veil_str . " " . "сказал:"; }
	if ($n == 1) { $veil_str = $veil_str . " " . "крикнул:"; }
	continue; // go to next sentence word of sentence text in cycle
  } // if ($arr_enveil[$i] == "M-said")
  if ($arr_enveil[$i] == "F-said") { // if current sentence word equal this word
    $n = mt_rand(0, 1); // randomize type of phrase
	if ($n == 0) { $veil_str = $veil_str . " " . "сказала:"; }
	if ($n == 1) { $veil_str = $veil_str . " " . "крикнула:"; }
	continue; // go to next sentence word of sentence text in cycle
  } // if ($arr_enveil[$i] == "F-said")
  if ($arr_enveil[$i] == "notOr") { // if current sentence word equal this word
    $n = mt_rand(0, 1); // randomize type of phrase
	if ($n == 0) { $veil_str = $veil_str . " " . "не"; }
	if ($n == 1) {}
	continue; // go to next sentence word of sentence text in cycle
  } // if ($arr_enveil[$i] == "notOr")

  if ($arr_enveil[$i] == "M-wasThere") { // if current sentence word equal this word
    $n = mt_rand(0, 1); // randomize type of phrase
	if ($n == 0) { $veil_str = $veil_str . " " . "был там"; }
	if ($n == 1) { $veil_str = $veil_str . " " . "это видел"; }
	continue; // go to next sentence word of sentence text in cycle
  } // if ($arr_enveil[$i] == "M-wasThere")
  if ($arr_enveil[$i] == "F-wasThere") { // if current sentence word equal this word
    $n = mt_rand(0, 1); // randomize type of phrase
	if ($n == 0) { $veil_str = $veil_str . " " . "была там"; }
	if ($n == 1) { $veil_str = $veil_str . " " . "это видела"; }
	continue; // go to next sentence word of sentence text in cycle
  } // if ($arr_enveil[$i] == "F-wasThere")
  
//---------------------------------------------------------------------------------------------
  
  $s = $arr_unveil[$m]; // set current char of unveilized text array to temp string  
  $k = -1; // reset current char's number in base64 text
  
  for ($j = 0; $j < $len_symbol; $j++) { // cycle chars of base64 text
    if ($s == $arr_symbol[$j]) { // if temp string equal char of base64 text
 	  $k = $j; // set current char's number
	  break; // exit from cycle
    } // if ($s == $arr_symbol[$j])
  } // for ($j = 0; $j < $len_symbol; $j++)
  
  if ($k == -1) { // if current char's number was not founded in base64 text
	return ""; // exit
  } // if ($k == -1)
  
  // change sentence words to real words
  if ($arr_enveil[$i] == "M-name") {
    $veil_str = $veil_str . " " . $arr_noun_name_male_nom[$k];
  } // if ($arr_enveil[$i] == "M-name")
  if ($arr_enveil[$i] == "F-name") {
    $veil_str = $veil_str . " " . $arr_noun_name_fem_nom[$k];
  } // if ($arr_enveil[$i] == "F-name")
  if ($arr_enveil[$i] == "adv") {
    $veil_str = $veil_str . " " . $arr_adv[$k];
  } // if ($arr_enveil[$i] == "adv")
  if ($arr_enveil[$i] == "ger") {
    $veil_str = $veil_str . " " . $arr_ger[$k];
  } // if ($arr_enveil[$i] == "ger")
  if ($arr_enveil[$i] == "vpsm") {
    $veil_str = $veil_str . " " . $arr_verb_past_sing_male[$k];
  } // if ($arr_enveil[$i] == "vpsm")
  if ($arr_enveil[$i] == "vpsf") {
    $veil_str = $veil_str . " " . $arr_verb_past_sing_fem[$k];
  } // if ($arr_enveil[$i] == "vpsf")
  if ($arr_enveil[$i] == "vpp") {
    $veil_str = $veil_str . " " . $arr_verb_past_plur[$k];
  } // if ($arr_enveil[$i] == "vpp")
  if ($arr_enveil[$i] == "noun") {
    $veil_str = $veil_str . " " . $arr_noun_obj_acc[$k];
  } // if ($arr_enveil[$i] == "noun")
  if ($arr_enveil[$i] == "of-M-name") {
    $veil_str = $veil_str . " " . $arr_noun_name_male_gen[$k];
  } // if ($arr_enveil[$i] == "of-M-name")
  if ($arr_enveil[$i] == "of-F-name") {
    $veil_str = $veil_str . " " . $arr_noun_name_fem_gen[$k];
  } // if ($arr_enveil[$i] == "of-F-name")
  
  $m = $m + 1; // increase veiltext word number
  $q = $q + 1; // increase sentence word number
} // for ($i = 0; $i < count($arr_enveil); $i++)

//=============================================================================================

  // correct enveilized text
  $a = array(); // assign temp array
  $a = str_split($veil_str); // load chars of enveilized text to temp array

  // shift quotes to right near colons
  for ($i = 1; $i < count($a); $i++) { // cycle chars of enveilized text
    if ($a[$i] == "\"") { // if current char is quote
      if ($a[$i - 1] == ":") { // if previous char is colon
	    $a[$i] = " "; // set space to current char
		$a[$i + 1] = "\""; // set quote to next char
		$i = $i + 2; // increase index of array with 2
	  } // if ($a[$i - 1] == ":")
	} // if ($a[$i] == "\"")
  } // for ($i = 1; $i < count($a); $i++)
  
  // remove spaces in begining of paragraphs
  for ($i = 0; $i < count($a); $i++) { // cycle chars of edited enveilized text
    if ($a[$i] == "\n") { // if current char is breakline
      if ($a[$i + 1] == " ") { // if next char is space
		$a[$i + 1] = ""; // clear next char
		$i = $i + 2; // increase index of array with 2
	  } // if ($a[$i + 1] == " ")
	} // if ($a[$i] == "\n")
  } // for ($i = 0; $i < count($a); $i++)

//---------------------------------------------------------------------------------------------
  
  // rebuild enveilized text
  $veil_str = ""; // clear enveilized text
  for ($i = 1; $i < count($a); $i++) { // cycle chars of edited enveilized text
    $veil_str = $veil_str . $a[$i]; // add char to enveilized text if not clear
  } // for ($i = 1; $i < count($a); $i++)
  
//=============================================================================================
  
  $text_result = $text_result . $veil_str; // add enveilized text to result text
  return $text_result; // print result text
} // function func_enveil_rus($text_unveil)

#==============================================================================================
#==============================================================================================
#==============================================================================================

?>
