<?php

/*=============================================================================================

VEIL-ENG (c)
Version: 3.14.2.1

Author: VanDerSaAr

Enveil-eng converts base64 text to random english text with simple sentences. Deveil-eng
converts this generated english text to base64-text. Enveilized text hides base64 text.

See example: http://cryptbb.site40.net

~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

License: MIT

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.
 
-----------------------------------------------------------------------------------------------

How to use:

<code>
<?php
$s = "ABC";
include("enveil-eng-3.14.2.1.php");
$s = func_enveil_eng($s);
echo "<P>This is enveilized text in english language: " . $s;
include("deveil-eng-3.14.2.1.php");
$s = func_deveil_eng($s);
echo "<P>This is deveilized text in base64 code: " . $s;
?>
</code>

-----------------------------------------------------------------------------------------------

Changelog:
2014-02-01: Removed some commas in sentenses.
2013-06-14: Publicated first version.

*///===========================================================================================
#==============================================================================================
#==============================================================================================

// enveil-eng.php
// Version: 3.14.2.1
// Author: VanDerSaAr
// License: MIT

function func_enveil_eng($text_unveil) {
  if (mb_strlen($text_unveil, "utf8") == 0) { // if unveilized text is empty text
    return ""; // exit
  } // if (mb_strlen($text_unveil, "utf8") == 0)
  
  $text_result = ""; // clear result text
  
//set symbol string base64+pad+space (standart/custom)
//$str_symbol = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=_";
  $str_symbol = "ABCDEFGH:JKLMN-PQRSTUVWXYZabcdefghijk;mnopqrstuvwxyz~!23456789.,=_";
  
//=============================================================================================

$arr_noun_name_male = array( // word noun, type name
"Alexander",
"Andrew",
"Anthony",
"Bill",
"Bob",
"Brad",
"Brandon",
"Brian",
"Bruce",
"Carl",
"Charles",
"Christian",
"Christopher",
"Daniel",
"Darrell",
"David",
"Dennis",
"Edward",
"Eric",
"Ethan",
"Jack",
"Jackson",
"Jacob",
"James",
"Jason",
"Jayden",
"Jeff",
"Jeffrey",
"Jeremy",
"Jerry",
"Jim",
"Joe",
"John",
"Joseph",
"Justin",
"Kevin",
"Kurt",
"Larry",
"Liam",
"Logan",
"Lucas",
"Mason",
"Matthew",
"Michael",
"Mike",
"Patrick",
"Paul",
"Peter",
"Raymond",
"Rick",
"Richard",
"Rob",
"Robert",
"Robin",
"Roger",
"Ron",
"Ronald",
"Ryan",
"Sam",
"Scott",
"Steve",
"Ted",
"Terry",
"Tom",
"Thomas",
"William"
); // $arr_noun_name_male = array

$arr_noun_name_fem = array( // word noun, type name
"Abigail",
"Alexis",
"Alicia",
"Allison",
"Audrey",
"Amanda",
"Angela",
"Angelina",
"Ann",
"Ashley",
"Ava",
"Barbara",
"Betty",
"Brenda",
"Camila",
"Carolyn",
"Chloe",
"Clare",
"Courtney",
"Daniela",
"Dorothy",
"Dana",
"Deborah",
"Elizabeth",
"Emma",
"Emily",
"Fiona",
"Gabriela",
"Isabella",
"Janet",
"Jennifer",
"Jasmine",
"Jessica",
"Julia",
"Karen",
"Katy",
"Kelly",
"Laura",
"Leah",
"Linda",
"Lisa",
"Madison",
"Margaret",
"Maria",
"Mariana",
"Martha",
"Mary",
"Melissa",
"Nancy",
"Olivia",
"Pamela",
"Patricia",
"Rachel",
"Rebeca",
"Sabrine",
"Samantha",
"Sandra",
"Sarah",
"Sharon",
"Shyla",
"Sophia",
"Susan",
"Tracy",
"Valeria",
"Valentina",
"Victoria"
); // $arr_noun_name_fem = array

$arr_verb_part2 = array( // word verb, tense participle 2
"acquired",
"asked about",
"attached",
"brought",
"bought",
"cleared",
"came with",
"concealed",
"covered",
"drown",
"dropped",
"fastened",
"found",
"fixed",
"forgotten",
"got",
"given",
"gone with",
"heard about",
"hidden",
"held",
"kept",
"left",
"lifted",
"looked for",
"lost",
"lowered",
"moved",
"offered",
"painted",
"picked up",
"placed",
"pointed to",
"presented",
"pressed",
"pulled out",
"pushed",
"put",
"received",
"remembered",
"reminded of",
"replaced",
"requested",
"required",
"retaken",
"returned",
"rotated",
"seen",
"sold",
"shaken",
"shifted",
"shown",
"soiled",
"spoke about",
"spoilt",
"squeezed",
"stolen",
"stuck",
"taken",
"told about",
"thrown",
"touched",
"turned",
"wanted",
"wiped",
"wished"
); // $arr_verb_part2 = array

$arr_gerund = array( // word gerund
"acquiring",
"asking about",
"attaching",
"bringing",
"buying",
"clearing",
"coming with",
"concealing",
"covering",
"drawing",
"droping",
"fastening",
"finding",
"fixing",
"forgeting",
"geting",
"giving",
"going with",
"hearing about",
"hiding",
"holding",
"keeping",
"leaving",
"lifting",
"looking for",
"losing",
"lowering",
"moving",
"offering",
"painting",
"picking up",
"placing",
"pointing to",
"presenting",
"pressing",
"pulling out",
"pushing",
"puting",
"receiving",
"remembering",
"reminding of",
"replacing",
"requesting",
"requiring",
"retaking",
"returning",
"rotating",
"seeing",
"selling",
"shaking",
"shifting",
"showing",
"soiling",
"speaking about",
"spoiling",
"squeezing",
"stealing",
"sticking",
"taking",
"telling about",
"throwing",
"touching",
"turning",
"wanting",
"wiping",
"wishing"
); // $arr_gerund = array

$arr_adverb = array( // word adverb
"admirely",//voshischionno
"accidentally",//sluchayno
"accurately",//akkuratno
"airily",//bezzabotno
"arrogantly",//vysokomerno
"benevolently",//dobrozhelatelno
"camly",//spokoyno
"carefully",//staratelno
"carelessly",//bespechno
"certainly",//uverenno
"cheerfully",//bodro
"cheerlessly",//bezradostno
"constraintly",//prinuzhdionno
"convincingly",//ubeditelno
"difficultly",//tiazhelo
"disappointedly",//razocharovanno
"distrustfully",//nedoverchivo
"easily",//legko
"emotionally",//emotsionalno
"exhaustedly",//izmozhdionno
"fearlessly",//bezboyaznenno
"fearly",//boyaznenno
"frantically",//neistovo
"gladly",//dovolno
"gloomly",//mrachno
"haughtly",//vysokomerno
"honestly",//dobrosovestno
"inanely",//bessmyslenno
"indifferently",//bezrazlichno
"inoffencively",//bezobidno
"instantly",//nemedlenno
"inspirely",//vdohnovenno
"joyfully",//radostno
"joylessly",//bezradostno
"malicious",//zlobno
"merrily",//veselo
"mildly",//bezzlobno
"modestly",//skromno
"neatly",//lovko
"passionly",//uvlechionno
"persistenly",//uporno
"persuasively",//ubeditelno
"preventively",//predupreditelno
"proudly",//gordo
"prudently",//predusmotritelno
"purposely",//umyshlenno
"quickly",//bystro
"quietly",//spokoyno
"rapidly",//bystro
"recklessly",//bezrassudno
"restlessly",//bespokoyno
"roughly",//grubo
"rudely",//grubo
"sadly",//grustno
"skilfully",//masterski
"slowly",//medlenno
"sorrowfully",//grustno
"swiftly",//bystro
"tenderly",//nezhno
"tirely",//ustalo
"trustfully",//doverchivo
"unadvisedly",//neobdumanno
"uncertainly",//neuverenno
"vainly",//tschetno
"validly",//obosnovanno
"voluntarily"//dobrovolno
); // $arr_adverb = array

$arr_noun_object = array( // word noun, type object
"apple",//yabloko
"bag",//sumka
"battery",//batareyka
"bell",//kolokolchik
"book",//kniga
"bottle",//butylka
"box",//korobka
"brush",//kistochka
"button",//pugovitsa
"camera",//fotokamera
"chalk",//melok
"charm",//brelok
"clip",//skrepka
"coin",//monetka
"comb",//raschioska
"compass",//kompas
"cookie",//pechenye
"cup",//chashka
"disc",//disk
"document",//dokument
"eraser",//lastik
"fineliner",//marker
"flower",//tsvetok
"flashlight",//fonarik
"fork",//vilka
"glass",//stakan
"gum",//zhvachka
"hat",//shapka
"jacket",//kurtka
"jar",//banka
"journal",//zhurnal
"key",//kliuch
"lamp",//lampa
"letter",//pismo
"magazine",//zhurnal
"matchbox",//spichechnyy-korobok
"mirror",//zerkalo
"mug",//kruzhka
"newspaper",//gazeta
"notebook",//tetrad
"orange",//apelsin
"packet",//paket
"pear",//grusha
"pen",//ruchka
"pencil",//karandash
"picture",//kartina
"plate",//tarelka
"player",//pleyer
"ruler",//lineyka
"saucer",//bliudtse
"scissors",//nozhnitsy
"scotch tape",//skotch
"spoon",//lozhka
"stamp",//marka
"tablet",//tabletka
"tankard",//metallicheskaya-kruzhka
"telephone",//telefon
"textbook",//uchebnik
"ticket",//bilet
"tooth-brush",//zubnaya-schiotka
"torch",//fonarik
"towel",//polotentse
"toy",//igrushka
"trinket",//brelok
"tube",//tiubik
"watch"//chasy
); // $arr_noun_object = array

//=============================================================================================

$snt_len_max = 8; // set max count of core words in sentence
$parag_word_count_min = 30; // set max word count for split text to paragraphs
	
//---------------------------------------------------------------------------------------------

$arr_snt_len_1 = array( // structure of sentence with 1 core word

"AndOr M-name wasThere .",
"AndOr F-name wasThere ."

); // $arr_snt_len_1 = array

//---------------------------------------------------------------------------------------------

$arr_snt_len_2 = array( // structure of sentence with 2 core words
	
"AndOr M-name hasOr vp2 !",
"AndOr F-name hasOr vp2 !"

); // $arr_snt_len_2 = array

//---------------------------------------------------------------------------------------------

$arr_snt_len_3 = array( // structure of sentence with 3 core words

"LaterOr M-name has vp2 the noun .",
"LaterOr F-name has vp2 the noun .",
"AndOr M-name hasOr vp2 the noun .",
"AndOr F-name hasOr vp2 the noun ."

); // $arr_snt_len_3 = array

//---------------------------------------------------------------------------------------------

$arr_snt_len_4 = array( // structure of sentence with 4 core words

"LaterOr M-name said \" F-name has vp2 the noun ! \"",
"LaterOr F-name said \" M-name has vp2 the noun ! \"",
"AndOr M-name said \" F-name has vp2 the noun ! \"",
"AndOr F-name said \" M-name has vp2 the noun ! \"",

"LaterOr M-name has vp2 F-name's noun .",
"LaterOr F-name has vp2 M-name's noun .",
"AndOr M-name hasOr vp2 F-name's noun .",
"AndOr F-name hasOr vp2 M-name's noun .",

"LaterOr M-name adv has vp2 the noun .",
"LaterOr F-name adv has vp2 the noun .",
"AndOr M-name hasOr vp2 the noun adv .",
"AndOr F-name hasOr vp2 the noun adv .",

"LaterOr M-name and F-name have vp2 the noun .",
"LaterOr F-name and M-name have vp2 the noun .",
"AndOr M-name and F-name haveOr vp2 the noun .",
"AndOr F-name and M-name haveOr vp2 the noun ."

); // $arr_snt_len_4 = array

//---------------------------------------------------------------------------------------------

$arr_snt_len_5 = array( // structure of sentence with 5 core words

"LaterOr M-name grnd the noun has vp2 the noun .",
"LaterOr F-name grnd the noun has vp2 the noun .",
"AndOr M-name grnd the noun hasOr vp2 the noun .",
"AndOr F-name grnd the noun hasOr vp2 the noun .",

"LaterOr M-name said \" F-name has vp2 M-name's noun ! \"",
"LaterOr F-name said \" M-name has vp2 F-name's noun ! \"",
"AndOr M-name said \" F-name has vp2 M-name's noun ! \"",
"AndOr F-name said \" M-name has vp2 F-name's noun ! \"",

"LaterOr M-name adv has vp2 F-name's noun .",
"LaterOr F-name adv has vp2 M-name's noun .",
"AndOr M-name hasOr vp2 F-name's noun adv .",
"AndOr F-name hasOr vp2 M-name's noun adv .",

"LaterOr M-name adv said \" F-name has vp2 the noun ! \"",
"LaterOr F-name adv said \" M-name has vp2 the noun ! \"",
"AndOr M-name adv said \" F-name has vp2 the noun ! \"",
"AndOr F-name adv said \" M-name has vp2 the noun ! \"",

"LaterOr M-name and F-name adv have vp2 the noun .",
"LaterOr F-name and M-name adv have vp2 the noun .",
"AndOr M-name and F-name haveOr vp2 the noun adv .",
"AndOr F-name and M-name haveOr vp2 the noun adv ."

); // $arr_snt_len_5 = array

//---------------------------------------------------------------------------------------------

$arr_snt_len_6 = array( // structure of sentence with 6 core words

"LaterOr M-name grnd the noun has vp2 F-name's noun .",
"LaterOr F-name grnd the noun has vp2 M-name's noun .",
"LaterOr M-name grnd F-name's noun has vp2 the noun .",
"LaterOr F-name grnd M-name's noun has vp2 the noun .",
"AndOr M-name grnd the noun hasOr vp2 F-name's noun .",
"AndOr F-name grnd the noun hasOr vp2 M-name's noun .",
"AndOr M-name grnd F-name's noun hasOr vp2 the noun .",
"AndOr F-name grnd M-name's noun hasOr vp2 the noun .",

"AndOr M-name hasOr vp2 the noun , causeOr F-name hasOr vp2 the noun .",
"AndOr F-name hasOr vp2 the noun , causeOr M-name hasOr vp2 the noun .",
  
"LaterOr M-name grnd the noun said \" F-name has vp2 the noun ! \"",
"LaterOr F-name grnd the noun said \" M-name has vp2 the noun ! \"",
"AndOr M-name grnd the noun said \" F-name has vp2 the noun ! \"",
"AndOr F-name grnd the noun said \" M-name has vp2 the noun ! \"",

"LaterOr M-name and F-name grnd the noun have vp2 the noun .",
"LaterOr F-name and M-name grnd the noun have vp2 the noun .",
"AndOr M-name and F-name grnd the noun haveOr vp2 the noun .",
"AndOr F-name and M-name grnd the noun haveOr vp2 the noun .",

"LaterOr M-name adv grnd the noun has vp2 the noun .",
"LaterOr F-name adv grnd the noun has vp2 the noun .",
"AndOr M-name adv grnd the noun hasOr vp2 the noun .",
"AndOr F-name adv grnd the noun hasOr vp2 the noun .",
  
"LaterOr M-name adv said \" F-name has vp2 M-name's noun ! \"",
"LaterOr F-name adv said \" M-name has vp2 F-name's noun ! \"",
"AndOr M-name adv said \" F-name has vp2 M-name's noun ! \"",
"AndOr F-name adv said \" M-name has vp2 F-name's noun ! \""

); // $arr_snt_len_6 = array

//---------------------------------------------------------------------------------------------

$arr_snt_len_7 = array( // structure of sentence with 7 core words

"LaterOr M-name grnd F-name's noun has vp2 F-name's noun .",
"LaterOr F-name grnd M-name's noun has vp2 M-name's noun .",
"AndOr M-name grnd F-name's noun hasOr vp2 F-name's noun .",
"AndOr F-name grnd M-name's noun hasOr vp2 M-name's noun .",

"AndOr M-name hasOr vp2 the noun , causeOr F-name hasOr vp2 the noun adv .",
"AndOr F-name hasOr vp2 the noun , causeOr M-name hasOr vp2 the noun adv .",
"AndOr M-name hasOr vp2 the noun adv , causeOr F-name hasOr vp2 the noun .",
"AndOr F-name hasOr vp2 the noun adv , causeOr M-name hasOr vp2 the noun .",

"AndOr M-name hasOr vp2 the noun , causeOr F-name hasOr vp2 M-name's noun .",
"AndOr F-name hasOr vp2 the noun , causeOr M-name hasOr vp2 F-name's noun .",
"AndOr M-name hasOr vp2 F-name's noun , causeOr F-name hasOr vp2 the noun .",
"AndOr F-name hasOr vp2 M-name's noun , causeOr M-name hasOr vp2 the noun .",

"AndOr M-name and F-name haveOr vp2 the noun , causeOr M-name hasOr vp2 the noun .",
"AndOr F-name and M-name haveOr vp2 the noun , causeOr F-name hasOr vp2 the noun .",

"LaterOr M-name grnd the noun said \" F-name has vp2 M-name's noun ! \"",
"LaterOr F-name grnd the noun said \" M-name has vp2 F-name's noun ! \"",
"AndOr M-name grnd the noun said \" F-name has vp2 M-name's noun ! \"",
"AndOr F-name grnd the noun said \" M-name has vp2 F-name's noun ! \"",
"LaterOr M-name grnd F-name's noun said \" F-name has vp2 the noun ! \"",
"LaterOr F-name grnd M-name's noun said \" M-name has vp2 the noun ! \"",
"AndOr M-name grnd F-name's noun said \" F-name has vp2 the noun ! \"",
"AndOr F-name grnd M-name's noun said \" M-name has vp2 the noun ! \"",

"LaterOr M-name grnd F-name's noun said \" F-name has vp2 the noun ! \"",
"LaterOr F-name grnd M-name's noun said \" M-name has vp2 the noun ! \"",
"AndOr M-name grnd F-name's noun said \" F-name has vp2 the noun ! \"",
"AndOr F-name grnd M-name's noun said \" M-name has vp2 the noun ! \"",

"LaterOr M-name grnd F-name's noun has vp2 F-name's noun .",
"LaterOr F-name grnd M-name's noun has vp2 M-name's noun .",
"AndOr M-name grnd F-name's noun hasOr vp2 F-name's noun .",
"AndOr F-name grnd M-name's noun hasOr vp2 M-name's noun .",

"LaterOr M-name and F-name grnd the noun have vp2 M-name's noun .",
"LaterOr F-name and M-name grnd the noun have vp2 F-name's noun .",
"AndOr M-name and F-name grnd the noun haveOr vp2 M-name's noun .",
"AndOr F-name and M-name grnd the noun haveOr vp2 F-name's noun .",
"LaterOr M-name and F-name grnd M-name's noun have vp2 the noun .",
"LaterOr F-name and M-name grnd F-name's noun have vp2 the noun .",
"AndOr M-name and F-name grnd M-name's noun haveOr vp2 the noun .",
"AndOr F-name and M-name grnd F-name's noun haveOr vp2 the noun .",

"LaterOr M-name adv grnd the noun has vp2 F-name's noun .",
"LaterOr F-name adv grnd the noun has vp2 M-name's noun .",
"AndOr M-name adv grnd the noun hasOr vp2 F-name's noun .",
"AndOr F-name adv grnd the noun hasOr vp2 M-name's noun .",
"LaterOr M-name adv grnd F-name's noun has vp2 the noun .",
"LaterOr F-name adv grnd M-name's noun has vp2 the noun .",
"AndOr M-name adv grnd F-name's noun hasOr vp2 the noun .",
"AndOr F-name adv grnd M-name's noun hasOr vp2 the noun ."

); // $arr_snt_len_7 = array

//---------------------------------------------------------------------------------------------

$arr_snt_len_8 = array( // structure of sentence with 8 core words

"AndOr M-name hasOr vp2 F-name's noun , causeOr F-name hasOr vp2 M-name's noun .",
"AndOr F-name hasOr vp2 M-name's noun , causeOr M-name hasOr vp2 F-name's noun .",

"AndOr M-name hasOr vp2 the noun , causeOr F-name hasOr vp2 M-name's noun adv .",
"AndOr F-name hasOr vp2 the noun , causeOr M-name hasOr vp2 F-name's noun adv .",
"AndOr M-name hasOr vp2 F-name's noun , causeOr F-name hasOr vp2 the noun adv .",
"AndOr F-name hasOr vp2 M-name's noun , causeOr M-name hasOr vp2 the noun adv .",
  
"AndOr M-name hasOr vp2 the noun adv , causeOr F-name hasOr vp2 M-name's noun .",
"AndOr F-name hasOr vp2 the noun adv , causeOr M-name hasOr vp2 F-name's noun .",
"AndOr M-name hasOr vp2 F-name's noun adv , causeOr F-name hasOr vp2 the noun .",
"AndOr F-name hasOr vp2 M-name's noun adv , causeOr M-name hasOr vp2 the noun .",

"AndOr M-name and F-name haveOr vp2 the noun , causeOr M-name hasOr vp2 F-name's noun .",
"AndOr F-name and M-name haveOr vp2 the noun , causeOr F-name hasOr vp2 M-name's noun .",
"AndOr M-name and F-name haveOr vp2 M-name's noun , causeOr F-name hasOr vp2 the noun .",
"AndOr F-name and M-name haveOr vp2 F-name's noun , causeOr M-name hasOr vp2 the noun .",

"AndOr M-name and F-name haveOr vp2 the noun adv , causeOr M-name hasOr vp2 the noun .",
"AndOr F-name and M-name haveOr vp2 the noun adv , causeOr F-name hasOr vp2 the noun .",
"AndOr M-name and F-name haveOr vp2 the noun , causeOr M-name hasOr vp2 the noun adv .",
"AndOr F-name and M-name haveOr vp2 the noun , causeOr F-name hasOr vp2 the noun adv .",

"LaterOr M-name grnd F-name's noun said \" F-name hasOr vp2 M-name's noun ! \"",
"LaterOr F-name grnd M-name's noun said \" M-name hasOr vp2 F-name's noun ! \"",
"AndOr M-name grnd F-name's noun said \" F-name hasOr vp2 M-name's noun ! \"",
"AndOr F-name grnd M-name's noun said \" M-name hasOr vp2 F-name's noun ! \"",

"LaterOr M-name adv grnd F-name's noun has vp2 F-name's noun .",
"LaterOr F-name adv grnd M-name's noun has vp2 M-name's noun .",
"AndOr M-name adv grnd F-name's noun hasOr vp2 F-name's noun .",
"AndOr F-name adv grnd M-name's noun hasOr vp2 M-name's noun .",
"LaterOr M-name grnd F-name's noun has vp2 F-name's noun adv .",
"LaterOr F-name grnd M-name's noun has vp2 M-name's noun adv .",
"AndOr M-name grnd F-name's noun hasOr vp2 F-name's noun adv .",
"AndOr F-name grnd M-name's noun hasOr vp2 M-name's noun adv .",

"LaterOr M-name and F-name grnd M-name's noun have vp2 F-name's noun .",
"LaterOr F-name and M-name grnd F-name's noun have vp2 M-name's noun .",
"AndOr M-name and F-name grnd M-name's noun haveOr vp2 F-name's noun .",
"AndOr F-name and M-name grnd F-name's noun haveOr vp2 M-name's noun .",

"LaterOr M-name and F-name adv grnd M-name's noun have vp2 the noun .",
"LaterOr F-name and M-name adv grnd F-name's noun have vp2 the noun .",
"AndOr M-name and F-name adv grnd M-name's noun haveOr vp2 the noun .",
"AndOr F-name and M-name adv grnd F-name's noun haveOr vp2 the noun .",
"LaterOr M-name and F-name grnd M-name's noun have vp2 the noun adv .",
"LaterOr F-name and M-name grnd F-name's noun have vp2 the noun adv .",
"AndOr M-name and F-name grnd M-name's noun haveOr vp2 the noun adv .",
"AndOr F-name and M-name grnd F-name's noun haveOr vp2 the noun adv .",

"LaterOr M-name adv grnd F-name's noun has vp2 F-name's noun .",
"LaterOr F-name adv grnd M-name's noun has vp2 M-name's noun .",
"AndOr M-name adv grnd F-name's noun hasOr vp2 F-name's noun .",
"AndOr F-name adv grnd M-name's noun hasOr vp2 M-name's noun .",

"LaterOr M-name adv grnd the noun has vp2 F-name's noun adv .",
"LaterOr F-name adv grnd the noun has vp2 M-name's noun adv .",
"AndOr M-name adv grnd the noun hasOr vp2 F-name's noun adv .",
"AndOr F-name adv grnd the noun hasOr vp2 M-name's noun adv ."

); // $arr_snt_len_8 = array

//=============================================================================================

$len_symbol = mb_strlen($str_symbol, "utf8"); // get symbol string's char count
$arr_symbol = array(); // assign symbol string array
$arr_symbol = str_split($str_symbol); // load chars to symbol string array

$len_unveil = mb_strlen($text_unveil, "utf8"); // get unveilized text's char count
$arr_unveil = array(); // assign unveilized text array
$arr_unveil = str_split($text_unveil); // load chars to unveilized text array

//---------------------------------------------------------------------------------------------

$veil_snt = "Begin"; // add begin to sentence text
$i = 0; // reset char index

while ($i < $len_unveil) { // cycle unveilized text's chars
  
  $snt_len_cur = mt_rand(0, ($snt_len_max - 2) - 1)
    + 3; // randomize core word count of current sentence
  if (($i + $snt_len_cur)
    > $len_unveil) { // if core word count exceed further unveilized text's core word count
    $snt_len_cur = $len_unveil - $i; // set word count of current sentence
  } // if (($i + $snt_len_cur) > $len_unveil)

//---------------------------------------------------------------------------------------------
 
  if ($snt_len_cur == 1) { // if word count of current sentence equal this value
    $m = mt_rand(0, count($arr_snt_len_1) - 1); // randomize type of sentence
    $veil_snt = $veil_snt . " " . $arr_snt_len_1[$m]; // set sentence text to temp string
  } // if ($snt_len_cur == 1)

  if ($snt_len_cur == 2) { // if word count of current sentence equal this value
    $m = mt_rand(0, count($arr_snt_len_2) - 1); // randomize type of sentence
    $veil_snt = $veil_snt . " " . $arr_snt_len_2[$m]; // set sentence text to temp string
  } // if ($snt_len_cur == 2)

  if ($snt_len_cur == 3) { // if word count of current sentence equal this value
    $m = mt_rand(0, count($arr_snt_len_3) - 1); // randomize type of sentence
    $veil_snt = $veil_snt . " " . $arr_snt_len_3[$m]; // set sentence text to temp string
  } // if ($snt_len_cur == 3)

  if ($snt_len_cur == 4) { // if word count of current sentence equal this value
    $m = mt_rand(0, count($arr_snt_len_4) - 1); // randomize type of sentence
    $veil_snt = $veil_snt . " " . $arr_snt_len_4[$m]; // set sentence text to temp string
  } // if ($snt_len_cur == 4)

  if ($snt_len_cur == 5) { // if word count of current sentence equal this value
    $m = mt_rand(0, count($arr_snt_len_5) - 1); // randomize type of sentence
    $veil_snt = $veil_snt . " " . $arr_snt_len_5[$m]; // set sentence text to temp string
  } // if ($snt_len_cur == 5)

  if ($snt_len_cur == 6) { // if word count of current sentence equal this value
    $m = mt_rand(0, count($arr_snt_len_6) - 1); // randomize type of sentence
    $veil_snt = $veil_snt . " " . $arr_snt_len_6[$m]; // set sentence text to temp string
  } // if ($snt_len_cur == 6)

  if ($snt_len_cur == 7) { // if word count of current sentence equal this value
    $m = mt_rand(0, count($arr_snt_len_7) - 1); // randomize type of sentence
    $veil_snt = $veil_snt . " " . $arr_snt_len_7[$m]; // set sentence text to temp string
  } // if ($snt_len_cur == 7)
  
  if ($snt_len_cur == 8) { // if word count of current sentence equal this value
    $m = mt_rand(0, count($arr_snt_len_8) - 1); // randomize type of sentence
    $veil_snt = $veil_snt . " " . $arr_snt_len_8[$m]; // set sentence text to temp string
  } // if ($snt_len_cur == 8)

//---------------------------------------------------------------------------------------------
  
  $i = $i + $snt_len_cur; // increase cycle index with core word count of current sentence
} // while ($i < $len_unveil)

$veil_snt = $veil_snt . " End"; // add end to sentence text

//=============================================================================================

$arr_enveil = array(); // assign sentence word array
$arr_enveil = explode(" ", $veil_snt); // load words from sentence text to sentence word array

$veil_str = ""; // clear enveilized text

$m = 0; // clear veiltext word number
$q = 0; // clear sentence word number

for ($i = 0; $i < count($arr_enveil); $i++) { // cycle sentence words of sentence text from 2nd
  if ($arr_enveil[$i] == ".") { // if current sentence word equal dot
    $veil_str = $veil_str . $arr_enveil[$i]; // add this word to enveilized text
	
    if ($q > $parag_word_count_min) { // if sentence word number more min paragraph word count
      if (mt_rand(0, 1) == 1) { // if random 50/50
	    $veil_str = $veil_str . "\n"; // add breakline to enveilized text
  	    $q = 0; // reset sentence word number
	  } // if (mt_rand(0, 1) == 1)
    } // if ($q > $parag_word_count_min)
	
	continue; // go to next sentence word of sentence text in cycle
  } // if ($arr_enveil[$i] == ".")
  
  if ($arr_enveil[$i] == ",") { // if current sentence word equal comma
    $veil_str = $veil_str . $arr_enveil[$i]; // add this word to enveilized text
	continue; // go to next sentence word of sentence text in cycle
  } // if ($arr_enveil[$i] == ",")
  if ($arr_enveil[$i] == "!") { // if current sentence word equal exclamation mark
    $veil_str = $veil_str . $arr_enveil[$i]; // add this word to enveilized text
	continue; // go to next sentence word of sentence text in cycle
  } // if ($arr_enveil[$i] == "!")
  if ($arr_enveil[$i] == "\"") { // if current sentence word equal quote
    $veil_str = $veil_str . $arr_enveil[$i]; // add this word to enveilized text
	continue; // go to next sentence word of sentence text in cycle
  } // if ($arr_enveil[$i] == "\"")
  
  if ($arr_enveil[$i] == "Begin") { // if current sentence word equal begin
    $n = mt_rand(0, 7); // randomize type of phrase
	if ($n == 0) { $veil_str = $veil_str . " " . "Then it was so."; }
	if ($n == 1) { $veil_str = $veil_str . " " . "Further it was insteresting."; }
	if ($n >= 2) {}
	continue; // go to next sentence word of sentence text in cycle
  } // if ($arr_enveil[$i] == "Begin")
  if ($arr_enveil[$i] == "End") { // if current sentence word equal end
    $n = mt_rand(0, 7); // randomize type of phrase
	if ($n == 0) { $veil_str = $veil_str . " " . "That was so."; }
	if ($n == 1) { $veil_str = $veil_str . " " . "This was so."; }
	if ($n >= 2) {}
	continue; // go to next sentence word of sentence text in cycle
  } // if ($arr_enveil[$i] == "End")
  
  if ($arr_enveil[$i] == "and") { // if current sentence word equal this word
    $veil_str = $veil_str . " " . "and";
	continue; // go to next sentence word of sentence text in cycle
  } // if ($arr_enveil[$i] == "and")
  if ($arr_enveil[$i] == "AndOr") { // if current sentence word equal this word
    $n = mt_rand(0, 3); // randomize type of phrase
	if ($n == 0) { $veil_str = $veil_str . " " . "And"; }
	if ($n == 1) { $veil_str = $veil_str . " " . "But"; }
	if ($n >= 2) {}
	continue; // go to next sentence word of sentence text in cycle
  } // if ($arr_enveil[$i] == "AndOr")
  
  if ($arr_enveil[$i] == "has") { // if current sentence word equal this word
    $veil_str = $veil_str . " " . "has";
	continue; // go to next sentence word of sentence text in cycle
  } // if ($arr_enveil[$i] == "has")
  if ($arr_enveil[$i] == "hasOr") { // if current sentence word equal this word
    $n = mt_rand(0, 3); // randomize type of phrase
	if ($n == 0) { $veil_str = $veil_str . " " . "hasn't"; }
	if ($n == 1) { $veil_str = $veil_str . " " . "has not"; }
	if ($n >= 2) { $veil_str = $veil_str . " " . "has"; }
	continue; // go to next sentence word of sentence text in cycle
  } // if ($arr_enveil[$i] == "hasOr")
  if ($arr_enveil[$i] == "have") { // if current sentence word equal this word
    $veil_str = $veil_str . " " . "have";
	continue; // go to next sentence word of sentence text in cycle
  } // if ($arr_enveil[$i] == "have")
  if ($arr_enveil[$i] == "haveOr") { // if current sentence word equal this word
    $n = mt_rand(0, 3); // randomize type of phrase
	if ($n == 0) { $veil_str = $veil_str . " " . "haven't"; }
	if ($n == 1) { $veil_str = $veil_str . " " . "have not"; }
	if ($n >= 2) { $veil_str = $veil_str . " " . "have"; }
	continue; // go to next sentence word of sentence text in cycle
  } // if ($arr_enveil[$i] == "haveOr")

  if ($arr_enveil[$i] == "The") { // if current sentence word equal this word
    $veil_str = $veil_str . " " . "The";
	continue; // go to next sentence word of sentence text in cycle
  } // if ($arr_enveil[$i] == "The")
  if ($arr_enveil[$i] == "the") { // if current sentence word equal this word
    $veil_str = $veil_str . " " . "the";
	continue; // go to next sentence word of sentence text in cycle
  } // if ($arr_enveil[$i] == "the")
  
  if ($arr_enveil[$i] == "said") { // if current sentence word equal this word
    $n = mt_rand(0, 1); // randomize type of phrase
	if ($n == 0) { $veil_str = $veil_str . " " . "said:"; } //skazal
	if ($n == 1) { $veil_str = $veil_str . " " . "cried:"; } //kriknul
	continue; // go to next sentence word of sentence text in cycle
  } // if ($arr_enveil[$i] == "said")
  if ($arr_enveil[$i] == "causeOr") { // if current sentence word equal this word
    $n = mt_rand(0, 3); // randomize type of phrase
	if ($n == 0) { $veil_str = $veil_str . " " . "therefore"; } //poetomu
	if ($n == 1) { $veil_str = $veil_str . " " . "that is why"; } //potomu
	if ($n >= 2) { $veil_str = $veil_str . " " . "because"; } //potomu-chto
	continue; // go to next sentence word of sentence text in cycle
  } // if ($arr_enveil[$i] == "causeOr")

  if ($arr_enveil[$i] == "LaterOr") { // if current sentence word equal this word
    $n = mt_rand(0, 8); // randomize type of phrase
	if ($n == 0) { $veil_str = $veil_str . " " . "Then"; } //zatem
	if ($n == 1) { $veil_str = $veil_str . " " . "Later"; } //pozdneye
	if ($n == 2) { $veil_str = $veil_str . " " . "Further"; } //daleye
	if ($n == 3) { $veil_str = $veil_str . " " . "Afterwards"; } //posle
	if ($n == 4) { $veil_str = $veil_str . " " . "Suddenly"; } //neozhidanno
	if ($n == 5) { $veil_str = $veil_str . " " . "Unexpectedly"; } //vnezapno
	if ($n == 6) { $veil_str = $veil_str . " " . "By the way,"; } //kstati
	if ($n == 7) { $veil_str = $veil_str . " " . "Of course,"; } //razumeyetsia
	continue; // go to next sentence word of sentence text in cycle
  } // if ($arr_enveil[$i] == "LaterOr")

  if ($arr_enveil[$i] == "wasThere") { // if current sentence word equal this word
    $n = mt_rand(0, 1); // randomize type of phrase
	if ($n == 0) { $veil_str = $veil_str . " " . "was there"; } //zatem
	if ($n == 1) { $veil_str = $veil_str . " " . "saw it"; } //pozdneye
	continue; // go to next sentence word of sentence text in cycle
  } // if ($arr_enveil[$i] == "wasThere")
  
//---------------------------------------------------------------------------------------------
  
  $s = $arr_unveil[$m]; // set current char of unveilized text array to temp string  
  $k = -1; // reset current char's number in base64 text
  
  for ($j = 0; $j < $len_symbol; $j++) { // cycle chars of base64 text
    if ($s == $arr_symbol[$j]) { // if temp string equal char of base64 text
 	  $k = $j; // set current char's number
	  break; // exit from cycle
    } // if ($s == $arr_symbol[$j])
  } // for ($j = 0; $j < $len_symbol; $j++)
  
  if ($k == -1) { // if current char's number was not founded in base64 text
	return ""; // exit
  } // if ($k == -1)
  
  // change sentence words to real words
  if ($arr_enveil[$i] == "M-name") {
    $veil_str = $veil_str . " " . $arr_noun_name_male[$k];
  } // if ($arr_enveil[$i] == "M-name")
  if ($arr_enveil[$i] == "F-name") {
    $veil_str = $veil_str . " " . $arr_noun_name_fem[$k];
  } // if ($arr_enveil[$i] == "F-name")
  if ($arr_enveil[$i] == "adv") {
    $veil_str = $veil_str . " " . $arr_adverb[$k];
  } // if ($arr_enveil[$i] == "adv")
  if ($arr_enveil[$i] == "grnd") {
    $veil_str = $veil_str . " " . $arr_gerund[$k];
  } // if ($arr_enveil[$i] == "grnd")
  if ($arr_enveil[$i] == "vp2") {
    $veil_str = $veil_str . " " . $arr_verb_part2[$k];
  } // if ($arr_enveil[$i] == "vp2")
  if ($arr_enveil[$i] == "M-name's") {
    $veil_str = $veil_str . " " . $arr_noun_name_male[$k] . "'s";
  } // if ($arr_enveil[$i] == "M-name's")
  if ($arr_enveil[$i] == "F-name's") {
    $veil_str = $veil_str . " " . $arr_noun_name_fem[$k] . "'s";
  } // if ($arr_enveil[$i] == "F-name's")
  if ($arr_enveil[$i] == "noun") {
    $veil_str = $veil_str . " " . $arr_noun_object[$k];
  } // if ($arr_enveil[$i] == "noun")
  
  $m = $m + 1; // increase veiltext word number
  $q = $q + 1; // increase sentence word number
} // for ($i = 0; $i < count($arr_enveil); $i++)

//=============================================================================================

  // correct enveilized text
  $a = array(); // assign temp array
  $a = str_split($veil_str); // load chars of enveilized text to temp array

  // shift quotes to right near colons
  for ($i = 1; $i < count($a); $i++) { // cycle chars of enveilized text
    if ($a[$i] == "\"") { // if current char is quote
      if ($a[$i - 1] == ":") { // if previous char is colon
	    $a[$i] = " "; // set space to current char
		$a[$i + 1] = "\""; // set quote to next char
		$i = $i + 2; // increase index of array with 2
	  } // if ($a[$i - 1] == ":")
	} // if ($a[$i] == "\"")
  } // for ($i = 1; $i < count($a); $i++)
  
  // remove spaces in begining of paragraphs
  for ($i = 0; $i < count($a); $i++) { // cycle chars of edited enveilized text
    if ($a[$i] == "\n") { // if current char is breakline
      if ($a[$i + 1] == " ") { // if next char is space
		$a[$i + 1] = ""; // clear next char
		$i = $i + 2; // increase index of array with 2
	  } // if ($a[$i + 1] == " ")
	} // if ($a[$i] == "\n")
  } // for ($i = 0; $i < count($a); $i++)

//---------------------------------------------------------------------------------------------
  
  // rebuild enveilized text
  $veil_str = ""; // clear enveilized text
  for ($i = 1; $i < count($a); $i++) { // cycle chars of edited enveilized text
    $veil_str = $veil_str . $a[$i]; // add char to enveilized text if not clear
  } // for ($i = 1; $i < count($a); $i++)
  
//=============================================================================================
  
  $text_result = $text_result . $veil_str; // add enveilized text to result text
  return $text_result; // print result text
} // function func_enveil_eng($text_unveil)

#==============================================================================================
#==============================================================================================
#==============================================================================================

?>
