<?php

/*=============================================================================================

ConsoleCaptcha (c)
Version: 2.13.6.14

Author: VanDerSaAr

ConsoleCaptcha generates text based images with symbols, which enough easily can be read by
humans, but difficulty can be read by OCR systems or other robots. It does not require any
graphic library (GD, etc), any database of questions, etc. It does not use much resources and
more faster. It can be used with telnet, ssh, etc.

See example: http://cryptbb.site40.net/reg.php?v=1

~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

License: MIT

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.
 
-----------------------------------------------------------------------------------------------

How to use:

<code>
<?php
include("console-captcha-2.13.6.14.php");
echo func_console_captcha(
  "EFHLN", # random captcha text = string of 1..30 symbols from EFHLNTXZ + space
  4,    # defined font size              = 1..24 pixels
  21,   # defined canvas height          = 13..100 symbols
  120,  # minimal canvas width           = 0..600 symbols
  
  12,   # minimal strike line height     = 12..min_canvas_width
  50,   # minimal strike line width      = 50..100 symbols
  30,   # maximal add strike line width  = 0..50 symbols
  15,   # maximal inverval between strike lines = 0..25 symbols
  
  10,   # minimal letter size            = 10..canvas_height-3
  100,  # maximal letter size            = min_letter_size..canvas_height-3
  0,    # minimal interval between letters = 0..100 symbols
  4,    # maximal interval between letters = min_interval_letter..100
  
  10);  # maximal deviation of letter from vertical line = 0..30 degrees
?>
</code>

To check captcha you can use hashes, sessions, etc.

-----------------------------------------------------------------------------------------------

Changelog:
2013-06-14: Added Courier New to font family, changed random function.
2012-08-29: Added Monospace to font family, corrected several comments.
2012-08-28: Publicated first version.

*///===========================================================================================

function func_console_captcha(
  $CaptchaText, // = "EFHLN" # random captcha text = 1..30 symbols from EFHLNTXZ + space
  $FontSize,          // = 4    # defined font size              = 1..24
  $CanvasHeight,      // = 21   # defined canvas height          = 13..100
  $MinCanvasWidth,    // = 120  # minimal canvas width           = 0..600
  $MinStrikeHeight,   // = 12   # minimal strike line height     = 12..$MinCanvasWidth
  $MinStrikeLength,   // = 50   # minimal strike line width      = 50..100
  $AddStrikeLength,   // = 30   # maximal add strike line width  = 30..50
  $MaxStrikeInterval, // = 15   # maximal inverval between strike lines = 15..25
  $MinLetterSize,     // = 10   # minimal symbol size            = 10..$CanvasHeight-3
  $MaxLetterSize,     // = 100  # maximal symbol size            = 100..$CanvasHeight-3
  $MinLetterInterval, // = 0    # minimal interval between minimal symbol size = 0..100
  $MaxLetterInterval, // = 4    # maximal interval between minimal symbol size = 4..100
  $MaxLetterAngle     // = 10   # maximal deviation of symbol from vertical line = 0..30
  ) {

#==============================================================================================  

function FuncAngleX($FuncX, $FuncAngle, $FuncSize) { # func (origin x, pos angle, pos length)

  if (($FuncAngle >= (M_PI / 2)) and ($FuncAngle < (3 * M_PI / 2))) { # if angle = PI/2 .. 3*PI/2
  
    $FuncX = $FuncX - round($FuncSize * cos($FuncAngle)); # set position x
	
  } else { # if (($FuncAngle >= (M_PI / 2)) and ($FuncAngle < (3 * M_PI / 2))) # if angle = 0..PI/2 + 3*PI/2..2*PI

    if ($FuncAngle < (M_PI / 2)) { # if angle = 0 .. PI/2
      $FuncX = $FuncX + round($FuncSize * cos(M_PI - $FuncAngle)); # set position x
    } else { # if ($FuncAngle < (M_PI / 2)) # if angle = 3*PI/2 .. 2*PI
      $FuncX = $FuncX + round($FuncSize * cos($FuncAngle - M_PI)); # set position x
	} # if ($FuncAngle < (M_PI / 2)) else
	
  } # if (($FuncAngle >= (M_PI / 2)) and ($FuncAngle < (3 * M_PI / 2))) else
  
  return $FuncX; # return position x    
  
} # function FuncAngleX ($FuncX, $FuncAngle, $FuncSize)

#----------------------------------------------------------------------------------------------

function FuncPointPos($FuncOriginX, $FuncOriginY, $FuncRatio, $FuncSize1, $FuncAngle1,
$FuncSize2, $FuncAngle2) { # func (origin x, y; factor y; positions length, angle of degrees)

  $FuncA = ($FuncAngle1 / 180) * M_PI; # set position1 angle
  
  if ($FuncA > (2 * M_PI)) { # if angle more 2*PI
    $FuncA = $FuncA - (2 * M_PI); # decrease angle
  } # if ($FuncA > (2 * M_PI))
  if ($FuncA < 0) { # if angle less 0
    $FuncA = $FuncA + (2 * M_PI); # increase angle
  } # if ($FuncA < 0)
  
  $FuncX1 = FuncAngleX($FuncOriginX, $FuncA, $FuncSize1); # set position1 x
  $FuncY1 = $FuncOriginY + round(($FuncSize1 * sin($FuncA)) / $FuncRatio); # set position1 y
	
  $FuncA = ($FuncAngle2 / 180) * M_PI; # set position2 angle
  
  if ($FuncA > (2 * M_PI)) { # if angle more 2*PI
    $FuncA = $FuncA - (2 * M_PI); # decrease angle
  } # if ($FuncA > (2 * M_PI))
  if ($FuncA < 0) { # if angle less 0
    $FuncA = $FuncA + (2 * M_PI); # increase angle
  } # if ($FuncA < 0)
  
  $FuncX2 = FuncAngleX($FuncOriginX, $FuncA, $FuncSize2); # set position2 x
  $FuncY2 = $FuncOriginY + round(($FuncSize2 * sin($FuncA)) / $FuncRatio); # set position2 y
  
  return array ($FuncX1, $FuncY1, $FuncX2, $FuncY2); # return positions x1, y1, x2, y2
  
} # function FuncPointPos()

#==============================================================================================  

  $NeedDebug = false; # if need to print tech info
  
  #$FontSize = 4; // 4 # get font size // debug
  if ($FontSize < 1) {$FontSize = 1;} # if value less min value then set min value
  if ($FontSize > 24) {$FontSize = 24;} # if value more max value then set max value
  
  #$CanvasHeight = 21; // 21 # get canvas height // debug
  if ($CanvasHeight < 13) {$CanvasHeight = 13;} # if value less min value then set min value
  if ($CanvasHeight > 100) {$CanvasHeight = 100;} # if value more max value then set max value

  #$MinCanvasWidth = 120; // 120 # get minimal canvas width // debug
  if ($MinCanvasWidth < 0) {$MinCanvasWidth = 0;} # if value less min value then set min value
  if ($MinCanvasWidth > 600) {$MinCanvasWidth = 600;} # if value more max value then set max value

  #$MinStrikeHeight = 12; // 12 # get minimal strike line height // debug
  if ($MinStrikeHeight < 12) {$MinStrikeHeight = 12;} # if value less min value then set min value
  if ($MinStrikeHeight > $CanvasHeight) {$MinStrikeHeight = $CanvasHeight;} # if value more max value then set max value
  
  #$MinStrikeLength = 50; // 50 # get minimal strike line length // debug
  if ($MinStrikeLength < 50) {$MinStrikeLength = 50;} # if value less min value then set min value
  if ($MinStrikeLength > 100) {$MinStrikeLength = 100;} # if value more max value then set max value

  #$AddStrikeLength = 30; // 30 # get maximal add strike line height // debug
  if ($AddStrikeLength < 0) {$AddStrikeLength = 0;} # if value less min value then set min value
  if ($AddStrikeLength > 50) {$AddStrikeLength = 50;} # if value more max value then set max value

  #$MaxStrikeInterval = 15; // 15 # get maximal inverval between strike lines // debug
  if ($MaxStrikeInterval < 0) {$MaxStrikeInterval = 0;} # if value less min value then set min value
  if ($MaxStrikeInterval > 25) {$MaxStrikeInterval = 25;} # if value more max value then set max value
  
  #$MinLetterSize = 10; // 10 # get minimal symbol size // debug
  if ($MinLetterSize < 10) {$MinLetterSize = 10;} # if value less min value then set min value
  if ($MinLetterSize > $CanvasHeight - 3) {$MinLetterSize = $CanvasHeight - 3;} # if value more max value then set max value
  
  #$MaxLetterSize = 100; // 100 # get maximal symbol size // debug
  if ($MaxLetterSize < $MinLetterSize) {$MaxLetterSize = $MinLetterSize;} # if value less min value then set min value
  if ($MaxLetterSize > $CanvasHeight - 3) {$MaxLetterSize = $CanvasHeight - 3;} # if value more max value then set max value

  #$MinLetterInterval = 0; // 0 # get minimal interval between minimal symbol size // debug
  if ($MinLetterInterval < 0) {$MinLetterInterval = 0;} # if value less min value then set min value
  if ($MinLetterInterval > 100) {$MinLetterInterval = 100;} # if value more max value then set max value
  
  #$MaxLetterInterval = 4; // 4 # get maximal interval between minimal symbol size // debug
  if ($MaxLetterInterval < $MinLetterInterval) {$MaxLetterInterval = $MinLetterInterval;} # if value less min value then set min value
  if ($MaxLetterInterval > 100) {$MaxLetterInterval = 100;} # if value more max value then set max value

  #$MaxLetterAngle = 10; // 10 # get maximal deviation of symbol from vertical line // debug
  if ($MaxLetterAngle < 0) {$MaxLetterAngle = 0;} # if value less min value then set min value
  if ($MaxLetterAngle > 30) {$MaxLetterAngle = 30;} # if value more max value then set max value

#----------------------------------------------------------------------------------------------  
  
  if ($FontSize < 3) { # if letters too small
    $CanvasBackChars = " "; # set canvas background chars
  } else { # if ($FontSize < 3)
    $CanvasBackChars = ".,' "; # set canvas background chars  
  } # if ($FontSize < 3) else

  $CanvasFrontChars = "#@&"; # set canvas front chars  
  $DrawChar = "*"; # set temp draw char
  $SpaceChar = " "; # set temp space char
  $Ratio = "1.73"; # set ratio between width and height of symbols

  for ($For1 = 1; $For1 <= $CanvasHeight; $For1++) { # cycle lines of canvas
  
    if ($NeedDebug === true) { # if need to debug
      $Line[$For1] = sprintf('%1$02d', $For1); # set line number
	} else { # if ($NeedDebug === true) # if not need to debug
	  $Line[$For1] = $SpaceChar; # set space
	} # if ($NeedDebug === true) else
	
  } # for ($For1 = 1; $For1 <= $CanvasHeight; $For1++)

  $DrawCount = 0; # clear draw lines count
  $OriginX = 2; # set start symbol position

  $PointX1 = array(); # assign array of x1 point of draw line
  $PointY1 = array(); # assign array of y1 point of draw line
  $PointX2 = array(); # assign array of x2 point of draw line
  $PointY2 = array(); # assign array of y2 point of draw line
  
  for ($For1 = (strlen($CaptchaText) - 1); $For1 >= 0; $For1--) { # cycle symbols of captcha text
  
    if (strpos('EFHLNTXZ ', $CaptchaText[$For1]) === false) { # if captcha symbol is unknown and not space
	  $CaptchaText = substr_replace($CaptchaText, "", $For1, 1); # delete symbol
	} # if (strpos('EFHLNTXZ ', $CaptchaText[$For1]) === false)
	
  } # for ($For1 = (strlen($CaptchaText) - 1); $For1 >= 0; $For1--)
  
  if (strlen($CaptchaText) > 30) { # if length of captcha text more value
    $CaptchaText = substr($CaptchaText, 0, 30); # cut captcha text from right side
  } # if (strlen($CaptchaText) > 30)

#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

for ($For1 = 0; $For1 < strlen($CaptchaText); $For1++) { # cycle symbols of captcha

  $OriginX = $OriginX + mt_rand($MinLetterInterval, $MaxLetterInterval); # increase origin x plus random interval

  $MainSize = mt_rand($MinLetterSize, $MaxLetterSize); # randomize letter size
  #$MainSize = 7; # debug

  $DeltaA = mt_rand(0, $MaxLetterAngle * 2) - $MaxLetterAngle; # randomize angle delta
  #$DeltaA = 0; # debug

  $OriginY = mt_rand(ceil($MainSize / 2) + 2, $CanvasHeight - ceil($MainSize / 2) - 1); # randomize origin y = 08..14
  
  $OriginX = $OriginX + ceil($MainSize / 2) + 1; # increase origin x plus half letter size
  
#----------------------------------------------------------------------------------------------  

if (strpos('EFHLN', $CaptchaText[$For1]) !== false) { # left column begin
  $DrawCount = $DrawCount + 1; # increase line count
  list ($PointX1[$DrawCount], $PointY1[$DrawCount], $PointX2[$DrawCount], $PointY2[$DrawCount]) =
  FuncPointPos($OriginX, $OriginY, $Ratio, $MainSize, 300 + $DeltaA, $MainSize, 60 + $DeltaA);
} # left column end

if (strpos('EFTZ', $CaptchaText[$For1]) !== false) { # top row begin
  $DrawCount = $DrawCount + 1; # increase line count
  list ($PointX1[$DrawCount], $PointY1[$DrawCount], $PointX2[$DrawCount], $PointY2[$DrawCount]) =
  FuncPointPos($OriginX, $OriginY, $Ratio, $MainSize, 300 + $DeltaA, $MainSize, 240 + $DeltaA);
} # top row end

if (strpos('EFH', $CaptchaText[$For1]) !== false) { # middle row begin
  $DrawCount = $DrawCount + 1; # increase line count
  list ($PointX1[$DrawCount], $PointY1[$DrawCount], $PointX2[$DrawCount], $PointY2[$DrawCount]) =
  FuncPointPos($OriginX, $OriginY, $Ratio, $MainSize / 2.1, 0 + $DeltaA, $MainSize / 2.1, 180 + $DeltaA);
} # middle row end	
  
if (strpos('ELZ', $CaptchaText[$For1]) !== false) { # bottom row begin
  $DrawCount = $DrawCount + 1; # increase line count
  list ($PointX1[$DrawCount], $PointY1[$DrawCount], $PointX2[$DrawCount], $PointY2[$DrawCount]) =
  FuncPointPos($OriginX, $OriginY, $Ratio, $MainSize, 60 + $DeltaA, $MainSize, 120 + $DeltaA);
} # # bottom row end
  
if (strpos('HN', $CaptchaText[$For1]) !== false) { # right column begin
  $DrawCount = $DrawCount + 1; # increase line count
  list ($PointX1[$DrawCount], $PointY1[$DrawCount], $PointX2[$DrawCount], $PointY2[$DrawCount]) =
  FuncPointPos($OriginX, $OriginY, $Ratio, $MainSize, 240 + $DeltaA, $MainSize, 120 + $DeltaA);
} # right column end

if (strpos('T', $CaptchaText[$For1]) !== false) { # middle column begin
  $DrawCount = $DrawCount + 1; # increase line count
  list ($PointX1[$DrawCount], $PointY1[$DrawCount], $PointX2[$DrawCount], $PointY2[$DrawCount]) =
  FuncPointPos($OriginX, $OriginY, $Ratio, $MainSize / 1.2, 270 + $DeltaA, $MainSize / 1.2, 90 + $DeltaA);
} # middle column end

if (strpos('NX', $CaptchaText[$For1]) !== false) { # diagonal \ begin
  $DrawCount = $DrawCount + 1; # increase line count
  list ($PointX1[$DrawCount], $PointY1[$DrawCount], $PointX2[$DrawCount], $PointY2[$DrawCount]) =
  FuncPointPos($OriginX, $OriginY, $Ratio, $MainSize, 300 + $DeltaA, $MainSize, 120 + $DeltaA);
} # diagonal \ end

if (strpos('XZ', $CaptchaText[$For1]) !== false) { # diagonal / begin
  $DrawCount = $DrawCount + 1; # increase line count
  list ($PointX1[$DrawCount], $PointY1[$DrawCount], $PointX2[$DrawCount], $PointY2[$DrawCount]) =
  FuncPointPos($OriginX, $OriginY, $Ratio, $MainSize, 240 + $DeltaA, $MainSize, 60 + $DeltaA);
} # diagonal / begin

#----------------------------------------------------------------------------------------------  
  
  $OriginX = $OriginX + ceil($MainSize / 2) + 1; # increase origin x plus half letter size
  
} # for ($For1 = 0; $For1 < strlen($CaptchaText); $For1++)

#==============================================================================================

$OriginX = $OriginX + 2; # increase origin x
$MarginX = 0; # clear margin x

if ($OriginX < $MinCanvasWidth) { # if origin x less minimal canvas width
  $MarginX = mt_rand(0, $MinCanvasWidth - $OriginX); # randomize margin x
  $OriginX = $MinCanvasWidth; # set margin x
} # if ($OriginX < $MinCanvasWidth)

for ($For1 = 1; $For1 <= $DrawCount; $For1++) { # cycle draw lines
  $PointX1[$For1] = $PointX1[$For1] + $MarginX; # shift position x1 of draw line point
  $PointX2[$For1] = $PointX2[$For1] + $MarginX; # shift position x2 of draw line point
} # for ($For1 = 1; $For1 <= $DrawCount; $For1++)

#----------------------------------------------------------------------------------------------
  
$DotX1 = 1; # clear dot x1

while ($DotX1 < $OriginX) { # while dot x1 less right side of canvas

  $DotX2 = $DotX1 + $MinStrikeLength + mt_rand(0, $AddStrikeLength); # set dot x2
  
  if ($DotX2 >= ($OriginX - $MinStrikeLength)) { # if dot x2 near right side
    $DotX2 = $OriginX; # set origin x to dot x2
  } # if ($DotX2 >= ($OriginX - $MinStrikeLength))

  if ($DotX1 != 1) { # if it is not left side
  
    if (($DotX2 - $DotX1) > ($MinStrikeLength + $AddStrikeLength)) { # if x1 x2 delta more strike line length
      $DotX1 = $DotX2 - ($MinStrikeLength + $AddStrikeLength); # set dot x1
    } # if (($DotX2 - $DotX1) > ($MinStrikeLength + $AddStrikeLength))
	
  } # if ($DotX1 != 1)

#----------------------------------------------------------------------------------------------
  
  if (($MinStrikeHeight * 2) > $CanvasHeight) { # if canvas height less doubled minimal strike line height
  
    if (mt_rand(0, 1) == 1) { # if 50%/50%
	  $DotY1 = mt_rand(1, $CanvasHeight - $MinStrikeHeight + 1); # randomize left position of strike line
	} else { # if (mt_rand(0, 1) == 1)
	  $DotY1 = mt_rand($MinStrikeHeight, $CanvasHeight); # randomize left position of strike line
	} # if (mt_rand(0, 1) == 1) else
	
  } else { # if (($MinStrikeHeight * 2) > $CanvasHeight)
  
    $DotY1 = mt_rand(1, $CanvasHeight); # randomize left position of strike line
	
  } # if (($MinStrikeHeight * 2) > $CanvasHeight) else

  if (($DotY1 - $MinStrikeHeight + 1) < 1) { # if left position of strike line near top of canvas  
	$DotY2 = mt_rand($DotY1 + $MinStrikeHeight - 1, $CanvasHeight); # randomize right position of strike line 	
  } else { # if (($DotY1 - $MinStrikeHeight + 1) < 1)  
  
    if (($DotY1 + $MinStrikeHeight - 1) > $CanvasHeight) { # if left position of strike line near bottom of canvas	
	  $DotY2 = mt_rand(1, $DotY1 - $MinStrikeHeight + 1); # randomize right position of strike line 	  
	} else { # if (($DotY1 + $MinStrikeHeight - 1) > $CanvasHeight)
	
      if (mt_rand(0, 1) == 1) { # if 50%/50%
	    $DotY2 = mt_rand($DotY1 + $MinStrikeHeight - 1, $CanvasHeight); # randomize right position of strike line 
	  } else { # if (mt_rand(0, 1) == 1)
	    $DotY2 = mt_rand(1, $DotY1 - $MinStrikeHeight + 1); # randomize right position of strike line 
	  } # if (mt_rand(0, 1) == 1) else
	  
	} # if (($DotY1 + $MinStrikeHeight - 1) > $CanvasHeight) else			
  } # if (($DotY1 - $MinStrikeHeight + 1) < 1) else

#----------------------------------------------------------------------------------------------
  
  $DrawCount = $DrawCount + 1; # increase draw line count
  $PointX1[$DrawCount] = $DotX1; # set point x1
  $PointY1[$DrawCount] = $DotY1; # set point y1
  $PointX2[$DrawCount] = $DotX2; # set point x2
  $PointY2[$DrawCount] = $DotY2; # set point y2
  
  $DotX1 = $DotX2 + mt_rand(0, $MaxStrikeInterval); # increase dot x1
  
} # while ($DotX1 < $OriginX)

#==============================================================================================

// draw lines on canvas

for ($For1 = 1; $For1 <= $DrawCount; $For1++) { # cycle draw lines
  $DotX1 = $PointX1[$For1]; # get dot x1
  $DotY1 = $PointY1[$For1]; # get dot y1
  $DotX2 = $PointX2[$For1]; # get dot x2
  $DotY2 = $PointY2[$For1]; # get dot y2
  
  if ($NeedDebug == true) { # if need to debug
    echo 'DotX1=' . $DotX1 . ', DotY1=' . $DotY1 . ';'
	. ' DotX2=' . $DotX2 . ', DotY2=' . $DotY2 . ': '; # print coordinates
  } # if ($NeedDebug == true)

  if ($DotX1 < $DotX2) { # if need to debug
    $FromX = $DotX1; # set left position x
  } else { # if ($DotX1 < $DotX2)
    $FromX = $DotX2; # set right position x
  } # if ($DotX1 < $DotX2) else
  if ($DotY1 < $DotY2) { # if need to debug
    $FromY = $DotY1; # set top position y
  } else { # if ($DotY1 < $DotY2)
    $FromY = $DotY2; # set bottom position y
  } # if ($DotY1 < $DotY2) else
  
  if ($NeedDebug == true) { # if need to debug
    echo 'FromX=' . $FromX . ', FromY=' . $FromY . '; '; # print coordinates
  } # if ($NeedDebug == true)
  
  $DeltaX = abs($DotX1 - $DotX2); # set delta x
  $DeltaY = abs($DotY1 - $DotY2); # set delta y

  if ($NeedDebug == true) { # if need to debug then print coordinates
    echo 'DeltaX=' . $DeltaX . ', DeltaY=' . $DeltaY . '.<BR>'; # print coodinates
  } # if ($NeedDebug == true)

#----------------------------------------------------------------------------------------------
  
  if ($DeltaX > $DeltaY) { # if width of letter more height
  
    for ($For2 = 0; $For2 <= $DeltaX; $For2++) { # cycle points of width
	  if ($DotX1 >= $DotX2) { # if position x1 more or equal position x2
	  
	    if ($DotY1 < $DotY2) { # if position y1 less position y2
	      $TmpInt = round($DeltaY * (($DeltaX - $For2) / $DeltaX)); # set y coodinate
		} else { # if ($DotY1 < $DotY2)
		  $TmpInt = round($DeltaY * ($For2 / $DeltaX)); # set y coodinate
		} # if ($DotY1 < $DotY2) else
		
	  } else { # if ($DotX1 >= $DotX2)
	  
	    if ($DotY1 >= $DotY2) { # if position y1 more position y2
	      $TmpInt = round($DeltaY * (($DeltaX - $For2) / $DeltaX)); # set y coodinate
		} else { # if ($DotY1 >= $DotY2)
		  $TmpInt = round($DeltaY * ($For2 / $DeltaX)); # set y coodinate
		} # if ($DotY1 >= $DotY2) else
		
	  } # if ($DotX1 >= $DotX2) else

      if ($NeedDebug == true) { # if need to debug
 	    echo 'Y' . $For2 . '=' . $TmpInt . ', '; # print y coodinate
      }	# if ($NeedDebug == true)
	  
	  $Line[$FromY + $TmpInt][$FromX + $For2 - 1] = $DrawChar; # draw char on canvas 
    } # for ($For2 = 0; $For2 <= $DeltaX; $For2++) 
	
  } else { # if ($DeltaX > $DeltaY)  
  
    for ($For2 = 0; $For2 <= $DeltaY; $For2++) { # cycle points of height
	  if ($DotY1 >= $DotY2) { # if position y1 more or equal position y2
	  
	    if ($DotX1 < $DotX2) { # if position x1 less position x2
	      $TmpInt = round($DeltaX * (($DeltaY - $For2) / $DeltaY)); # set x coodinate
		} else { # if ($DotX1 < $DotX2)
		  $TmpInt = round($DeltaX * ($For2 / $DeltaY)); # set x coodinate
		} # if ($DotX1 < $DotX2) else
		
	  } else { # if ($DotY1 >= $DotY2)
	  
	    if ($DotX1 >= $DotX2) { # if position x1 more or equal position x2
	      $TmpInt = round($DeltaX * (($DeltaY - $For2) / $DeltaY)); # set x coodinate
		} else { # if ($DotX1 >= $DotX2)
		  $TmpInt = round($DeltaX * ($For2 / $DeltaY)); # set x coodinate
		} # if ($DotX1 >= $DotX2) else
		
	  } # if ($DotY1 >= $DotY2) else

      if ($NeedDebug == true) { # if need to debug
  	    echo 'X' . $For2 . '=' . $TmpInt . ', '; # print x coodinate
      } # if ($NeedDebug == true)
	  
	  $Line[$FromY + $For2][$FromX + $TmpInt - 1] = $DrawChar; # draw char on canvas
    } # for ($For2 = 0; $For2 <= $DeltaY; $For2++)	
	
  } # if ($DeltaX > $DeltaY) else
  
#----------------------------------------------------------------------------------------------
  
  if ($NeedDebug == true) { # if need to debug
    echo '<BR>'; # print line break
  } # if ($NeedDebug == true) 
} # for ($For1 = 1; $For1 <= $DrawCount; $For1++)

#==============================================================================================

  $FuncString = ""; # clear canvas line

  for ($For1 = 1; $For1 <= $CanvasHeight; $For1++) { # cycle draw lines
    $TmpString = $Line[$For1]; # set draw line
	$TmpInt = strlen($TmpString); # set length of draw line

    if ($TmpInt < $OriginX) { # if length of draw line less right side of canvas
	  for ($For2 = $TmpInt; $For2 < $OriginX; $For2++) { # cycle symbols of draw line
	    $TmpString = $TmpString . $SpaceChar; # add space to draw line
	  }	# for ($For2 = $TmpInt; $For2 < $OriginX; $For2++)
	} # if ($TmpInt < $OriginX)

	$TmpInt = strlen($CanvasBackChars) - 1; # set length of background string of symbols
	
    for ($For2 = 0; $For2 < $OriginX; $For2++) { # cycle symbols of draw line
      if ($TmpString[$For2] == $SpaceChar) { # if symbol is space char
	    $TmpString[$For2] = $CanvasBackChars[mt_rand(0, $TmpInt)]; # randomize space char
	  } # if ($TmpString[$For2] == $SpaceChar)
	} # for ($For2 = 0; $For2 < $OriginX; $For2++)
	
	$TmpInt = strlen($CanvasFrontChars) - 1; # set length of front string of symbols
	
	for ($For2 = 0; $For2 < $OriginX; $For2++) { # cycle symbols of draw line
      if ($TmpString[$For2] == $DrawChar) { # if symbol is draw char
	    $TmpString[$For2] = $CanvasFrontChars[mt_rand(0, $TmpInt)]; # randomize draw char
	  } # if ($TmpString[$For2] == $DrawChar)
    } # for ($For2 = 0; $For2 < $OriginX; $For2++)

	$TmpString = str_replace(" ", "&nbsp;", $TmpString); # change spaces to idents
	$FuncString = $FuncString . $TmpString . '<BR>'; # add draw line to canvas line
  } # for ($For1 = 1; $For1 <= $CanvasHeight; $For1++)

  return '<SPAN STYLE="font-family: Lucida Console, Terminal, Courier New, Courier, Monospace;'
  . ' font-size: ' . $FontSize . '">' . $FuncString . '</SPAN>'; # return canvas line
} # function func_console_captcha()

#==============================================================================================

?>
