<?php

/*
 * This file is part of the Symfony package.
 *
 * (c) Fabien Potencier <fabien@symfony.com>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace Symfony\Component\Validator\Constraints;

use Symfony\Component\Validator\Constraint;
use Symfony\Component\Validator\ConstraintValidator;
use Symfony\Component\Validator\Exception\UnexpectedTypeException;

/**
 * @author Bernhard Schussek <bschussek@gmail.com>
 *
 * @api
 */
class NullValidator extends ConstraintValidator
{
    /**
     * {@inheritdoc}
     */
    public function validate($value, Constraint $constraint)
    {
        if (!$constraint instanceof Null) {
            throw new UnexpectedTypeException($constraint, __NAMESPACE__.'\Null');
        }

        if (null !== $value) {
            if (is_object($value)) {
                $value = get_class($value);
            } elseif (is_array($value)) {
                $value = 'Array';
            }

            $this->context->addViolation($constraint->message, array('{{ value }}' => $value));
        }
    }
}
