<?php
/*
Copyright (c) 2013 phpsqlitesite.com

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.


text file search script
    
searches text file or url for user-entered string,
outputs line and location with context
*/

// set text file location here
$PATH   = 'pg19141.txt';
// if no location is set, an input field will be used (for a url)
#$PATH   = null;


$search = filter_input(INPUT_GET,'q',FILTER_SANITIZE_STRING);
$source = filter_input(INPUT_GET,'loc',FILTER_SANITIZE_STRING);
//enforce url, no local paths
if (!empty($source)) $PATH = 'http://'.preg_replace('@^http://@','',$source);

$FILE   = fopen($PATH,'r');


$results = '';
$line_number = 0;
$TEXT = '';
if ($FILE) {
    while (!feof($FILE)) {
        $buffer = fgetss($FILE, 4096);
        ++$line_number;
        $TEXT .= "<div id=\"line_$line_number\">$buffer</div>";
        $loc = preg_match('@('.preg_quote($search).')@i',$buffer);
        if ($loc > 0) {
            $results .= print_results($buffer,$search,$line_number,'line');
        }
    }
    fclose($FILE);
}

// takes $line as input, outputs formatted search results for $str
function print_results($line,$str,$lnum=null,$class=null) {
    $style = '';
    if (null != $class) $style = " class=\"$class\"";
    $res = "<div$style><span>$lnum</span>: ".preg_replace('@('.preg_quote($str).')@i',"<b>$1</b>",$line)."</div>";
    return $res;
}

$title = 'Search '.htmlspecialchars(basename($PATH));
$searched = " for '$search'";
?>
<!doctype html>
<html>
<head>
<title><?php echo $title, $searched; ?></title>
<meta name="keywords" content="site search, search script, text index, remote search">
<meta name="description" content="Use this free PHP script to search text of files located on your web server or contents of remote web sites">
<script type="text/javascript" src="//ajax.googleapis.com/ajax/libs/jquery/1.10.2/jquery.min.js"></script>

<script type="text/javascript">
    $(document).ready(function() {
        $('#results div').click(function() {
            baseOffset = $('#context').offset().top;
            baseOffset = $('#context').offsetTop;
            targetLine = $(this).children().filter('span:first').text();
            targetOffset = $('#line_'+targetLine).position().top;
            $('#context').animate({scrollTop: $('#context').scrollTop() + targetOffset}, 400);
             return false;
        });
    });
</script>
<style type="text/css">
.line {
    background:#ccccff;
    border:1px dotted #6666cc;
    cursor:pointer;
}
.line span {
    font-style:italic;
    font-size:90%;
}
label:after {
    content:': ';
}
.field label {
    width:80px;
    display:inline-block;
}
.field input {
    width:400px;
}
#results,#context {
    border:1px solid #ccc;
    padding:3px;
    min-width:300px;
    width:45%;
    float:left;
    height:600px;
    overflow:auto;
    position:relative;
}
#output {
    margin:19px auto;
    width:90%;
    position:relative;
}
#ad {
    float:right;
}
</style>
</head>
<body>
<h1><?php echo $title; ?></h1>

<div id="ad">
<script type="text/javascript"><!--
google_ad_client = "ca-pub-6842783303907583";
google_ad_slot = "4895617718";
google_ad_width = 320;
google_ad_height = 50;
//-->
</script>
<script type="text/javascript"
src="http://pagead2.googlesyndication.com/pagead/show_ads.js">
</script>
</div>

<form action="" method="GET">
<?php if (empty($PATH) || !empty($source)): ?>
<div class="field"><label for="source">Location</label><input type="text" name="loc" id="source" class="source" value="<?php echo $source; ?>"></div>
<?php endif; ?>
<div class="field"><label for="search">Search</label><input type="text" name="q" id="search" class="search" value="<?php echo $search; ?>"></div>
<input type="submit" value="Search">
</form>
<br>
<?php if (!empty($search)) echo "<h2>Searched $searched</h2>";?>
<div id="output">
<div id="results">
<?php echo $results;?>
</div>
<div class="context" id="context">
<?php echo '<pre>'.$TEXT.'</pre>';?>
</div>
</div>
</body>
</html>
