﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.ComponentModel.DataAnnotations;
using DataAnnotationsSample.CustomAttributes;

namespace DataAnnotationsSample.Models
{
    class ContactMetaData
    {
        [Required(ErrorMessage="First Name is required")]
        [StringLength(15, ErrorMessage = "First Name length Should be less than 50")]
        public string FirstName { get; set; }

        [Required(ErrorMessage = "Last Name is required")]
        [StringLength(50, ErrorMessage = "Last Name length Should be less than 50")]
        public string LastName { get; set; }

        [Required(ErrorMessage = "Address is required")]
        [StringLength(100, ErrorMessage = "Address length Should be less than 100")]
        public string Address { get; set; }

        [Required(ErrorMessage = "Phone Number is required")]
        [StringLength(15, ErrorMessage = "Phone Number length Should be less than 15")]
        [RegularExpression(@"^[0-9]{0,15}$", ErrorMessage = "PhoneNumber should contain only numbers")]
        [UniquePhoneNumber]
        public string PhoneNumber { get; set; }

        [Required(ErrorMessage = "eMail is required")]
        [StringLength(35, ErrorMessage = "eMail Length Should be less than 35")]
        [RegularExpression(@"^\w+@[a-zA-Z_]+?\.[a-zA-Z]{2,3}$", ErrorMessage = "eMail is not in proper format")]
        public string eMail { get; set; }

        [Required(ErrorMessage="Age is Required")]
        [Minimumvalue(18)]
        public int Age { get; set; }
    }
}
