﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.ComponentModel.DataAnnotations;
using System.Web.Mvc;
using DataAnnotationsSample.Models;

namespace DataAnnotationsSample.CustomAttributes
{
    public class UniquePhoneNumberAttribute : ValidationAttribute
    {
        protected override ValidationResult IsValid(object value, ValidationContext validationContext)
        {
            string number = value as string;
            Contact contact = validationContext.ObjectInstance as Contact;

            if (number != null) 
            {
                using (SampleDbEntities db = new SampleDbEntities())
                {
                    var contactFound = db.Contacts.FirstOrDefault(item => item.PhoneNumber.Trim().Equals(number.Trim(), StringComparison.OrdinalIgnoreCase));
                    if (contactFound != null && contactFound.ID != contact.ID)
                    {
                        return new ValidationResult("Same phone number exists in the application.");
                    }
                }
            }

            return ValidationResult.Success;
        }
    }
}