﻿using System;
using System.Collections.Generic;
using System.Data;
using System.Data.Entity;
using System.Linq;
using System.Web;
using System.Web.Mvc;
using DataAnnotationsSample.Models;

namespace DataAnnotationsSample.Controllers
{ 
    public class ContactController : Controller
    {
        private SampleDbEntities db = new SampleDbEntities();

        public ViewResult Index()
        {
            return View(db.Contacts.ToList());
        }

        public ViewResult Details(int id)
        {
            Contact contact = db.Contacts.Single(c => c.ID == id);
            return View(contact);
        }

        public ActionResult Create()
        {
            return View();
        } 

        [HttpPost]
        public ActionResult Create(Contact contact)
        {
            if (ModelState.IsValid)
            {
                db.Contacts.AddObject(contact);
                db.SaveChanges();
                return RedirectToAction("Index");  
            }

            return View(contact);
        }
         
        public ActionResult Edit(int id)
        {
            Contact contact = db.Contacts.Single(c => c.ID == id);
            return View(contact);
        }

        [HttpPost]
        public ActionResult Edit(Contact contact)
        {
            if (ModelState.IsValid)
            {
                db.Contacts.Attach(contact);
                db.ObjectStateManager.ChangeObjectState(contact, EntityState.Modified);
                db.SaveChanges();
                return RedirectToAction("Index");
            }
            return View(contact);
        }
 
        public ActionResult Delete(int id)
        {
            Contact contact = db.Contacts.Single(c => c.ID == id);
            return View(contact);
        }

        [HttpPost, ActionName("Delete")]
        public ActionResult DeleteConfirmed(int id)
        {            
            Contact contact = db.Contacts.Single(c => c.ID == id);
            db.Contacts.DeleteObject(contact);
            db.SaveChanges();
            return RedirectToAction("Index");
        }

        protected override void Dispose(bool disposing)
        {
            db.Dispose();
            base.Dispose(disposing);
        }
    }
}