﻿<%@ Page Language="C#" AutoEventWireup="true" CodeFile="JSTestAll.aspx.cs" Inherits="JSTestAllPage" %>

<!DOCTYPE html>

<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <title></title>
    <script type="text/javascript" src="TestFilesInfo.js"></script>


    <script type="text/javascript">

        /* 
            A variable to create unique ids for dynamicly created iframes
        */
        var iframeNumber = 0;

        /*
         * Creates a new dynamic iframe and appends it to the document body
           If you are changing this method be sure that it is compatible with JSTest file
        */
        function __CreateNewIframeUrl(pageUrl, height, width) {
            iframe = document.createElement('iframe');
            iframe.id = "mainIFrame" + iframeNumber;
            iframe.width = width;
            iframe.height = height;
            iframe.src = pageUrl;
            iframeNumber++;
            document.body.appendChild(iframe);
            return iframe;
        }

        /*
          Executes all available test cases
        */
        function ExecuteAllTests()
        {
            var testList = TestFilesInfo.GetTestList();
            for (var i = 0; i < testList.length; i++)
            {
                ExecuteTest(testList[i]);
            }
        }

        /*
          Executes a single test suite file using its Url
        */
        function ExecuteTest(testUrl)
        {
            var url = "JSTest.aspx?TestCase=" + testUrl;
            var title = testUrl.replace("/", " ");
            title = title.replace(".js", "");

            __CreateTestTitleElement(url, title);
            __CreateNewIframeUrl(url, 100, 800);
        }


        /*
            * Creates a link to a test case file 
            It helps to run a single test file later if any error happened
        */
        function __CreateTestTitleElement(url, title) {
            var div = document.createElement("div");
            div.innerHTML = "<a href='" + url + "' target='_blank'>" + title + "</a>";
            document.body.appendChild(div);
        }

        window.onload = function ()
        {
            ExecuteAllTests();
        }

    </script>


</head>
<body>
    <!-- body is empty :) we add everything in our javascript code. -->
    <form id="form1" runat="server">
    <div>

    </div>
    </form>
</body>
</html>
