﻿var ExtTestUtils = {

    /* 
        finds a button in a messagebox  
        buttonName: can be 'yes', 'no', 'ok', 'cancel'
    */
    messageBoxFindButton :function(msgBoxObject, buttonName)
    {
        return msgBoxObject.bottomTb.items.get(buttonName);
    },

    /* clicks on a message box button 
       buttonName: can be 'yes', 'no', 'ok', 'cancel'    
    */
    messageBoxButtonClick: function (msgBoxObject, buttonName) {
        var btn = ExtTestUtils.messageBoxFindButton(msgBoxObject, buttonName);
        ExtTestUtils.buttonClick(btn);
    },

    /* clicks on a button */
    buttonClick: function (btn) {
        btn.btnEl.dom.click();
        //btn.fireEvent('click', btn);
        //btn.handler.call(btn.scope, btn, Ext.EventObject);
    },

    clickByXPath: function(doc, xpath)
    {
        var element = doc.evaluate(xpath, doc, null, 9, null).singleNodeValue;
        if (element != null) {
            element.click();
        }

    },

    setComboValue: function (combo, value) {
        combo.setValue(value); // set the value
        combo.fireEvent('select'); // because setValue() doesn't trigger the event
    },


    selectGridRow: function(grid, rowIndex) {
        return grid.getSelectionModel().selectRow(rowIndex, true);
    }


}