﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;

/// <summary>
/// Summary description for BasePage
/// This is a base class for some of the pages in the application
/// This have the same function that they check query string for a value and if it was there, they create an object using it.
/// I just put it here to show that how an abstract class can be tested using fake pages in our JSTest.aspx file
/// </summary>
public class BasePage : System.Web.UI.Page
{
    public EntityBase Entity { get; set; }

    protected override void OnInit(EventArgs e)
    {
        base.OnInit(e);

        // It is a very simple computation from QueryString, but it can be very complicated in a real application
        // It just checks QueryString, and if Entity was there, it creates an object using this parameter
        string entity = Request.QueryString["Entity"];
        if (string.IsNullOrEmpty(entity) == false)
        {
            switch (entity)
            {
                case "User":
                    this.Entity = new UserEntity();
                    break;
                case "Role":
                    this.Entity = new RoleEntity();
                    break;
                default:
                    break;
            }
        }

    }
}