﻿using System;
using System.Data;


namespace WebControls
{
    public partial class _Default : System.Web.UI.Page
    {
        private int color;
        protected void Page_Load(object sender, EventArgs e)
        {
            if (!IsPostBack)
            {
                color = 1;
                Button1.Text = "Disable Control";
            }
        }

        protected override object SaveViewState()
        {
            ViewState["Color"] = color;
            return base.SaveViewState();
        }

        /// <summary>
        /// Restores the view-state information from a previous user control request that was saved by the <see cref="M:System.Web.UI.UserControl.SaveViewState"></see> method.
        /// </summary>
        /// <param name="savedState">An <see cref="T:System.Object"></see> that represents the user control state to be restored.</param>
        protected override void LoadViewState(object savedState)
        {
            base.LoadViewState(savedState);
            if (ViewState["Color"] != null)
            {
                color = (int)ViewState["Color"];
            }
        }

        protected void LookUp1_OnRowClick(object sender, LookUpSearch.LookUp.RowData e)
        {

            TextBox1.Text = string.Empty;
            if (e.DataTable.Rows.Count > 0)
            {
                TextBox1.Text = e.DataTable.Rows[0]["OuCode"].ToString();
                Oudescripion1.Text = e.DataTable.Rows[0]["OuDescription"].ToString();
                Lm1.Text = e.DataTable.Rows[0]["LM"].ToString();
                LmName1.Text = e.DataTable.Rows[0]["LMName"].ToString();

            }
        }

        protected void LookUp2_OnRowClick(object sender, LookUpSearch.LookUp.RowData e)
        {

            TextBox2.Text = string.Empty;

            if (e.DataTable.Rows.Count > 0)
            {

                foreach (DataRow row in e.DataTable.Rows)
                {
                    TextBox2.Text = string.Format("{1},{0}", ((LookUpSearch.LookUp)(sender)).TargetTextBox.Text,
                        row["OuCode"]);
                }
                TextBox2.Text = TextBox2.Text.TrimEnd(',');
                Oudescripion2.Text = e.DataTable.Rows[0]["OuDescription"].ToString();
                Lm2.Text = e.DataTable.Rows[0]["LM"].ToString();
            }

        }


        protected void Button1_Click(object sender, EventArgs e)
        {
            if (Button1.Text == "Enable Control")
            {
                TextBox4.Enabled = true;
                Button1.Text = "Disable Control";
            }
            else
            {
                TextBox4.Enabled = false;
                Button1.Text = "Enable Control";
            }
        }

        protected void LookUp3_OnRowClick1(object sender, LookUpSearch.LookUp.RowData e)
        {
            ((LookUpSearch.LookUp)(sender)).TargetTextBox.Text = e.DataTable.Rows[0]["OuCode"].ToString();
        }




        protected void LookUp4_OnRowClick(object sender, LookUpSearch.LookUp.RowData e)
        {

            TextBox4.Text = string.Empty;

            if (e.DataTable.Rows.Count > 0)
            {

                TextBox4.Text = string.Format("{0}", e.DataTable.Rows[0]["OuCode"]);
                lbl4_Description.Text = e.DataTable.Rows[0]["OuCode"].ToString();
                lbl4_lmodify.Text = e.DataTable.Rows[0]["LastChange"].ToString();

            }

        }

        protected void LookUp5_OnRowClick(object sender, LookUpSearch.LookUp.RowData e)
        {
            TextBox4.Text = string.Empty;
            if (e.DataTable.Rows.Count > 0)
            {

                TextBox5.Text = string.Format("{0}", e.DataTable.Rows[0]["OuCode"]);

            }

        }
    }
}
