using System.Web.UI.WebControls;
using System.Web.UI;

namespace LookUpSearch
{
	/// <summary>
	/// Templated table cell class
	/// </summary>
	internal class TableCellItem : TableCell, IDataItemContainer
	{

		/// <summary>
		/// Initializes a new instance of the <see cref="TableCellItem"/> class.
		/// </summary>
		/// <param name="dataItem">The data item.</param>
		/// <param name="index">The index.</param>
		public TableCellItem(object dataItem, int index)
		{
			this.DataItem = dataItem;
		}

		/// <summary>
		/// When implemented, gets an object that is used in simplified data-binding operations.
		/// </summary>
		/// <value></value>
		/// <returns>An object that represents the value to use when data-binding operations are performed.</returns>
		public object DataItem
		{
			get;
			private set;
		}

		/// <summary>
		/// When implemented, gets the index of the data item bound to a control.
		/// </summary>
		/// <value></value>
		/// <returns>An Integer representing the index of the data item in the data source.</returns>
		public int DataItemIndex
		{
			get { return 0; }
		}

		/// <summary>
		/// When implemented, gets the position of the data item as displayed in a control.
		/// </summary>
		/// <value></value>
		/// <returns>An Integer representing the position of the data item as displayed in a control.</returns>
		public int DisplayIndex
		{
			get { return 0; }
		}

		/// <summary>
		/// Adds properties specific to the <see cref="T:System.Web.UI.WebControls.TableCell"></see> control to the list of attributes to render.
		/// </summary>
		/// <param name="writer">The output stream that renders HTML content to the client.</param>
		/// <exception cref="T:System.Web.HttpException">A cell listed as an associated header cell was not found.</exception>
		protected override void AddAttributesToRender(HtmlTextWriter writer)
		{
			writer.AddAttribute("nowrap", null);
			base.AddAttributesToRender(writer);
		}
	}
}
